@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ApplicationLoadBalancer].
 */
@PulumiTagMarker
public class ApplicationLoadBalancerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationLoadBalancerArgs = ApplicationLoadBalancerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationLoadBalancerArgsBuilder.() -> Unit) {
        val builder = ApplicationLoadBalancerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationLoadBalancer {
        val builtJavaResource = com.pulumi.alicloud.slb.ApplicationLoadBalancer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApplicationLoadBalancer(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Load balancer can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/applicationLoadBalancer:ApplicationLoadBalancer example lb-abc123456
 * ```
 */
public class ApplicationLoadBalancer internal constructor(
    override val javaResource: com.pulumi.alicloud.slb.ApplicationLoadBalancer,
) : KotlinCustomResource(javaResource, ApplicationLoadBalancerMapper) {
    /**
     * Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the corresponding switch.
     */
    public val address: Output<String>
        get() = javaResource.address().applyValue({ args0 -> args0 })

    /**
     * The IP version of the SLB instance to be created, which can be set to `ipv4` or `ipv6` . Default to `ipv4`. Now, only internet instance support `ipv6` address.
     */
    public val addressIpVersion: Output<String>?
        get() = javaResource.addressIpVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be `intranet`.
     * - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
     * - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
     */
    public val addressType: Output<String>
        get() = javaResource.addressType().applyValue({ args0 -> args0 })

    /**
     * Valid value is between 1 and 5120, If argument `internet_charge_type` is `PayByTraffic`, then this value will be ignored.
     */
    public val bandwidth: Output<Int>?
        get() = javaResource.bandwidth().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
     */
    public val deleteProtection: Output<String>?
        get() = javaResource.deleteProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Support `PayBySpec` (default) and `PayByCLCU`, This parameter takes effect when the value of **payment_type** (instance payment mode) is **PayAsYouGo** (pay-as-you-go).
     */
    public val instanceChargeType: Output<String>
        get() = javaResource.instanceChargeType().applyValue({ args0 -> args0 })

    /**
     * Valid values are `PayByBandwidth`, `PayByTraffic`. If this value is `PayByBandwidth`, then argument `address_type` must be `internet`. Default is `PayByTraffic`. If load balancer launched in VPC, this value must be `PayByTraffic`. Before version 1.10.1, the valid values are `paybybandwidth` and `paybytraffic`.
     */
    public val internetChargeType: Output<String>?
        get() = javaResource.internetChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val loadBalancerName: Output<String>
        get() = javaResource.loadBalancerName().applyValue({ args0 -> args0 })

    /**
     * The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
     * Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`,
     * `slb.s3.small`, `slb.s3.medium`, `slb.s3.large` and `slb.s4.large`. It will be ignored when `instance_charge_type = "PayByCLCU"`.
     */
    public val loadBalancerSpec: Output<String>
        get() = javaResource.loadBalancerSpec().applyValue({ args0 -> args0 })

    /**
     * The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the [DescribeZone](https://help.aliyun.com/document_detail/27585.htm) API.
     */
    public val masterZoneId: Output<String>
        get() = javaResource.masterZoneId().applyValue({ args0 -> args0 })

    /**
     * The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
     */
    public val modificationProtectionReason: Output<String>?
        get() = javaResource.modificationProtectionReason().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value is `NonProtection`.
     */
    public val modificationProtectionStatus: Output<String>
        get() = javaResource.modificationProtectionStatus().applyValue({ args0 -> args0 })

    /**
     * Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name'
      instead
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The duration that you will buy the resource, in month. It is valid when `PaymentType` is `Subscription`. Default to 1. Valid values: [1-9, 12, 24, 36]. This attribute is only used to create `Subscription` instance or modify the `PayAsYouGo` instance to `Subscription`. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The id of resource group which the SLB belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
     */
    public val slaveZoneId: Output<String>
        get() = javaResource.slaveZoneId().applyValue({ args0 -> args0 })

    /**
     * Field `specification` has been deprecated from provider version 1.123.1 New field `load_balancer_spec` instead.
     */
    @Deprecated(
        message = """
  Field 'specification' has been deprecated from provider version 1.123.1. New field
      'load_balancer_spec' instead
  """,
    )
    public val specification: Output<String>
        get() = javaResource.specification().applyValue({ args0 -> args0 })

    /**
     * The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance. This filed mark as `Computed` since v1.217.1.
     */
    public val tags: Output<Map<String, String>>
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The VSwitch ID to launch in. **Note:** Required for a VPC SLB. If `address_type` is internet, it will be ignored.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ApplicationLoadBalancerMapper : ResourceMapper<ApplicationLoadBalancer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.slb.ApplicationLoadBalancer::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationLoadBalancer =
        ApplicationLoadBalancer(javaResource as com.pulumi.alicloud.slb.ApplicationLoadBalancer)
}

/**
 * @see [ApplicationLoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationLoadBalancer].
 */
public suspend fun applicationLoadBalancer(
    name: String,
    block: suspend ApplicationLoadBalancerResourceBuilder.() -> Unit,
): ApplicationLoadBalancer {
    val builder = ApplicationLoadBalancerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationLoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationLoadBalancer(name: String): ApplicationLoadBalancer {
    val builder = ApplicationLoadBalancerResourceBuilder()
    builder.name(name)
    return builder.build()
}
