@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.alicloud.slb.ApplicationLoadBalancerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Load balancer can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/applicationLoadBalancer:ApplicationLoadBalancer example lb-abc123456
 * ```
 * @property address Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the corresponding switch.
 * @property addressIpVersion The IP version of the SLB instance to be created, which can be set to `ipv4` or `ipv6` . Default to `ipv4`. Now, only internet instance support `ipv6` address.
 * @property addressType The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be `intranet`.
 * - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
 * - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
 * @property bandwidth Valid value is between 1 and 5120, If argument `internet_charge_type` is `PayByTraffic`, then this value will be ignored.
 * @property deleteProtection Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
 * @property instanceChargeType Support `PayBySpec` (default) and `PayByCLCU`, This parameter takes effect when the value of **payment_type** (instance payment mode) is **PayAsYouGo** (pay-as-you-go).
 * @property internetChargeType Valid values are `PayByBandwidth`, `PayByTraffic`. If this value is `PayByBandwidth`, then argument `address_type` must be `internet`. Default is `PayByTraffic`. If load balancer launched in VPC, this value must be `PayByTraffic`. Before version 1.10.1, the valid values are `paybybandwidth` and `paybytraffic`.
 * @property loadBalancerName
 * @property loadBalancerSpec The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
 * Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`,
 * `slb.s3.small`, `slb.s3.medium`, `slb.s3.large` and `slb.s4.large`. It will be ignored when `instance_charge_type = "PayByCLCU"`.
 * @property masterZoneId The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the [DescribeZone](https://help.aliyun.com/document_detail/27585.htm) API.
 * @property modificationProtectionReason The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
 * @property modificationProtectionStatus The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value is `NonProtection`.
 * @property name Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
 * @property paymentType The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
 * @property period The duration that you will buy the resource, in month. It is valid when `PaymentType` is `Subscription`. Default to 1. Valid values: [1-9, 12, 24, 36]. This attribute is only used to create `Subscription` instance or modify the `PayAsYouGo` instance to `Subscription`. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
 * @property resourceGroupId The id of resource group which the SLB belongs.
 * @property slaveZoneId The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
 * @property specification Field `specification` has been deprecated from provider version 1.123.1 New field `load_balancer_spec` instead.
 * @property status The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.
 * @property tags A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance. This filed mark as `Computed` since v1.217.1.
 * @property vswitchId The VSwitch ID to launch in. **Note:** Required for a VPC SLB. If `address_type` is internet, it will be ignored.
 */
public data class ApplicationLoadBalancerArgs(
    public val address: Output<String>? = null,
    public val addressIpVersion: Output<String>? = null,
    public val addressType: Output<String>? = null,
    public val bandwidth: Output<Int>? = null,
    public val deleteProtection: Output<String>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val loadBalancerName: Output<String>? = null,
    public val loadBalancerSpec: Output<String>? = null,
    public val masterZoneId: Output<String>? = null,
    public val modificationProtectionReason: Output<String>? = null,
    public val modificationProtectionStatus: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name'
      instead
  """,
    )
    public val name: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val slaveZoneId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'specification' has been deprecated from provider version 1.123.1. New field
      'load_balancer_spec' instead
  """,
    )
    public val specification: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.ApplicationLoadBalancerArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.ApplicationLoadBalancerArgs =
        com.pulumi.alicloud.slb.ApplicationLoadBalancerArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .addressIpVersion(addressIpVersion?.applyValue({ args0 -> args0 }))
            .addressType(addressType?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .deleteProtection(deleteProtection?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .loadBalancerSpec(loadBalancerSpec?.applyValue({ args0 -> args0 }))
            .masterZoneId(masterZoneId?.applyValue({ args0 -> args0 }))
            .modificationProtectionReason(modificationProtectionReason?.applyValue({ args0 -> args0 }))
            .modificationProtectionStatus(modificationProtectionStatus?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .slaveZoneId(slaveZoneId?.applyValue({ args0 -> args0 }))
            .specification(specification?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationLoadBalancerArgs].
 */
@PulumiTagMarker
public class ApplicationLoadBalancerArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var addressIpVersion: Output<String>? = null

    private var addressType: Output<String>? = null

    private var bandwidth: Output<Int>? = null

    private var deleteProtection: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var loadBalancerName: Output<String>? = null

    private var loadBalancerSpec: Output<String>? = null

    private var masterZoneId: Output<String>? = null

    private var modificationProtectionReason: Output<String>? = null

    private var modificationProtectionStatus: Output<String>? = null

    private var name: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var resourceGroupId: Output<String>? = null

    private var slaveZoneId: Output<String>? = null

    private var specification: Output<String>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the corresponding switch.
     */
    @JvmName("ybaakvvfautikihl")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The IP version of the SLB instance to be created, which can be set to `ipv4` or `ipv6` . Default to `ipv4`. Now, only internet instance support `ipv6` address.
     */
    @JvmName("bedamdysjyanwixq")
    public suspend fun addressIpVersion(`value`: Output<String>) {
        this.addressIpVersion = value
    }

    /**
     * @param value The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be `intranet`.
     * - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
     * - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
     */
    @JvmName("tjutljnwkvymohkc")
    public suspend fun addressType(`value`: Output<String>) {
        this.addressType = value
    }

    /**
     * @param value Valid value is between 1 and 5120, If argument `internet_charge_type` is `PayByTraffic`, then this value will be ignored.
     */
    @JvmName("lopdpnvrrycglrko")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
     */
    @JvmName("afdmcoxfwlynjepm")
    public suspend fun deleteProtection(`value`: Output<String>) {
        this.deleteProtection = value
    }

    /**
     * @param value Support `PayBySpec` (default) and `PayByCLCU`, This parameter takes effect when the value of **payment_type** (instance payment mode) is **PayAsYouGo** (pay-as-you-go).
     */
    @JvmName("vahssnklflysymje")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value Valid values are `PayByBandwidth`, `PayByTraffic`. If this value is `PayByBandwidth`, then argument `address_type` must be `internet`. Default is `PayByTraffic`. If load balancer launched in VPC, this value must be `PayByTraffic`. Before version 1.10.1, the valid values are `paybybandwidth` and `paybytraffic`.
     */
    @JvmName("tjhqksjwfkertdqo")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value
     */
    @JvmName("qfjlypuuglsulcaf")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
     * Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`,
     * `slb.s3.small`, `slb.s3.medium`, `slb.s3.large` and `slb.s4.large`. It will be ignored when `instance_charge_type = "PayByCLCU"`.
     */
    @JvmName("sdqqvmgarixqfhyl")
    public suspend fun loadBalancerSpec(`value`: Output<String>) {
        this.loadBalancerSpec = value
    }

    /**
     * @param value The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the [DescribeZone](https://help.aliyun.com/document_detail/27585.htm) API.
     */
    @JvmName("cljeoujkfgehjldw")
    public suspend fun masterZoneId(`value`: Output<String>) {
        this.masterZoneId = value
    }

    /**
     * @param value The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
     */
    @JvmName("lgmjttfrcfamdvpo")
    public suspend fun modificationProtectionReason(`value`: Output<String>) {
        this.modificationProtectionReason = value
    }

    /**
     * @param value The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value is `NonProtection`.
     */
    @JvmName("jpdgemawcjiqplae")
    public suspend fun modificationProtectionStatus(`value`: Output<String>) {
        this.modificationProtectionStatus = value
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name'
      instead
  """,
    )
    @JvmName("qdcmwmehfefyljvf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
     */
    @JvmName("odptnmwexexejofi")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid when `PaymentType` is `Subscription`. Default to 1. Valid values: [1-9, 12, 24, 36]. This attribute is only used to create `Subscription` instance or modify the `PayAsYouGo` instance to `Subscription`. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
     */
    @JvmName("wevatgtagwxdjgki")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The id of resource group which the SLB belongs.
     */
    @JvmName("tpefrecryjesoobg")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
     */
    @JvmName("ujqbnidqbcwronmm")
    public suspend fun slaveZoneId(`value`: Output<String>) {
        this.slaveZoneId = value
    }

    /**
     * @param value Field `specification` has been deprecated from provider version 1.123.1 New field `load_balancer_spec` instead.
     */
    @Deprecated(
        message = """
  Field 'specification' has been deprecated from provider version 1.123.1. New field
      'load_balancer_spec' instead
  """,
    )
    @JvmName("kqtvgjbfpdqulfkp")
    public suspend fun specification(`value`: Output<String>) {
        this.specification = value
    }

    /**
     * @param value The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.
     */
    @JvmName("gfsvyiakwijftqnk")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance. This filed mark as `Computed` since v1.217.1.
     */
    @JvmName("yjsguebkmihoukle")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VSwitch ID to launch in. **Note:** Required for a VPC SLB. If `address_type` is internet, it will be ignored.
     */
    @JvmName("xflhcfnjqtdprxyo")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the corresponding switch.
     */
    @JvmName("enupjovgmhoyvglu")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The IP version of the SLB instance to be created, which can be set to `ipv4` or `ipv6` . Default to `ipv4`. Now, only internet instance support `ipv6` address.
     */
    @JvmName("xsbbdoysmcdudich")
    public suspend fun addressIpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressIpVersion = mapped
    }

    /**
     * @param value The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be `intranet`.
     * - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
     * - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
     */
    @JvmName("sivcrfjvfumsofdw")
    public suspend fun addressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressType = mapped
    }

    /**
     * @param value Valid value is between 1 and 5120, If argument `internet_charge_type` is `PayByTraffic`, then this value will be ignored.
     */
    @JvmName("vggsfkhfevcdapxq")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
     */
    @JvmName("flkqxryfetrhjpgl")
    public suspend fun deleteProtection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteProtection = mapped
    }

    /**
     * @param value Support `PayBySpec` (default) and `PayByCLCU`, This parameter takes effect when the value of **payment_type** (instance payment mode) is **PayAsYouGo** (pay-as-you-go).
     */
    @JvmName("hdjowefadgypjakl")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value Valid values are `PayByBandwidth`, `PayByTraffic`. If this value is `PayByBandwidth`, then argument `address_type` must be `internet`. Default is `PayByTraffic`. If load balancer launched in VPC, this value must be `PayByTraffic`. Before version 1.10.1, the valid values are `paybybandwidth` and `paybytraffic`.
     */
    @JvmName("tqbbwmqshfskrnbm")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value
     */
    @JvmName("voxoaxvbkwmwwrge")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
     * Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`,
     * `slb.s3.small`, `slb.s3.medium`, `slb.s3.large` and `slb.s4.large`. It will be ignored when `instance_charge_type = "PayByCLCU"`.
     */
    @JvmName("dlfjofiftlkgyrdf")
    public suspend fun loadBalancerSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerSpec = mapped
    }

    /**
     * @param value The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the [DescribeZone](https://help.aliyun.com/document_detail/27585.htm) API.
     */
    @JvmName("xobqjnsdxljdeobn")
    public suspend fun masterZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterZoneId = mapped
    }

    /**
     * @param value The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
     */
    @JvmName("cessvjeadqhxxlab")
    public suspend fun modificationProtectionReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modificationProtectionReason = mapped
    }

    /**
     * @param value The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value is `NonProtection`.
     */
    @JvmName("jhtwqiypnmjejxfn")
    public suspend fun modificationProtectionStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modificationProtectionStatus = mapped
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name'
      instead
  """,
    )
    @JvmName("ndflmdicsxedcurd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
     */
    @JvmName("ouvndgpkdbpqownk")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid when `PaymentType` is `Subscription`. Default to 1. Valid values: [1-9, 12, 24, 36]. This attribute is only used to create `Subscription` instance or modify the `PayAsYouGo` instance to `Subscription`. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
     */
    @JvmName("qfylojliackddsib")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The id of resource group which the SLB belongs.
     */
    @JvmName("dnjkoddnifstflkj")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
     */
    @JvmName("xtojepkqlyldgbhq")
    public suspend fun slaveZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slaveZoneId = mapped
    }

    /**
     * @param value Field `specification` has been deprecated from provider version 1.123.1 New field `load_balancer_spec` instead.
     */
    @Deprecated(
        message = """
  Field 'specification' has been deprecated from provider version 1.123.1. New field
      'load_balancer_spec' instead
  """,
    )
    @JvmName("ywcnrrljrlpwxwfh")
    public suspend fun specification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specification = mapped
    }

    /**
     * @param value The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.
     */
    @JvmName("iejkxhchevfvekws")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance. This filed mark as `Computed` since v1.217.1.
     */
    @JvmName("pjndfpxxbsqovtvh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance. This filed mark as `Computed` since v1.217.1.
     */
    @JvmName("xfextouwbnxlasbi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VSwitch ID to launch in. **Note:** Required for a VPC SLB. If `address_type` is internet, it will be ignored.
     */
    @JvmName("ycuahauovuwusiit")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): ApplicationLoadBalancerArgs = ApplicationLoadBalancerArgs(
        address = address,
        addressIpVersion = addressIpVersion,
        addressType = addressType,
        bandwidth = bandwidth,
        deleteProtection = deleteProtection,
        instanceChargeType = instanceChargeType,
        internetChargeType = internetChargeType,
        loadBalancerName = loadBalancerName,
        loadBalancerSpec = loadBalancerSpec,
        masterZoneId = masterZoneId,
        modificationProtectionReason = modificationProtectionReason,
        modificationProtectionStatus = modificationProtectionStatus,
        name = name,
        paymentType = paymentType,
        period = period,
        resourceGroupId = resourceGroupId,
        slaveZoneId = slaveZoneId,
        specification = specification,
        status = status,
        tags = tags,
        vswitchId = vswitchId,
    )
}
