@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.alicloud.slb.kotlin.outputs.BackendServerBackendServer
import com.pulumi.alicloud.slb.kotlin.outputs.BackendServerBackendServer.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BackendServer].
 */
@PulumiTagMarker
public class BackendServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackendServerArgs = BackendServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackendServerArgsBuilder.() -> Unit) {
        val builder = BackendServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BackendServer {
        val builtJavaResource = com.pulumi.alicloud.slb.BackendServer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BackendServer(builtJavaResource)
    }
}

/**
 * Add a group of backend servers (ECS or ENI instance) to the Server Load Balancer or remove them from it.
 * > **NOTE:** Available in 1.53.0+
 * ## Import
 * Load balancer backend server can be imported using the load balancer id.
 * ```sh
 * $ pulumi import alicloud:slb/backendServer:BackendServer example <load_balancer_id>
 * ```
 */
public class BackendServer internal constructor(
    override val javaResource: com.pulumi.alicloud.slb.BackendServer,
) : KotlinCustomResource(javaResource, BackendServerMapper) {
    /**
     * A list of instances to added backend server in the SLB. It contains three sub-fields as `Block server` follows.
     */
    public val backendServers: Output<List<BackendServerBackendServer>>?
        get() = javaResource.backendServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Checking DeleteProtection of SLB instance before deleting. If true, this resource will not be deleted when its SLB instance enabled DeleteProtection. Default to false.
     */
    public val deleteProtectionValidation: Output<Boolean>?
        get() = javaResource.deleteProtectionValidation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the load balancer.
     */
    public val loadBalancerId: Output<String>
        get() = javaResource.loadBalancerId().applyValue({ args0 -> args0 })
}

public object BackendServerMapper : ResourceMapper<BackendServer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.slb.BackendServer::class == javaResource::class

    override fun map(javaResource: Resource): BackendServer = BackendServer(
        javaResource as
            com.pulumi.alicloud.slb.BackendServer,
    )
}

/**
 * @see [BackendServer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackendServer].
 */
public suspend fun backendServer(
    name: String,
    block: suspend BackendServerResourceBuilder.() -> Unit,
): BackendServer {
    val builder = BackendServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackendServer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backendServer(name: String): BackendServer {
    val builder = BackendServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
