@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.alicloud.slb.BackendServerArgs.builder
import com.pulumi.alicloud.slb.kotlin.inputs.BackendServerBackendServerArgs
import com.pulumi.alicloud.slb.kotlin.inputs.BackendServerBackendServerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Add a group of backend servers (ECS or ENI instance) to the Server Load Balancer or remove them from it.
 * > **NOTE:** Available in 1.53.0+
 * ## Import
 * Load balancer backend server can be imported using the load balancer id.
 * ```sh
 * $ pulumi import alicloud:slb/backendServer:BackendServer example <load_balancer_id>
 * ```
 * @property backendServers A list of instances to added backend server in the SLB. It contains three sub-fields as `Block server` follows.
 * @property deleteProtectionValidation Checking DeleteProtection of SLB instance before deleting. If true, this resource will not be deleted when its SLB instance enabled DeleteProtection. Default to false.
 * @property loadBalancerId ID of the load balancer.
 */
public data class BackendServerArgs(
    public val backendServers: Output<List<BackendServerBackendServerArgs>>? = null,
    public val deleteProtectionValidation: Output<Boolean>? = null,
    public val loadBalancerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.BackendServerArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.BackendServerArgs =
        com.pulumi.alicloud.slb.BackendServerArgs.builder()
            .backendServers(
                backendServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deleteProtectionValidation(deleteProtectionValidation?.applyValue({ args0 -> args0 }))
            .loadBalancerId(loadBalancerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackendServerArgs].
 */
@PulumiTagMarker
public class BackendServerArgsBuilder internal constructor() {
    private var backendServers: Output<List<BackendServerBackendServerArgs>>? = null

    private var deleteProtectionValidation: Output<Boolean>? = null

    private var loadBalancerId: Output<String>? = null

    /**
     * @param value A list of instances to added backend server in the SLB. It contains three sub-fields as `Block server` follows.
     */
    @JvmName("inpvbsnpkdnqslds")
    public suspend fun backendServers(`value`: Output<List<BackendServerBackendServerArgs>>) {
        this.backendServers = value
    }

    @JvmName("mcshwvjlfsvqptyd")
    public suspend fun backendServers(vararg values: Output<BackendServerBackendServerArgs>) {
        this.backendServers = Output.all(values.asList())
    }

    /**
     * @param values A list of instances to added backend server in the SLB. It contains three sub-fields as `Block server` follows.
     */
    @JvmName("pyumxfyghdwhjuiq")
    public suspend fun backendServers(values: List<Output<BackendServerBackendServerArgs>>) {
        this.backendServers = Output.all(values)
    }

    /**
     * @param value Checking DeleteProtection of SLB instance before deleting. If true, this resource will not be deleted when its SLB instance enabled DeleteProtection. Default to false.
     */
    @JvmName("ueygbxefdmurjcpk")
    public suspend fun deleteProtectionValidation(`value`: Output<Boolean>) {
        this.deleteProtectionValidation = value
    }

    /**
     * @param value ID of the load balancer.
     */
    @JvmName("ynbtyjvhxaavwwaa")
    public suspend fun loadBalancerId(`value`: Output<String>) {
        this.loadBalancerId = value
    }

    /**
     * @param value A list of instances to added backend server in the SLB. It contains three sub-fields as `Block server` follows.
     */
    @JvmName("ogaebwvcvntuoxha")
    public suspend fun backendServers(`value`: List<BackendServerBackendServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendServers = mapped
    }

    /**
     * @param argument A list of instances to added backend server in the SLB. It contains three sub-fields as `Block server` follows.
     */
    @JvmName("sgsehooxdsomucpk")
    public suspend fun backendServers(argument: List<suspend BackendServerBackendServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BackendServerBackendServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backendServers = mapped
    }

    /**
     * @param argument A list of instances to added backend server in the SLB. It contains three sub-fields as `Block server` follows.
     */
    @JvmName("lokueyqlpxscxpco")
    public suspend fun backendServers(vararg argument: suspend BackendServerBackendServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BackendServerBackendServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backendServers = mapped
    }

    /**
     * @param argument A list of instances to added backend server in the SLB. It contains three sub-fields as `Block server` follows.
     */
    @JvmName("gysxebosxyrgerwk")
    public suspend fun backendServers(argument: suspend BackendServerBackendServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BackendServerBackendServerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.backendServers = mapped
    }

    /**
     * @param values A list of instances to added backend server in the SLB. It contains three sub-fields as `Block server` follows.
     */
    @JvmName("olfplbeijkaydyey")
    public suspend fun backendServers(vararg values: BackendServerBackendServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendServers = mapped
    }

    /**
     * @param value Checking DeleteProtection of SLB instance before deleting. If true, this resource will not be deleted when its SLB instance enabled DeleteProtection. Default to false.
     */
    @JvmName("uamdacktonkdnllm")
    public suspend fun deleteProtectionValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteProtectionValidation = mapped
    }

    /**
     * @param value ID of the load balancer.
     */
    @JvmName("gtixbvjjukqceuua")
    public suspend fun loadBalancerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerId = mapped
    }

    internal fun build(): BackendServerArgs = BackendServerArgs(
        backendServers = backendServers,
        deleteProtectionValidation = deleteProtectionValidation,
        loadBalancerId = loadBalancerId,
    )
}
