@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.alicloud.slb.kotlin.outputs.ListenerXForwardedFor
import com.pulumi.alicloud.slb.kotlin.outputs.ListenerXForwardedFor.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Listener].
 */
@PulumiTagMarker
public class ListenerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerArgs = ListenerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerArgsBuilder.() -> Unit) {
        val builder = ListenerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Listener {
        val builtJavaResource = com.pulumi.alicloud.slb.Listener(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Listener(builtJavaResource)
    }
}

/**
 * Provides a Classic Load Balancer (SLB) Load Balancer Listener resource.
 * For information about Classic Load Balancer (SLB) and how to use it, see [What is Classic Load Balancer](https://www.alibabacloud.com/help/doc-detail/27539.htm).
 * For information about listener and how to use it, please see the following:
 * * [Configure a HTTP Classic Load Balancer (SLB) Listener](https://www.alibabacloud.com/help/doc-detail/27592.htm).
 * * [Configure a HTTPS Classic Load Balancer (SLB) Listener](https://www.alibabacloud.com/help/doc-detail/27593.htm).
 * * [Configure a TCP Classic Load Balancer (SLB) Listener](https://www.alibabacloud.com/help/doc-detail/27594.htm).
 * * [Configure a UDP Classic Load Balancer (SLB) Listener](https://www.alibabacloud.com/help/doc-detail/27595.htm).
 * > **NOTE:** Available since v1.0.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const listener = new alicloud.slb.ApplicationLoadBalancer("listener", {
 *     loadBalancerName: `${name}-${_default.result}`,
 *     internetChargeType: "PayByTraffic",
 *     addressType: "internet",
 *     instanceChargeType: "PayByCLCU",
 * });
 * const listenerAcl = new alicloud.slb.Acl("listener", {
 *     name: `${name}-${_default.result}`,
 *     ipVersion: "ipv4",
 * });
 * const listenerListener = new alicloud.slb.Listener("listener", {
 *     loadBalancerId: listener.id,
 *     backendPort: 80,
 *     frontendPort: 80,
 *     protocol: "http",
 *     bandwidth: 10,
 *     stickySession: "on",
 *     stickySessionType: "insert",
 *     cookieTimeout: 86400,
 *     cookie: "tfslblistenercookie",
 *     healthCheck: "on",
 *     healthCheckDomain: "ali.com",
 *     healthCheckUri: "/cons",
 *     healthCheckConnectPort: 20,
 *     healthyThreshold: 8,
 *     unhealthyThreshold: 8,
 *     healthCheckTimeout: 8,
 *     healthCheckInterval: 5,
 *     healthCheckHttpCode: "http_2xx,http_3xx",
 *     xForwardedFor: {
 *         retriveSlbIp: true,
 *         retriveSlbId: true,
 *     },
 *     aclStatus: "on",
 *     aclType: "white",
 *     aclId: listenerAcl.id,
 *     requestTimeout: 80,
 *     idleTimeout: 30,
 * });
 * const first = new alicloud.slb.AclEntryAttachment("first", {
 *     aclId: listenerAcl.id,
 *     entry: "10.10.10.0/24",
 *     comment: "first",
 * });
 * const second = new alicloud.slb.AclEntryAttachment("second", {
 *     aclId: listenerAcl.id,
 *     entry: "168.10.10.0/24",
 *     comment: "second",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * listener = alicloud.slb.ApplicationLoadBalancer("listener",
 *     load_balancer_name=f"{name}-{default['result']}",
 *     internet_charge_type="PayByTraffic",
 *     address_type="internet",
 *     instance_charge_type="PayByCLCU")
 * listener_acl = alicloud.slb.Acl("listener",
 *     name=f"{name}-{default['result']}",
 *     ip_version="ipv4")
 * listener_listener = alicloud.slb.Listener("listener",
 *     load_balancer_id=listener.id,
 *     backend_port=80,
 *     frontend_port=80,
 *     protocol="http",
 *     bandwidth=10,
 *     sticky_session="on",
 *     sticky_session_type="insert",
 *     cookie_timeout=86400,
 *     cookie="tfslblistenercookie",
 *     health_check="on",
 *     health_check_domain="ali.com",
 *     health_check_uri="/cons",
 *     health_check_connect_port=20,
 *     healthy_threshold=8,
 *     unhealthy_threshold=8,
 *     health_check_timeout=8,
 *     health_check_interval=5,
 *     health_check_http_code="http_2xx,http_3xx",
 *     x_forwarded_for={
 *         "retrive_slb_ip": True,
 *         "retrive_slb_id": True,
 *     },
 *     acl_status="on",
 *     acl_type="white",
 *     acl_id=listener_acl.id,
 *     request_timeout=80,
 *     idle_timeout=30)
 * first = alicloud.slb.AclEntryAttachment("first",
 *     acl_id=listener_acl.id,
 *     entry="10.10.10.0/24",
 *     comment="first")
 * second = alicloud.slb.AclEntryAttachment("second",
 *     acl_id=listener_acl.id,
 *     entry="168.10.10.0/24",
 *     comment="second")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var listener = new AliCloud.Slb.ApplicationLoadBalancer("listener", new()
 *     {
 *         LoadBalancerName = $"{name}-{@default.Result}",
 *         InternetChargeType = "PayByTraffic",
 *         AddressType = "internet",
 *         InstanceChargeType = "PayByCLCU",
 *     });
 *     var listenerAcl = new AliCloud.Slb.Acl("listener", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *         IpVersion = "ipv4",
 *     });
 *     var listenerListener = new AliCloud.Slb.Listener("listener", new()
 *     {
 *         LoadBalancerId = listener.Id,
 *         BackendPort = 80,
 *         FrontendPort = 80,
 *         Protocol = "http",
 *         Bandwidth = 10,
 *         StickySession = "on",
 *         StickySessionType = "insert",
 *         CookieTimeout = 86400,
 *         Cookie = "tfslblistenercookie",
 *         HealthCheck = "on",
 *         HealthCheckDomain = "ali.com",
 *         HealthCheckUri = "/cons",
 *         HealthCheckConnectPort = 20,
 *         HealthyThreshold = 8,
 *         UnhealthyThreshold = 8,
 *         HealthCheckTimeout = 8,
 *         HealthCheckInterval = 5,
 *         HealthCheckHttpCode = "http_2xx,http_3xx",
 *         XForwardedFor = new AliCloud.Slb.Inputs.ListenerXForwardedForArgs
 *         {
 *             RetriveSlbIp = true,
 *             RetriveSlbId = true,
 *         },
 *         AclStatus = "on",
 *         AclType = "white",
 *         AclId = listenerAcl.Id,
 *         RequestTimeout = 80,
 *         IdleTimeout = 30,
 *     });
 *     var first = new AliCloud.Slb.AclEntryAttachment("first", new()
 *     {
 *         AclId = listenerAcl.Id,
 *         Entry = "10.10.10.0/24",
 *         Comment = "first",
 *     });
 *     var second = new AliCloud.Slb.AclEntryAttachment("second", new()
 *     {
 *         AclId = listenerAcl.Id,
 *         Entry = "168.10.10.0/24",
 *         Comment = "second",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		listener, err := slb.NewApplicationLoadBalancer(ctx, "listener", &slb.ApplicationLoadBalancerArgs{
 * 			LoadBalancerName:   pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			InternetChargeType: pulumi.String("PayByTraffic"),
 * 			AddressType:        pulumi.String("internet"),
 * 			InstanceChargeType: pulumi.String("PayByCLCU"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		listenerAcl, err := slb.NewAcl(ctx, "listener", &slb.AclArgs{
 * 			Name:      pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			IpVersion: pulumi.String("ipv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = slb.NewListener(ctx, "listener", &slb.ListenerArgs{
 * 			LoadBalancerId:         listener.ID(),
 * 			BackendPort:            pulumi.Int(80),
 * 			FrontendPort:           pulumi.Int(80),
 * 			Protocol:               pulumi.String("http"),
 * 			Bandwidth:              pulumi.Int(10),
 * 			StickySession:          pulumi.String("on"),
 * 			StickySessionType:      pulumi.String("insert"),
 * 			CookieTimeout:          pulumi.Int(86400),
 * 			Cookie:                 pulumi.String("tfslblistenercookie"),
 * 			HealthCheck:            pulumi.String("on"),
 * 			HealthCheckDomain:      pulumi.String("ali.com"),
 * 			HealthCheckUri:         pulumi.String("/cons"),
 * 			HealthCheckConnectPort: pulumi.Int(20),
 * 			HealthyThreshold:       pulumi.Int(8),
 * 			UnhealthyThreshold:     pulumi.Int(8),
 * 			HealthCheckTimeout:     pulumi.Int(8),
 * 			HealthCheckInterval:    pulumi.Int(5),
 * 			HealthCheckHttpCode:    pulumi.String("http_2xx,http_3xx"),
 * 			XForwardedFor: &slb.ListenerXForwardedForArgs{
 * 				RetriveSlbIp: pulumi.Bool(true),
 * 				RetriveSlbId: pulumi.Bool(true),
 * 			},
 * 			AclStatus:      pulumi.String("on"),
 * 			AclType:        pulumi.String("white"),
 * 			AclId:          listenerAcl.ID(),
 * 			RequestTimeout: pulumi.Int(80),
 * 			IdleTimeout:    pulumi.Int(30),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = slb.NewAclEntryAttachment(ctx, "first", &slb.AclEntryAttachmentArgs{
 * 			AclId:   listenerAcl.ID(),
 * 			Entry:   pulumi.String("10.10.10.0/24"),
 * 			Comment: pulumi.String("first"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = slb.NewAclEntryAttachment(ctx, "second", &slb.AclEntryAttachmentArgs{
 * 			AclId:   listenerAcl.ID(),
 * 			Entry:   pulumi.String("168.10.10.0/24"),
 * 			Comment: pulumi.String("second"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.slb.ApplicationLoadBalancer;
 * import com.pulumi.alicloud.slb.ApplicationLoadBalancerArgs;
 * import com.pulumi.alicloud.slb.Acl;
 * import com.pulumi.alicloud.slb.AclArgs;
 * import com.pulumi.alicloud.slb.Listener;
 * import com.pulumi.alicloud.slb.ListenerArgs;
 * import com.pulumi.alicloud.slb.inputs.ListenerXForwardedForArgs;
 * import com.pulumi.alicloud.slb.AclEntryAttachment;
 * import com.pulumi.alicloud.slb.AclEntryAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var listener = new ApplicationLoadBalancer("listener", ApplicationLoadBalancerArgs.builder()
 *             .loadBalancerName(String.format("%s-%s", name,default_.result()))
 *             .internetChargeType("PayByTraffic")
 *             .addressType("internet")
 *             .instanceChargeType("PayByCLCU")
 *             .build());
 *         var listenerAcl = new Acl("listenerAcl", AclArgs.builder()
 *             .name(String.format("%s-%s", name,default_.result()))
 *             .ipVersion("ipv4")
 *             .build());
 *         var listenerListener = new Listener("listenerListener", ListenerArgs.builder()
 *             .loadBalancerId(listener.id())
 *             .backendPort(80)
 *             .frontendPort(80)
 *             .protocol("http")
 *             .bandwidth(10)
 *             .stickySession("on")
 *             .stickySessionType("insert")
 *             .cookieTimeout(86400)
 *             .cookie("tfslblistenercookie")
 *             .healthCheck("on")
 *             .healthCheckDomain("ali.com")
 *             .healthCheckUri("/cons")
 *             .healthCheckConnectPort(20)
 *             .healthyThreshold(8)
 *             .unhealthyThreshold(8)
 *             .healthCheckTimeout(8)
 *             .healthCheckInterval(5)
 *             .healthCheckHttpCode("http_2xx,http_3xx")
 *             .xForwardedFor(ListenerXForwardedForArgs.builder()
 *                 .retriveSlbIp(true)
 *                 .retriveSlbId(true)
 *                 .build())
 *             .aclStatus("on")
 *             .aclType("white")
 *             .aclId(listenerAcl.id())
 *             .requestTimeout(80)
 *             .idleTimeout(30)
 *             .build());
 *         var first = new AclEntryAttachment("first", AclEntryAttachmentArgs.builder()
 *             .aclId(listenerAcl.id())
 *             .entry("10.10.10.0/24")
 *             .comment("first")
 *             .build());
 *         var second = new AclEntryAttachment("second", AclEntryAttachmentArgs.builder()
 *             .aclId(listenerAcl.id())
 *             .entry("168.10.10.0/24")
 *             .comment("second")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   listener:
 *     type: alicloud:slb:ApplicationLoadBalancer
 *     properties:
 *       loadBalancerName: ${name}-${default.result}
 *       internetChargeType: PayByTraffic
 *       addressType: internet
 *       instanceChargeType: PayByCLCU
 *   listenerListener:
 *     type: alicloud:slb:Listener
 *     name: listener
 *     properties:
 *       loadBalancerId: ${listener.id}
 *       backendPort: 80
 *       frontendPort: 80
 *       protocol: http
 *       bandwidth: 10
 *       stickySession: on
 *       stickySessionType: insert
 *       cookieTimeout: 86400
 *       cookie: tfslblistenercookie
 *       healthCheck: on
 *       healthCheckDomain: ali.com
 *       healthCheckUri: /cons
 *       healthCheckConnectPort: 20
 *       healthyThreshold: 8
 *       unhealthyThreshold: 8
 *       healthCheckTimeout: 8
 *       healthCheckInterval: 5
 *       healthCheckHttpCode: http_2xx,http_3xx
 *       xForwardedFor:
 *         retriveSlbIp: true
 *         retriveSlbId: true
 *       aclStatus: on
 *       aclType: white
 *       aclId: ${listenerAcl.id}
 *       requestTimeout: 80
 *       idleTimeout: 30
 *   listenerAcl:
 *     type: alicloud:slb:Acl
 *     name: listener
 *     properties:
 *       name: ${name}-${default.result}
 *       ipVersion: ipv4
 *   first:
 *     type: alicloud:slb:AclEntryAttachment
 *     properties:
 *       aclId: ${listenerAcl.id}
 *       entry: 10.10.10.0/24
 *       comment: first
 *   second:
 *     type: alicloud:slb:AclEntryAttachment
 *     properties:
 *       aclId: ${listenerAcl.id}
 *       entry: 168.10.10.0/24
 *       comment: second
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Classic Load Balancer (SLB) Load Balancer Listener can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/listener:Listener example <load_balancer_id>:<protocol>:<frontend_port>
 * ```
 * ```sh
 * $ pulumi import alicloud:slb/listener:Listener example <load_balancer_id>:<frontend_port>
 * ```
 */
public class Listener internal constructor(
    override val javaResource: com.pulumi.alicloud.slb.Listener,
) : KotlinCustomResource(javaResource, ListenerMapper) {
    public val aclId: Output<String>?
        get() = javaResource.aclId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val aclStatus: Output<String>?
        get() = javaResource.aclStatus().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val aclType: Output<String>?
        get() = javaResource.aclType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val backendPort: Output<Int>?
        get() = javaResource.backendPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    public val caCertificateId: Output<String>?
        get() = javaResource.caCertificateId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val cookie: Output<String>?
        get() = javaResource.cookie().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val cookieTimeout: Output<Int>?
        get() = javaResource.cookieTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val deleteProtectionValidation: Output<Boolean>?
        get() = javaResource.deleteProtectionValidation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val enableHttp2: Output<String>?
        get() = javaResource.enableHttp2().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val establishedTimeout: Output<Int>?
        get() = javaResource.establishedTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val forwardPort: Output<Int>?
        get() = javaResource.forwardPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val frontendPort: Output<Int>
        get() = javaResource.frontendPort().applyValue({ args0 -> args0 })

    public val gzip: Output<Boolean>?
        get() = javaResource.gzip().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val healthCheck: Output<String>?
        get() = javaResource.healthCheck().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val healthCheckConnectPort: Output<Int>
        get() = javaResource.healthCheckConnectPort().applyValue({ args0 -> args0 })

    public val healthCheckDomain: Output<String>?
        get() = javaResource.healthCheckDomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val healthCheckHttpCode: Output<String>
        get() = javaResource.healthCheckHttpCode().applyValue({ args0 -> args0 })

    public val healthCheckInterval: Output<Int>?
        get() = javaResource.healthCheckInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val healthCheckMethod: Output<String>
        get() = javaResource.healthCheckMethod().applyValue({ args0 -> args0 })

    public val healthCheckTimeout: Output<Int>?
        get() = javaResource.healthCheckTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val healthCheckType: Output<String>?
        get() = javaResource.healthCheckType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val healthCheckUri: Output<String>?
        get() = javaResource.healthCheckUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val healthyThreshold: Output<Int>?
        get() = javaResource.healthyThreshold().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val idleTimeout: Output<Int>?
        get() = javaResource.idleTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Field 'lb_port' has been removed since 1.211.0.
  """,
    )
    public val lbPort: Output<Int>?
        get() = javaResource.lbPort().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    @Deprecated(
        message = """
  Field 'lb_protocol' has been removed since 1.211.0.
  """,
    )
    public val lbProtocol: Output<String>?
        get() = javaResource.lbProtocol().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val listenerForward: Output<String>
        get() = javaResource.listenerForward().applyValue({ args0 -> args0 })

    public val loadBalancerId: Output<String>
        get() = javaResource.loadBalancerId().applyValue({ args0 -> args0 })

    public val masterSlaveServerGroupId: Output<String>?
        get() = javaResource.masterSlaveServerGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val persistenceTimeout: Output<Int>?
        get() = javaResource.persistenceTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    public val proxyProtocolV2Enabled: Output<Boolean>
        get() = javaResource.proxyProtocolV2Enabled().applyValue({ args0 -> args0 })

    public val requestTimeout: Output<Int>?
        get() = javaResource.requestTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val scheduler: Output<String>?
        get() = javaResource.scheduler().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val serverCertificateId: Output<String>
        get() = javaResource.serverCertificateId().applyValue({ args0 -> args0 })

    public val serverGroupId: Output<String>?
        get() = javaResource.serverGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Field 'ssl_certificate_id' has been deprecated from 1.59.0 and using 'server_certificate_id'
      instead.
  """,
    )
    public val sslCertificateId: Output<String>
        get() = javaResource.sslCertificateId().applyValue({ args0 -> args0 })

    public val stickySession: Output<String>?
        get() = javaResource.stickySession().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val stickySessionType: Output<String>?
        get() = javaResource.stickySessionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val tlsCipherPolicy: Output<String>?
        get() = javaResource.tlsCipherPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val unhealthyThreshold: Output<Int>?
        get() = javaResource.unhealthyThreshold().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to set additional HTTP Header field "X-Forwarded-For".
     */
    public val xForwardedFor: Output<ListenerXForwardedFor>
        get() = javaResource.xForwardedFor().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object ListenerMapper : ResourceMapper<Listener> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.slb.Listener::class == javaResource::class

    override fun map(javaResource: Resource): Listener = Listener(
        javaResource as
            com.pulumi.alicloud.slb.Listener,
    )
}

/**
 * @see [Listener].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Listener].
 */
public suspend fun listener(name: String, block: suspend ListenerResourceBuilder.() -> Unit): Listener {
    val builder = ListenerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Listener].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listener(name: String): Listener {
    val builder = ListenerResourceBuilder()
    builder.name(name)
    return builder.build()
}
