@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.alicloud.slb.ListenerArgs.builder
import com.pulumi.alicloud.slb.kotlin.inputs.ListenerXForwardedForArgs
import com.pulumi.alicloud.slb.kotlin.inputs.ListenerXForwardedForArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Classic Load Balancer (SLB) Load Balancer Listener resource.
 * For information about Classic Load Balancer (SLB) and how to use it, see [What is Classic Load Balancer](https://www.alibabacloud.com/help/doc-detail/27539.htm).
 * For information about listener and how to use it, please see the following:
 * * [Configure a HTTP Classic Load Balancer (SLB) Listener](https://www.alibabacloud.com/help/doc-detail/27592.htm).
 * * [Configure a HTTPS Classic Load Balancer (SLB) Listener](https://www.alibabacloud.com/help/doc-detail/27593.htm).
 * * [Configure a TCP Classic Load Balancer (SLB) Listener](https://www.alibabacloud.com/help/doc-detail/27594.htm).
 * * [Configure a UDP Classic Load Balancer (SLB) Listener](https://www.alibabacloud.com/help/doc-detail/27595.htm).
 * > **NOTE:** Available since v1.0.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const listener = new alicloud.slb.ApplicationLoadBalancer("listener", {
 *     loadBalancerName: `${name}-${_default.result}`,
 *     internetChargeType: "PayByTraffic",
 *     addressType: "internet",
 *     instanceChargeType: "PayByCLCU",
 * });
 * const listenerAcl = new alicloud.slb.Acl("listener", {
 *     name: `${name}-${_default.result}`,
 *     ipVersion: "ipv4",
 * });
 * const listenerListener = new alicloud.slb.Listener("listener", {
 *     loadBalancerId: listener.id,
 *     backendPort: 80,
 *     frontendPort: 80,
 *     protocol: "http",
 *     bandwidth: 10,
 *     stickySession: "on",
 *     stickySessionType: "insert",
 *     cookieTimeout: 86400,
 *     cookie: "tfslblistenercookie",
 *     healthCheck: "on",
 *     healthCheckDomain: "ali.com",
 *     healthCheckUri: "/cons",
 *     healthCheckConnectPort: 20,
 *     healthyThreshold: 8,
 *     unhealthyThreshold: 8,
 *     healthCheckTimeout: 8,
 *     healthCheckInterval: 5,
 *     healthCheckHttpCode: "http_2xx,http_3xx",
 *     xForwardedFor: {
 *         retriveSlbIp: true,
 *         retriveSlbId: true,
 *     },
 *     aclStatus: "on",
 *     aclType: "white",
 *     aclId: listenerAcl.id,
 *     requestTimeout: 80,
 *     idleTimeout: 30,
 * });
 * const first = new alicloud.slb.AclEntryAttachment("first", {
 *     aclId: listenerAcl.id,
 *     entry: "10.10.10.0/24",
 *     comment: "first",
 * });
 * const second = new alicloud.slb.AclEntryAttachment("second", {
 *     aclId: listenerAcl.id,
 *     entry: "168.10.10.0/24",
 *     comment: "second",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * listener = alicloud.slb.ApplicationLoadBalancer("listener",
 *     load_balancer_name=f"{name}-{default['result']}",
 *     internet_charge_type="PayByTraffic",
 *     address_type="internet",
 *     instance_charge_type="PayByCLCU")
 * listener_acl = alicloud.slb.Acl("listener",
 *     name=f"{name}-{default['result']}",
 *     ip_version="ipv4")
 * listener_listener = alicloud.slb.Listener("listener",
 *     load_balancer_id=listener.id,
 *     backend_port=80,
 *     frontend_port=80,
 *     protocol="http",
 *     bandwidth=10,
 *     sticky_session="on",
 *     sticky_session_type="insert",
 *     cookie_timeout=86400,
 *     cookie="tfslblistenercookie",
 *     health_check="on",
 *     health_check_domain="ali.com",
 *     health_check_uri="/cons",
 *     health_check_connect_port=20,
 *     healthy_threshold=8,
 *     unhealthy_threshold=8,
 *     health_check_timeout=8,
 *     health_check_interval=5,
 *     health_check_http_code="http_2xx,http_3xx",
 *     x_forwarded_for={
 *         "retrive_slb_ip": True,
 *         "retrive_slb_id": True,
 *     },
 *     acl_status="on",
 *     acl_type="white",
 *     acl_id=listener_acl.id,
 *     request_timeout=80,
 *     idle_timeout=30)
 * first = alicloud.slb.AclEntryAttachment("first",
 *     acl_id=listener_acl.id,
 *     entry="10.10.10.0/24",
 *     comment="first")
 * second = alicloud.slb.AclEntryAttachment("second",
 *     acl_id=listener_acl.id,
 *     entry="168.10.10.0/24",
 *     comment="second")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var listener = new AliCloud.Slb.ApplicationLoadBalancer("listener", new()
 *     {
 *         LoadBalancerName = $"{name}-{@default.Result}",
 *         InternetChargeType = "PayByTraffic",
 *         AddressType = "internet",
 *         InstanceChargeType = "PayByCLCU",
 *     });
 *     var listenerAcl = new AliCloud.Slb.Acl("listener", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *         IpVersion = "ipv4",
 *     });
 *     var listenerListener = new AliCloud.Slb.Listener("listener", new()
 *     {
 *         LoadBalancerId = listener.Id,
 *         BackendPort = 80,
 *         FrontendPort = 80,
 *         Protocol = "http",
 *         Bandwidth = 10,
 *         StickySession = "on",
 *         StickySessionType = "insert",
 *         CookieTimeout = 86400,
 *         Cookie = "tfslblistenercookie",
 *         HealthCheck = "on",
 *         HealthCheckDomain = "ali.com",
 *         HealthCheckUri = "/cons",
 *         HealthCheckConnectPort = 20,
 *         HealthyThreshold = 8,
 *         UnhealthyThreshold = 8,
 *         HealthCheckTimeout = 8,
 *         HealthCheckInterval = 5,
 *         HealthCheckHttpCode = "http_2xx,http_3xx",
 *         XForwardedFor = new AliCloud.Slb.Inputs.ListenerXForwardedForArgs
 *         {
 *             RetriveSlbIp = true,
 *             RetriveSlbId = true,
 *         },
 *         AclStatus = "on",
 *         AclType = "white",
 *         AclId = listenerAcl.Id,
 *         RequestTimeout = 80,
 *         IdleTimeout = 30,
 *     });
 *     var first = new AliCloud.Slb.AclEntryAttachment("first", new()
 *     {
 *         AclId = listenerAcl.Id,
 *         Entry = "10.10.10.0/24",
 *         Comment = "first",
 *     });
 *     var second = new AliCloud.Slb.AclEntryAttachment("second", new()
 *     {
 *         AclId = listenerAcl.Id,
 *         Entry = "168.10.10.0/24",
 *         Comment = "second",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		listener, err := slb.NewApplicationLoadBalancer(ctx, "listener", &slb.ApplicationLoadBalancerArgs{
 * 			LoadBalancerName:   pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			InternetChargeType: pulumi.String("PayByTraffic"),
 * 			AddressType:        pulumi.String("internet"),
 * 			InstanceChargeType: pulumi.String("PayByCLCU"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		listenerAcl, err := slb.NewAcl(ctx, "listener", &slb.AclArgs{
 * 			Name:      pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			IpVersion: pulumi.String("ipv4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = slb.NewListener(ctx, "listener", &slb.ListenerArgs{
 * 			LoadBalancerId:         listener.ID(),
 * 			BackendPort:            pulumi.Int(80),
 * 			FrontendPort:           pulumi.Int(80),
 * 			Protocol:               pulumi.String("http"),
 * 			Bandwidth:              pulumi.Int(10),
 * 			StickySession:          pulumi.String("on"),
 * 			StickySessionType:      pulumi.String("insert"),
 * 			CookieTimeout:          pulumi.Int(86400),
 * 			Cookie:                 pulumi.String("tfslblistenercookie"),
 * 			HealthCheck:            pulumi.String("on"),
 * 			HealthCheckDomain:      pulumi.String("ali.com"),
 * 			HealthCheckUri:         pulumi.String("/cons"),
 * 			HealthCheckConnectPort: pulumi.Int(20),
 * 			HealthyThreshold:       pulumi.Int(8),
 * 			UnhealthyThreshold:     pulumi.Int(8),
 * 			HealthCheckTimeout:     pulumi.Int(8),
 * 			HealthCheckInterval:    pulumi.Int(5),
 * 			HealthCheckHttpCode:    pulumi.String("http_2xx,http_3xx"),
 * 			XForwardedFor: &slb.ListenerXForwardedForArgs{
 * 				RetriveSlbIp: pulumi.Bool(true),
 * 				RetriveSlbId: pulumi.Bool(true),
 * 			},
 * 			AclStatus:      pulumi.String("on"),
 * 			AclType:        pulumi.String("white"),
 * 			AclId:          listenerAcl.ID(),
 * 			RequestTimeout: pulumi.Int(80),
 * 			IdleTimeout:    pulumi.Int(30),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = slb.NewAclEntryAttachment(ctx, "first", &slb.AclEntryAttachmentArgs{
 * 			AclId:   listenerAcl.ID(),
 * 			Entry:   pulumi.String("10.10.10.0/24"),
 * 			Comment: pulumi.String("first"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = slb.NewAclEntryAttachment(ctx, "second", &slb.AclEntryAttachmentArgs{
 * 			AclId:   listenerAcl.ID(),
 * 			Entry:   pulumi.String("168.10.10.0/24"),
 * 			Comment: pulumi.String("second"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.slb.ApplicationLoadBalancer;
 * import com.pulumi.alicloud.slb.ApplicationLoadBalancerArgs;
 * import com.pulumi.alicloud.slb.Acl;
 * import com.pulumi.alicloud.slb.AclArgs;
 * import com.pulumi.alicloud.slb.Listener;
 * import com.pulumi.alicloud.slb.ListenerArgs;
 * import com.pulumi.alicloud.slb.inputs.ListenerXForwardedForArgs;
 * import com.pulumi.alicloud.slb.AclEntryAttachment;
 * import com.pulumi.alicloud.slb.AclEntryAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var listener = new ApplicationLoadBalancer("listener", ApplicationLoadBalancerArgs.builder()
 *             .loadBalancerName(String.format("%s-%s", name,default_.result()))
 *             .internetChargeType("PayByTraffic")
 *             .addressType("internet")
 *             .instanceChargeType("PayByCLCU")
 *             .build());
 *         var listenerAcl = new Acl("listenerAcl", AclArgs.builder()
 *             .name(String.format("%s-%s", name,default_.result()))
 *             .ipVersion("ipv4")
 *             .build());
 *         var listenerListener = new Listener("listenerListener", ListenerArgs.builder()
 *             .loadBalancerId(listener.id())
 *             .backendPort(80)
 *             .frontendPort(80)
 *             .protocol("http")
 *             .bandwidth(10)
 *             .stickySession("on")
 *             .stickySessionType("insert")
 *             .cookieTimeout(86400)
 *             .cookie("tfslblistenercookie")
 *             .healthCheck("on")
 *             .healthCheckDomain("ali.com")
 *             .healthCheckUri("/cons")
 *             .healthCheckConnectPort(20)
 *             .healthyThreshold(8)
 *             .unhealthyThreshold(8)
 *             .healthCheckTimeout(8)
 *             .healthCheckInterval(5)
 *             .healthCheckHttpCode("http_2xx,http_3xx")
 *             .xForwardedFor(ListenerXForwardedForArgs.builder()
 *                 .retriveSlbIp(true)
 *                 .retriveSlbId(true)
 *                 .build())
 *             .aclStatus("on")
 *             .aclType("white")
 *             .aclId(listenerAcl.id())
 *             .requestTimeout(80)
 *             .idleTimeout(30)
 *             .build());
 *         var first = new AclEntryAttachment("first", AclEntryAttachmentArgs.builder()
 *             .aclId(listenerAcl.id())
 *             .entry("10.10.10.0/24")
 *             .comment("first")
 *             .build());
 *         var second = new AclEntryAttachment("second", AclEntryAttachmentArgs.builder()
 *             .aclId(listenerAcl.id())
 *             .entry("168.10.10.0/24")
 *             .comment("second")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   listener:
 *     type: alicloud:slb:ApplicationLoadBalancer
 *     properties:
 *       loadBalancerName: ${name}-${default.result}
 *       internetChargeType: PayByTraffic
 *       addressType: internet
 *       instanceChargeType: PayByCLCU
 *   listenerListener:
 *     type: alicloud:slb:Listener
 *     name: listener
 *     properties:
 *       loadBalancerId: ${listener.id}
 *       backendPort: 80
 *       frontendPort: 80
 *       protocol: http
 *       bandwidth: 10
 *       stickySession: on
 *       stickySessionType: insert
 *       cookieTimeout: 86400
 *       cookie: tfslblistenercookie
 *       healthCheck: on
 *       healthCheckDomain: ali.com
 *       healthCheckUri: /cons
 *       healthCheckConnectPort: 20
 *       healthyThreshold: 8
 *       unhealthyThreshold: 8
 *       healthCheckTimeout: 8
 *       healthCheckInterval: 5
 *       healthCheckHttpCode: http_2xx,http_3xx
 *       xForwardedFor:
 *         retriveSlbIp: true
 *         retriveSlbId: true
 *       aclStatus: on
 *       aclType: white
 *       aclId: ${listenerAcl.id}
 *       requestTimeout: 80
 *       idleTimeout: 30
 *   listenerAcl:
 *     type: alicloud:slb:Acl
 *     name: listener
 *     properties:
 *       name: ${name}-${default.result}
 *       ipVersion: ipv4
 *   first:
 *     type: alicloud:slb:AclEntryAttachment
 *     properties:
 *       aclId: ${listenerAcl.id}
 *       entry: 10.10.10.0/24
 *       comment: first
 *   second:
 *     type: alicloud:slb:AclEntryAttachment
 *     properties:
 *       aclId: ${listenerAcl.id}
 *       entry: 168.10.10.0/24
 *       comment: second
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Classic Load Balancer (SLB) Load Balancer Listener can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/listener:Listener example <load_balancer_id>:<protocol>:<frontend_port>
 * ```
 * ```sh
 * $ pulumi import alicloud:slb/listener:Listener example <load_balancer_id>:<frontend_port>
 * ```
 * @property aclId
 * @property aclStatus
 * @property aclType
 * @property backendPort
 * @property bandwidth
 * @property caCertificateId
 * @property cookie
 * @property cookieTimeout
 * @property deleteProtectionValidation
 * @property description
 * @property enableHttp2
 * @property establishedTimeout
 * @property forwardPort
 * @property frontendPort
 * @property gzip
 * @property healthCheck
 * @property healthCheckConnectPort
 * @property healthCheckDomain
 * @property healthCheckHttpCode
 * @property healthCheckInterval
 * @property healthCheckMethod
 * @property healthCheckTimeout
 * @property healthCheckType
 * @property healthCheckUri
 * @property healthyThreshold
 * @property idleTimeout
 * @property lbPort
 * @property lbProtocol
 * @property listenerForward
 * @property loadBalancerId
 * @property masterSlaveServerGroupId
 * @property persistenceTimeout
 * @property protocol
 * @property proxyProtocolV2Enabled
 * @property requestTimeout
 * @property scheduler
 * @property serverCertificateId
 * @property serverGroupId
 * @property sslCertificateId
 * @property stickySession
 * @property stickySessionType
 * @property tlsCipherPolicy
 * @property unhealthyThreshold
 * @property xForwardedFor Whether to set additional HTTP Header field "X-Forwarded-For".
 */
public data class ListenerArgs(
    public val aclId: Output<String>? = null,
    public val aclStatus: Output<String>? = null,
    public val aclType: Output<String>? = null,
    public val backendPort: Output<Int>? = null,
    public val bandwidth: Output<Int>? = null,
    public val caCertificateId: Output<String>? = null,
    public val cookie: Output<String>? = null,
    public val cookieTimeout: Output<Int>? = null,
    public val deleteProtectionValidation: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val enableHttp2: Output<String>? = null,
    public val establishedTimeout: Output<Int>? = null,
    public val forwardPort: Output<Int>? = null,
    public val frontendPort: Output<Int>? = null,
    public val gzip: Output<Boolean>? = null,
    public val healthCheck: Output<String>? = null,
    public val healthCheckConnectPort: Output<Int>? = null,
    public val healthCheckDomain: Output<String>? = null,
    public val healthCheckHttpCode: Output<String>? = null,
    public val healthCheckInterval: Output<Int>? = null,
    public val healthCheckMethod: Output<String>? = null,
    public val healthCheckTimeout: Output<Int>? = null,
    public val healthCheckType: Output<String>? = null,
    public val healthCheckUri: Output<String>? = null,
    public val healthyThreshold: Output<Int>? = null,
    public val idleTimeout: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'lb_port' has been removed since 1.211.0.
  """,
    )
    public val lbPort: Output<Int>? = null,
    @Deprecated(
        message = """
  Field 'lb_protocol' has been removed since 1.211.0.
  """,
    )
    public val lbProtocol: Output<String>? = null,
    public val listenerForward: Output<String>? = null,
    public val loadBalancerId: Output<String>? = null,
    public val masterSlaveServerGroupId: Output<String>? = null,
    public val persistenceTimeout: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val proxyProtocolV2Enabled: Output<Boolean>? = null,
    public val requestTimeout: Output<Int>? = null,
    public val scheduler: Output<String>? = null,
    public val serverCertificateId: Output<String>? = null,
    public val serverGroupId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'ssl_certificate_id' has been deprecated from 1.59.0 and using 'server_certificate_id'
      instead.
  """,
    )
    public val sslCertificateId: Output<String>? = null,
    public val stickySession: Output<String>? = null,
    public val stickySessionType: Output<String>? = null,
    public val tlsCipherPolicy: Output<String>? = null,
    public val unhealthyThreshold: Output<Int>? = null,
    public val xForwardedFor: Output<ListenerXForwardedForArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.ListenerArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.ListenerArgs =
        com.pulumi.alicloud.slb.ListenerArgs.builder()
            .aclId(aclId?.applyValue({ args0 -> args0 }))
            .aclStatus(aclStatus?.applyValue({ args0 -> args0 }))
            .aclType(aclType?.applyValue({ args0 -> args0 }))
            .backendPort(backendPort?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .caCertificateId(caCertificateId?.applyValue({ args0 -> args0 }))
            .cookie(cookie?.applyValue({ args0 -> args0 }))
            .cookieTimeout(cookieTimeout?.applyValue({ args0 -> args0 }))
            .deleteProtectionValidation(deleteProtectionValidation?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enableHttp2(enableHttp2?.applyValue({ args0 -> args0 }))
            .establishedTimeout(establishedTimeout?.applyValue({ args0 -> args0 }))
            .forwardPort(forwardPort?.applyValue({ args0 -> args0 }))
            .frontendPort(frontendPort?.applyValue({ args0 -> args0 }))
            .gzip(gzip?.applyValue({ args0 -> args0 }))
            .healthCheck(healthCheck?.applyValue({ args0 -> args0 }))
            .healthCheckConnectPort(healthCheckConnectPort?.applyValue({ args0 -> args0 }))
            .healthCheckDomain(healthCheckDomain?.applyValue({ args0 -> args0 }))
            .healthCheckHttpCode(healthCheckHttpCode?.applyValue({ args0 -> args0 }))
            .healthCheckInterval(healthCheckInterval?.applyValue({ args0 -> args0 }))
            .healthCheckMethod(healthCheckMethod?.applyValue({ args0 -> args0 }))
            .healthCheckTimeout(healthCheckTimeout?.applyValue({ args0 -> args0 }))
            .healthCheckType(healthCheckType?.applyValue({ args0 -> args0 }))
            .healthCheckUri(healthCheckUri?.applyValue({ args0 -> args0 }))
            .healthyThreshold(healthyThreshold?.applyValue({ args0 -> args0 }))
            .idleTimeout(idleTimeout?.applyValue({ args0 -> args0 }))
            .lbPort(lbPort?.applyValue({ args0 -> args0 }))
            .lbProtocol(lbProtocol?.applyValue({ args0 -> args0 }))
            .listenerForward(listenerForward?.applyValue({ args0 -> args0 }))
            .loadBalancerId(loadBalancerId?.applyValue({ args0 -> args0 }))
            .masterSlaveServerGroupId(masterSlaveServerGroupId?.applyValue({ args0 -> args0 }))
            .persistenceTimeout(persistenceTimeout?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .proxyProtocolV2Enabled(proxyProtocolV2Enabled?.applyValue({ args0 -> args0 }))
            .requestTimeout(requestTimeout?.applyValue({ args0 -> args0 }))
            .scheduler(scheduler?.applyValue({ args0 -> args0 }))
            .serverCertificateId(serverCertificateId?.applyValue({ args0 -> args0 }))
            .serverGroupId(serverGroupId?.applyValue({ args0 -> args0 }))
            .sslCertificateId(sslCertificateId?.applyValue({ args0 -> args0 }))
            .stickySession(stickySession?.applyValue({ args0 -> args0 }))
            .stickySessionType(stickySessionType?.applyValue({ args0 -> args0 }))
            .tlsCipherPolicy(tlsCipherPolicy?.applyValue({ args0 -> args0 }))
            .unhealthyThreshold(unhealthyThreshold?.applyValue({ args0 -> args0 }))
            .xForwardedFor(xForwardedFor?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ListenerArgs].
 */
@PulumiTagMarker
public class ListenerArgsBuilder internal constructor() {
    private var aclId: Output<String>? = null

    private var aclStatus: Output<String>? = null

    private var aclType: Output<String>? = null

    private var backendPort: Output<Int>? = null

    private var bandwidth: Output<Int>? = null

    private var caCertificateId: Output<String>? = null

    private var cookie: Output<String>? = null

    private var cookieTimeout: Output<Int>? = null

    private var deleteProtectionValidation: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var enableHttp2: Output<String>? = null

    private var establishedTimeout: Output<Int>? = null

    private var forwardPort: Output<Int>? = null

    private var frontendPort: Output<Int>? = null

    private var gzip: Output<Boolean>? = null

    private var healthCheck: Output<String>? = null

    private var healthCheckConnectPort: Output<Int>? = null

    private var healthCheckDomain: Output<String>? = null

    private var healthCheckHttpCode: Output<String>? = null

    private var healthCheckInterval: Output<Int>? = null

    private var healthCheckMethod: Output<String>? = null

    private var healthCheckTimeout: Output<Int>? = null

    private var healthCheckType: Output<String>? = null

    private var healthCheckUri: Output<String>? = null

    private var healthyThreshold: Output<Int>? = null

    private var idleTimeout: Output<Int>? = null

    private var lbPort: Output<Int>? = null

    private var lbProtocol: Output<String>? = null

    private var listenerForward: Output<String>? = null

    private var loadBalancerId: Output<String>? = null

    private var masterSlaveServerGroupId: Output<String>? = null

    private var persistenceTimeout: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var proxyProtocolV2Enabled: Output<Boolean>? = null

    private var requestTimeout: Output<Int>? = null

    private var scheduler: Output<String>? = null

    private var serverCertificateId: Output<String>? = null

    private var serverGroupId: Output<String>? = null

    private var sslCertificateId: Output<String>? = null

    private var stickySession: Output<String>? = null

    private var stickySessionType: Output<String>? = null

    private var tlsCipherPolicy: Output<String>? = null

    private var unhealthyThreshold: Output<Int>? = null

    private var xForwardedFor: Output<ListenerXForwardedForArgs>? = null

    /**
     * @param value
     */
    @JvmName("holiesavlthixdyh")
    public suspend fun aclId(`value`: Output<String>) {
        this.aclId = value
    }

    /**
     * @param value
     */
    @JvmName("wjaooxaxbulwsngu")
    public suspend fun aclStatus(`value`: Output<String>) {
        this.aclStatus = value
    }

    /**
     * @param value
     */
    @JvmName("kyiijxslajxuvvdu")
    public suspend fun aclType(`value`: Output<String>) {
        this.aclType = value
    }

    /**
     * @param value
     */
    @JvmName("gsbmhxgphahcwlon")
    public suspend fun backendPort(`value`: Output<Int>) {
        this.backendPort = value
    }

    /**
     * @param value
     */
    @JvmName("tlnxkwqsjemvblhy")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value
     */
    @JvmName("fndqjdhehqdbjljr")
    public suspend fun caCertificateId(`value`: Output<String>) {
        this.caCertificateId = value
    }

    /**
     * @param value
     */
    @JvmName("jocujfmhrxududuc")
    public suspend fun cookie(`value`: Output<String>) {
        this.cookie = value
    }

    /**
     * @param value
     */
    @JvmName("xupepxixhuqcmlkb")
    public suspend fun cookieTimeout(`value`: Output<Int>) {
        this.cookieTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("gxragioxmjjlimau")
    public suspend fun deleteProtectionValidation(`value`: Output<Boolean>) {
        this.deleteProtectionValidation = value
    }

    /**
     * @param value
     */
    @JvmName("jxoifuxaboatfdbh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("lvopqhawsbinxpyl")
    public suspend fun enableHttp2(`value`: Output<String>) {
        this.enableHttp2 = value
    }

    /**
     * @param value
     */
    @JvmName("vjqjgpboneigsxfx")
    public suspend fun establishedTimeout(`value`: Output<Int>) {
        this.establishedTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("btujgjispokggnyn")
    public suspend fun forwardPort(`value`: Output<Int>) {
        this.forwardPort = value
    }

    /**
     * @param value
     */
    @JvmName("bgedhgmwrxmsikfa")
    public suspend fun frontendPort(`value`: Output<Int>) {
        this.frontendPort = value
    }

    /**
     * @param value
     */
    @JvmName("vfctwsprdwspycro")
    public suspend fun gzip(`value`: Output<Boolean>) {
        this.gzip = value
    }

    /**
     * @param value
     */
    @JvmName("qmyedlerhgjqkmcr")
    public suspend fun healthCheck(`value`: Output<String>) {
        this.healthCheck = value
    }

    /**
     * @param value
     */
    @JvmName("cqwbfoignevtfdep")
    public suspend fun healthCheckConnectPort(`value`: Output<Int>) {
        this.healthCheckConnectPort = value
    }

    /**
     * @param value
     */
    @JvmName("kxkxsxeitjqecdxc")
    public suspend fun healthCheckDomain(`value`: Output<String>) {
        this.healthCheckDomain = value
    }

    /**
     * @param value
     */
    @JvmName("apcpvfqodocqcxxa")
    public suspend fun healthCheckHttpCode(`value`: Output<String>) {
        this.healthCheckHttpCode = value
    }

    /**
     * @param value
     */
    @JvmName("nlxfujwjnqowawrd")
    public suspend fun healthCheckInterval(`value`: Output<Int>) {
        this.healthCheckInterval = value
    }

    /**
     * @param value
     */
    @JvmName("xwcjcdftpmnstrcj")
    public suspend fun healthCheckMethod(`value`: Output<String>) {
        this.healthCheckMethod = value
    }

    /**
     * @param value
     */
    @JvmName("ubfxsbyojhtnumav")
    public suspend fun healthCheckTimeout(`value`: Output<Int>) {
        this.healthCheckTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("ipmbwljinkvqgmao")
    public suspend fun healthCheckType(`value`: Output<String>) {
        this.healthCheckType = value
    }

    /**
     * @param value
     */
    @JvmName("gddsuqmvorsdibqk")
    public suspend fun healthCheckUri(`value`: Output<String>) {
        this.healthCheckUri = value
    }

    /**
     * @param value
     */
    @JvmName("hbwqdxkllxrkwitm")
    public suspend fun healthyThreshold(`value`: Output<Int>) {
        this.healthyThreshold = value
    }

    /**
     * @param value
     */
    @JvmName("iwiykbdeeoyvkamg")
    public suspend fun idleTimeout(`value`: Output<Int>) {
        this.idleTimeout = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'lb_port' has been removed since 1.211.0.
  """,
    )
    @JvmName("srxgddspehcyjyap")
    public suspend fun lbPort(`value`: Output<Int>) {
        this.lbPort = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'lb_protocol' has been removed since 1.211.0.
  """,
    )
    @JvmName("jsywvdgxcffqclre")
    public suspend fun lbProtocol(`value`: Output<String>) {
        this.lbProtocol = value
    }

    /**
     * @param value
     */
    @JvmName("puwkibyglkorbyps")
    public suspend fun listenerForward(`value`: Output<String>) {
        this.listenerForward = value
    }

    /**
     * @param value
     */
    @JvmName("jpjvvxhcsojygnhu")
    public suspend fun loadBalancerId(`value`: Output<String>) {
        this.loadBalancerId = value
    }

    /**
     * @param value
     */
    @JvmName("itlncadwoudvtrue")
    public suspend fun masterSlaveServerGroupId(`value`: Output<String>) {
        this.masterSlaveServerGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("ttqgqjwoqjootntr")
    public suspend fun persistenceTimeout(`value`: Output<Int>) {
        this.persistenceTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("ewmnxhmkfhhvqslj")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value
     */
    @JvmName("chupsemtkhabxubv")
    public suspend fun proxyProtocolV2Enabled(`value`: Output<Boolean>) {
        this.proxyProtocolV2Enabled = value
    }

    /**
     * @param value
     */
    @JvmName("mxmehuujxyxkcvea")
    public suspend fun requestTimeout(`value`: Output<Int>) {
        this.requestTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("qxcxepxdapqtkwtc")
    public suspend fun scheduler(`value`: Output<String>) {
        this.scheduler = value
    }

    /**
     * @param value
     */
    @JvmName("gacgsblfgxambdqy")
    public suspend fun serverCertificateId(`value`: Output<String>) {
        this.serverCertificateId = value
    }

    /**
     * @param value
     */
    @JvmName("btsptxiqpfmpytuk")
    public suspend fun serverGroupId(`value`: Output<String>) {
        this.serverGroupId = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'ssl_certificate_id' has been deprecated from 1.59.0 and using 'server_certificate_id'
      instead.
  """,
    )
    @JvmName("aalutaliidbcuugi")
    public suspend fun sslCertificateId(`value`: Output<String>) {
        this.sslCertificateId = value
    }

    /**
     * @param value
     */
    @JvmName("phappcgifxutsgyx")
    public suspend fun stickySession(`value`: Output<String>) {
        this.stickySession = value
    }

    /**
     * @param value
     */
    @JvmName("hoeefkflyusjfjmx")
    public suspend fun stickySessionType(`value`: Output<String>) {
        this.stickySessionType = value
    }

    /**
     * @param value
     */
    @JvmName("xjvnxjltxsdowsbg")
    public suspend fun tlsCipherPolicy(`value`: Output<String>) {
        this.tlsCipherPolicy = value
    }

    /**
     * @param value
     */
    @JvmName("ljylcesemjxmitug")
    public suspend fun unhealthyThreshold(`value`: Output<Int>) {
        this.unhealthyThreshold = value
    }

    /**
     * @param value Whether to set additional HTTP Header field "X-Forwarded-For".
     */
    @JvmName("oyamcqohgbqtiyqs")
    public suspend fun xForwardedFor(`value`: Output<ListenerXForwardedForArgs>) {
        this.xForwardedFor = value
    }

    /**
     * @param value
     */
    @JvmName("oktbpvnoodwsxeic")
    public suspend fun aclId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclId = mapped
    }

    /**
     * @param value
     */
    @JvmName("ppxpbsamuvdpkbsx")
    public suspend fun aclStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclStatus = mapped
    }

    /**
     * @param value
     */
    @JvmName("binayeufsejfcmje")
    public suspend fun aclType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclType = mapped
    }

    /**
     * @param value
     */
    @JvmName("yvgkexhticucdvyv")
    public suspend fun backendPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPort = mapped
    }

    /**
     * @param value
     */
    @JvmName("karhjqvgccgjvstn")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value
     */
    @JvmName("lacsoebvmdbjlyme")
    public suspend fun caCertificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertificateId = mapped
    }

    /**
     * @param value
     */
    @JvmName("iqnrvfjludafnfjb")
    public suspend fun cookie(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookie = mapped
    }

    /**
     * @param value
     */
    @JvmName("pwtajckuffovxnpo")
    public suspend fun cookieTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookieTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("coyywbcpkssvnqrm")
    public suspend fun deleteProtectionValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteProtectionValidation = mapped
    }

    /**
     * @param value
     */
    @JvmName("yyvkrgcalabbmqeb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("ulqmtjvdlccklfdq")
    public suspend fun enableHttp2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableHttp2 = mapped
    }

    /**
     * @param value
     */
    @JvmName("fmscbnaifkkmmjwr")
    public suspend fun establishedTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.establishedTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("rpjxwrcmobtsatvx")
    public suspend fun forwardPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardPort = mapped
    }

    /**
     * @param value
     */
    @JvmName("kiowlvfstypxygbw")
    public suspend fun frontendPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPort = mapped
    }

    /**
     * @param value
     */
    @JvmName("dmpmirictksljtmg")
    public suspend fun gzip(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gzip = mapped
    }

    /**
     * @param value
     */
    @JvmName("peendgbvgvjgmadi")
    public suspend fun healthCheck(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheck = mapped
    }

    /**
     * @param value
     */
    @JvmName("mqktdoqfkbgboifs")
    public suspend fun healthCheckConnectPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConnectPort = mapped
    }

    /**
     * @param value
     */
    @JvmName("iwhsqrsmtwxopgtr")
    public suspend fun healthCheckDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckDomain = mapped
    }

    /**
     * @param value
     */
    @JvmName("fqfsvghbefcbypqq")
    public suspend fun healthCheckHttpCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckHttpCode = mapped
    }

    /**
     * @param value
     */
    @JvmName("ifxddqdmfoylkyqq")
    public suspend fun healthCheckInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("ryjsqfwemcebfkai")
    public suspend fun healthCheckMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckMethod = mapped
    }

    /**
     * @param value
     */
    @JvmName("vyhemlifvmcbnmst")
    public suspend fun healthCheckTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("pnxlrodhiocqmled")
    public suspend fun healthCheckType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckType = mapped
    }

    /**
     * @param value
     */
    @JvmName("optkfofqvqcwewce")
    public suspend fun healthCheckUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckUri = mapped
    }

    /**
     * @param value
     */
    @JvmName("rasiyfbswuyidrnf")
    public suspend fun healthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthyThreshold = mapped
    }

    /**
     * @param value
     */
    @JvmName("kjooninfoiyvmija")
    public suspend fun idleTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeout = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'lb_port' has been removed since 1.211.0.
  """,
    )
    @JvmName("agmomjfnkfthjvna")
    public suspend fun lbPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbPort = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'lb_protocol' has been removed since 1.211.0.
  """,
    )
    @JvmName("rveilmyfnjslihdg")
    public suspend fun lbProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbProtocol = mapped
    }

    /**
     * @param value
     */
    @JvmName("nhhmrphygbubcxdy")
    public suspend fun listenerForward(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerForward = mapped
    }

    /**
     * @param value
     */
    @JvmName("aaekicbngadvwqtm")
    public suspend fun loadBalancerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerId = mapped
    }

    /**
     * @param value
     */
    @JvmName("ajwfhwxgfepndjxq")
    public suspend fun masterSlaveServerGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterSlaveServerGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("fbcrbkvqgugkddlv")
    public suspend fun persistenceTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.persistenceTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("afdgblwgohojtbmm")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value
     */
    @JvmName("xrbgnpcdpcocwunk")
    public suspend fun proxyProtocolV2Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyProtocolV2Enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("tvmtwaeoybrllfwx")
    public suspend fun requestTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("utmbumlsdsfbvhht")
    public suspend fun scheduler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduler = mapped
    }

    /**
     * @param value
     */
    @JvmName("onvwgtmnmokobapu")
    public suspend fun serverCertificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificateId = mapped
    }

    /**
     * @param value
     */
    @JvmName("timraovanxlrhorc")
    public suspend fun serverGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverGroupId = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'ssl_certificate_id' has been deprecated from 1.59.0 and using 'server_certificate_id'
      instead.
  """,
    )
    @JvmName("hgkwhysjsshbhlsr")
    public suspend fun sslCertificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificateId = mapped
    }

    /**
     * @param value
     */
    @JvmName("qdnxpitqqmuqqtfl")
    public suspend fun stickySession(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stickySession = mapped
    }

    /**
     * @param value
     */
    @JvmName("axjbindurqldykth")
    public suspend fun stickySessionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stickySessionType = mapped
    }

    /**
     * @param value
     */
    @JvmName("jkiwyhrkhladmvun")
    public suspend fun tlsCipherPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsCipherPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("ssaqbqmilgtqobej")
    public suspend fun unhealthyThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unhealthyThreshold = mapped
    }

    /**
     * @param value Whether to set additional HTTP Header field "X-Forwarded-For".
     */
    @JvmName("mrhfsqkecuftrpgo")
    public suspend fun xForwardedFor(`value`: ListenerXForwardedForArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xForwardedFor = mapped
    }

    /**
     * @param argument Whether to set additional HTTP Header field "X-Forwarded-For".
     */
    @JvmName("rmdvqertscshyoqe")
    public suspend fun xForwardedFor(argument: suspend ListenerXForwardedForArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerXForwardedForArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.xForwardedFor = mapped
    }

    internal fun build(): ListenerArgs = ListenerArgs(
        aclId = aclId,
        aclStatus = aclStatus,
        aclType = aclType,
        backendPort = backendPort,
        bandwidth = bandwidth,
        caCertificateId = caCertificateId,
        cookie = cookie,
        cookieTimeout = cookieTimeout,
        deleteProtectionValidation = deleteProtectionValidation,
        description = description,
        enableHttp2 = enableHttp2,
        establishedTimeout = establishedTimeout,
        forwardPort = forwardPort,
        frontendPort = frontendPort,
        gzip = gzip,
        healthCheck = healthCheck,
        healthCheckConnectPort = healthCheckConnectPort,
        healthCheckDomain = healthCheckDomain,
        healthCheckHttpCode = healthCheckHttpCode,
        healthCheckInterval = healthCheckInterval,
        healthCheckMethod = healthCheckMethod,
        healthCheckTimeout = healthCheckTimeout,
        healthCheckType = healthCheckType,
        healthCheckUri = healthCheckUri,
        healthyThreshold = healthyThreshold,
        idleTimeout = idleTimeout,
        lbPort = lbPort,
        lbProtocol = lbProtocol,
        listenerForward = listenerForward,
        loadBalancerId = loadBalancerId,
        masterSlaveServerGroupId = masterSlaveServerGroupId,
        persistenceTimeout = persistenceTimeout,
        protocol = protocol,
        proxyProtocolV2Enabled = proxyProtocolV2Enabled,
        requestTimeout = requestTimeout,
        scheduler = scheduler,
        serverCertificateId = serverCertificateId,
        serverGroupId = serverGroupId,
        sslCertificateId = sslCertificateId,
        stickySession = stickySession,
        stickySessionType = stickySessionType,
        tlsCipherPolicy = tlsCipherPolicy,
        unhealthyThreshold = unhealthyThreshold,
        xForwardedFor = xForwardedFor,
    )
}
