@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.alicloud.slb.LoadBalancerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * > **NOTE:** Deprecated since v1.123.1.
 * > **DEPRECATED:** This resource has been renamed to alicloud.slb.ApplicationLoadBalancer from version 1.123.1.
 * Provides an Application Load Balancer resource.
 * > **NOTE:** At present, to avoid some unnecessary regulation confusion, SLB can not support alicloud international account to create "paybybandwidth" instance.
 * > **NOTE:** The supported specifications vary by region. Currently not all regions support guaranteed-performance instances.
 * For more details about guaranteed-performance instance, see [Guaranteed-performance instances](https://www.alibabacloud.com/help/en/slb/classic-load-balancer/developer-reference/api-createloadbalancer-2#t4182.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraformslbconfig";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/21",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultLoadBalancer = new alicloud.slb.LoadBalancer("default", {
 *     loadBalancerName: name,
 *     loadBalancerSpec: "slb.s2.small",
 *     vswitchId: defaultSwitch.id,
 *     tags: {
 *         tag_a: "1",
 *         tag_b: "2",
 *         tag_c: "3",
 *         tag_d: "4",
 *         tag_e: "5",
 *         tag_f: "6",
 *         tag_g: "7",
 *         tag_h: "8",
 *         tag_i: "9",
 *         tag_j: "10",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraformslbconfig"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/12")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/21",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_load_balancer = alicloud.slb.LoadBalancer("default",
 *     load_balancer_name=name,
 *     load_balancer_spec="slb.s2.small",
 *     vswitch_id=default_switch.id,
 *     tags={
 *         "tag_a": "1",
 *         "tag_b": "2",
 *         "tag_c": "3",
 *         "tag_d": "4",
 *         "tag_e": "5",
 *         "tag_f": "6",
 *         "tag_g": "7",
 *         "tag_h": "8",
 *         "tag_i": "9",
 *         "tag_j": "10",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraformslbconfig";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/21",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultLoadBalancer = new AliCloud.Slb.LoadBalancer("default", new()
 *     {
 *         LoadBalancerName = name,
 *         LoadBalancerSpec = "slb.s2.small",
 *         VswitchId = defaultSwitch.Id,
 *         Tags =
 *         {
 *             { "tag_a", "1" },
 *             { "tag_b", "2" },
 *             { "tag_c", "3" },
 *             { "tag_d", "4" },
 *             { "tag_e", "5" },
 *             { "tag_f", "6" },
 *             { "tag_g", "7" },
 *             { "tag_h", "8" },
 *             { "tag_i", "9" },
 *             { "tag_j", "10" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraformslbconfig"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/21"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = slb.NewLoadBalancer(ctx, "default", &slb.LoadBalancerArgs{
 * 			LoadBalancerName: pulumi.String(name),
 * 			LoadBalancerSpec: pulumi.String("slb.s2.small"),
 * 			VswitchId:        defaultSwitch.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"tag_a": pulumi.String("1"),
 * 				"tag_b": pulumi.String("2"),
 * 				"tag_c": pulumi.String("3"),
 * 				"tag_d": pulumi.String("4"),
 * 				"tag_e": pulumi.String("5"),
 * 				"tag_f": pulumi.String("6"),
 * 				"tag_g": pulumi.String("7"),
 * 				"tag_h": pulumi.String("8"),
 * 				"tag_i": pulumi.String("9"),
 * 				"tag_j": pulumi.String("10"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.slb.LoadBalancer;
 * import com.pulumi.alicloud.slb.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraformslbconfig");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/21")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultLoadBalancer = new LoadBalancer("defaultLoadBalancer", LoadBalancerArgs.builder()
 *             .loadBalancerName(name)
 *             .loadBalancerSpec("slb.s2.small")
 *             .vswitchId(defaultSwitch.id())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag_a", 1),
 *                 Map.entry("tag_b", 2),
 *                 Map.entry("tag_c", 3),
 *                 Map.entry("tag_d", 4),
 *                 Map.entry("tag_e", 5),
 *                 Map.entry("tag_f", 6),
 *                 Map.entry("tag_g", 7),
 *                 Map.entry("tag_h", 8),
 *                 Map.entry("tag_i", 9),
 *                 Map.entry("tag_j", 10)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraformslbconfig
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/12
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/21
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultLoadBalancer:
 *     type: alicloud:slb:LoadBalancer
 *     name: default
 *     properties:
 *       loadBalancerName: ${name}
 *       loadBalancerSpec: slb.s2.small
 *       vswitchId: ${defaultSwitch.id}
 *       tags:
 *         tag_a: 1
 *         tag_b: 2
 *         tag_c: 3
 *         tag_d: 4
 *         tag_e: 5
 *         tag_f: 6
 *         tag_g: 7
 *         tag_h: 8
 *         tag_i: 9
 *         tag_j: 10
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Load balancer can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/loadBalancer:LoadBalancer example lb-abc123456
 * ```
 * @property address Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the correspond ing switch.
 * @property addressIpVersion The IP version of the SLB instance to be created, which can be set to ipv4 or ipv6 . Default to "ipv4". Now, only internet instance support ipv6 address.
 * @property addressType The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be "intranet".
 * - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
 * - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
 * @property bandwidth Valid
 * value is between 1 and 1000, If argument "internet_charge_type" is "paybytraffic", then this value will be ignore.
 * @property deleteProtection Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
 * @property instanceChargeType The billing method of the load balancer. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
 * @property internetChargeType Valid
 * values are `PayByBandwidth`, `PayByTraffic`. If this value is "PayByBandwidth", then argument "internet" must be "true". Default is "PayByTraffic". If load balancer launched in VPC, this value must be "PayByTraffic".
 * Before version 1.10.1, the valid values are "paybybandwidth" and "paybytraffic".
 * @property loadBalancerName
 * @property loadBalancerSpec The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance. Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`.
 * @property masterZoneId The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
 * @property modificationProtectionReason The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
 * @property modificationProtectionStatus The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value: `NonProtection`.
 * @property name Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
 * @property paymentType The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
 * @property period The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36].
 * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
 * @property resourceGroupId The Id of resource group which the SLB belongs.
 * @property slaveZoneId The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
 * @property specification The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
 * Launching "[Performance-guaranteed](https://www.alibabacloud.com/help/en/slb/product-overview/announcements-and-updates)" instance, it is must be specified and it valid values are: "slb.s1.small", "slb.s2.small", "slb.s2.medium",
 * "slb.s3.small", "slb.s3.medium", "slb.s3.large" and "slb.s4.large".
 * @property status The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.
 * > **NOTE:** A "Shared-Performance" instance can be changed to "Performance-guaranteed", but the change is irreversible.
 * > **NOTE:** To change a "Shared-Performance" instance to a "Performance-guaranteed" instance, the SLB will have a short probability of business interruption (10 seconds-30 seconds). Advise to change it during the business downturn, or migrate business to other SLB Instances by using GSLB before changing.
 * > **NOTE:** Currently, the alibaba cloud international account does not support creating a PrePaid SLB instance.
 * @property tags A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance.
 * @property vswitchId The vSwitch ID to launch in. If `address_type` is internet, it will be ignore.
 */
public data class LoadBalancerArgs
@Deprecated(
    message = """
This resource has been deprecated in favour of the ApplicationLoadBalancer resource
""",
)
constructor(
    public val address: Output<String>? = null,
    public val addressIpVersion: Output<String>? = null,
    public val addressType: Output<String>? = null,
    public val bandwidth: Output<Int>? = null,
    public val deleteProtection: Output<String>? = null,
    public val instanceChargeType: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val loadBalancerName: Output<String>? = null,
    public val loadBalancerSpec: Output<String>? = null,
    public val masterZoneId: Output<String>? = null,
    public val modificationProtectionReason: Output<String>? = null,
    public val modificationProtectionStatus: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name'
      instead
  """,
    )
    public val name: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val slaveZoneId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'specification' has been deprecated from provider version 1.123.1. New field
      'load_balancer_spec' instead
  """,
    )
    public val specification: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.LoadBalancerArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.LoadBalancerArgs =
        com.pulumi.alicloud.slb.LoadBalancerArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .addressIpVersion(addressIpVersion?.applyValue({ args0 -> args0 }))
            .addressType(addressType?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .deleteProtection(deleteProtection?.applyValue({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .loadBalancerSpec(loadBalancerSpec?.applyValue({ args0 -> args0 }))
            .masterZoneId(masterZoneId?.applyValue({ args0 -> args0 }))
            .modificationProtectionReason(modificationProtectionReason?.applyValue({ args0 -> args0 }))
            .modificationProtectionStatus(modificationProtectionStatus?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .slaveZoneId(slaveZoneId?.applyValue({ args0 -> args0 }))
            .specification(specification?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerArgs].
 */
@PulumiTagMarker
@Deprecated(
    message = """
This resource has been deprecated in favour of the ApplicationLoadBalancer resource
""",
)
public class LoadBalancerArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var addressIpVersion: Output<String>? = null

    private var addressType: Output<String>? = null

    private var bandwidth: Output<Int>? = null

    private var deleteProtection: Output<String>? = null

    private var instanceChargeType: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var loadBalancerName: Output<String>? = null

    private var loadBalancerSpec: Output<String>? = null

    private var masterZoneId: Output<String>? = null

    private var modificationProtectionReason: Output<String>? = null

    private var modificationProtectionStatus: Output<String>? = null

    private var name: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var resourceGroupId: Output<String>? = null

    private var slaveZoneId: Output<String>? = null

    private var specification: Output<String>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the correspond ing switch.
     */
    @JvmName("yxbubtcpvkihwdxj")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The IP version of the SLB instance to be created, which can be set to ipv4 or ipv6 . Default to "ipv4". Now, only internet instance support ipv6 address.
     */
    @JvmName("sxptrfjvhjjyhkrh")
    public suspend fun addressIpVersion(`value`: Output<String>) {
        this.addressIpVersion = value
    }

    /**
     * @param value The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be "intranet".
     * - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
     * - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
     */
    @JvmName("isolajbtprejmjvw")
    public suspend fun addressType(`value`: Output<String>) {
        this.addressType = value
    }

    /**
     * @param value Valid
     * value is between 1 and 1000, If argument "internet_charge_type" is "paybytraffic", then this value will be ignore.
     */
    @JvmName("lqjqxxioftlcwxov")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
     */
    @JvmName("ipvsrvhugxyeggtd")
    public suspend fun deleteProtection(`value`: Output<String>) {
        this.deleteProtection = value
    }

    /**
     * @param value The billing method of the load balancer. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
     */
    @JvmName("aoprbtayhdbkqrja")
    public suspend fun instanceChargeType(`value`: Output<String>) {
        this.instanceChargeType = value
    }

    /**
     * @param value Valid
     * values are `PayByBandwidth`, `PayByTraffic`. If this value is "PayByBandwidth", then argument "internet" must be "true". Default is "PayByTraffic". If load balancer launched in VPC, this value must be "PayByTraffic".
     * Before version 1.10.1, the valid values are "paybybandwidth" and "paybytraffic".
     */
    @JvmName("nxwpxjwtljnrpgwf")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value
     */
    @JvmName("yylashwiqyimxgcg")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance. Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`.
     */
    @JvmName("lndulhytinyoqmyc")
    public suspend fun loadBalancerSpec(`value`: Output<String>) {
        this.loadBalancerSpec = value
    }

    /**
     * @param value The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
     */
    @JvmName("doqjdecnhtndopnc")
    public suspend fun masterZoneId(`value`: Output<String>) {
        this.masterZoneId = value
    }

    /**
     * @param value The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
     */
    @JvmName("dqclttedrxkgtbqq")
    public suspend fun modificationProtectionReason(`value`: Output<String>) {
        this.modificationProtectionReason = value
    }

    /**
     * @param value The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value: `NonProtection`.
     */
    @JvmName("quvkqmxxgoxxkaiq")
    public suspend fun modificationProtectionStatus(`value`: Output<String>) {
        this.modificationProtectionStatus = value
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name'
      instead
  """,
    )
    @JvmName("suajayasouvlcwfw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
     */
    @JvmName("lpkwonjjlxwqgfab")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36].
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("bcqqsbypqksvxasc")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The Id of resource group which the SLB belongs.
     */
    @JvmName("sykbxxfbwftewxuq")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
     */
    @JvmName("pqkcvpowbloishsr")
    public suspend fun slaveZoneId(`value`: Output<String>) {
        this.slaveZoneId = value
    }

    /**
     * @param value The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
     * Launching "[Performance-guaranteed](https://www.alibabacloud.com/help/en/slb/product-overview/announcements-and-updates)" instance, it is must be specified and it valid values are: "slb.s1.small", "slb.s2.small", "slb.s2.medium",
     * "slb.s3.small", "slb.s3.medium", "slb.s3.large" and "slb.s4.large".
     */
    @Deprecated(
        message = """
  Field 'specification' has been deprecated from provider version 1.123.1. New field
      'load_balancer_spec' instead
  """,
    )
    @JvmName("gxsbgdarpbrvnddt")
    public suspend fun specification(`value`: Output<String>) {
        this.specification = value
    }

    /**
     * @param value The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.
     * > **NOTE:** A "Shared-Performance" instance can be changed to "Performance-guaranteed", but the change is irreversible.
     * > **NOTE:** To change a "Shared-Performance" instance to a "Performance-guaranteed" instance, the SLB will have a short probability of business interruption (10 seconds-30 seconds). Advise to change it during the business downturn, or migrate business to other SLB Instances by using GSLB before changing.
     * > **NOTE:** Currently, the alibaba cloud international account does not support creating a PrePaid SLB instance.
     */
    @JvmName("rhsyigfotgcdfagy")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance.
     */
    @JvmName("jnxxblejuwbwduma")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The vSwitch ID to launch in. If `address_type` is internet, it will be ignore.
     */
    @JvmName("sbcivpikouuulvvs")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the correspond ing switch.
     */
    @JvmName("nthdesvohrsmimpt")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The IP version of the SLB instance to be created, which can be set to ipv4 or ipv6 . Default to "ipv4". Now, only internet instance support ipv6 address.
     */
    @JvmName("isfvlntoseghdqss")
    public suspend fun addressIpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressIpVersion = mapped
    }

    /**
     * @param value The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be "intranet".
     * - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
     * - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
     */
    @JvmName("dkktwywvoqqcqauk")
    public suspend fun addressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressType = mapped
    }

    /**
     * @param value Valid
     * value is between 1 and 1000, If argument "internet_charge_type" is "paybytraffic", then this value will be ignore.
     */
    @JvmName("ejqmaeqaelsmnsob")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
     */
    @JvmName("wbkskwjeuriwtile")
    public suspend fun deleteProtection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteProtection = mapped
    }

    /**
     * @param value The billing method of the load balancer. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
     */
    @JvmName("uptucosjrkfblkau")
    public suspend fun instanceChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeType = mapped
    }

    /**
     * @param value Valid
     * values are `PayByBandwidth`, `PayByTraffic`. If this value is "PayByBandwidth", then argument "internet" must be "true". Default is "PayByTraffic". If load balancer launched in VPC, this value must be "PayByTraffic".
     * Before version 1.10.1, the valid values are "paybybandwidth" and "paybytraffic".
     */
    @JvmName("xxynansjqtddqgdi")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value
     */
    @JvmName("nxxadwgccktvrklt")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance. Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`.
     */
    @JvmName("emljuipijnwepfgd")
    public suspend fun loadBalancerSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerSpec = mapped
    }

    /**
     * @param value The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
     */
    @JvmName("lspocuigtfsgwbkl")
    public suspend fun masterZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterZoneId = mapped
    }

    /**
     * @param value The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
     */
    @JvmName("uwfafyhgsfxwfleg")
    public suspend fun modificationProtectionReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modificationProtectionReason = mapped
    }

    /**
     * @param value The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value: `NonProtection`.
     */
    @JvmName("fgrqwdxgkdwxvtmu")
    public suspend fun modificationProtectionStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modificationProtectionStatus = mapped
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name'
      instead
  """,
    )
    @JvmName("fxbckwyrpfqvatsm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
     */
    @JvmName("ucjjvhptluydgrjx")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36].
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("seatccreowpirmoy")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The Id of resource group which the SLB belongs.
     */
    @JvmName("mnnjfidiljqutenf")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
     */
    @JvmName("hjnkemkcmtowjosp")
    public suspend fun slaveZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slaveZoneId = mapped
    }

    /**
     * @param value The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
     * Launching "[Performance-guaranteed](https://www.alibabacloud.com/help/en/slb/product-overview/announcements-and-updates)" instance, it is must be specified and it valid values are: "slb.s1.small", "slb.s2.small", "slb.s2.medium",
     * "slb.s3.small", "slb.s3.medium", "slb.s3.large" and "slb.s4.large".
     */
    @Deprecated(
        message = """
  Field 'specification' has been deprecated from provider version 1.123.1. New field
      'load_balancer_spec' instead
  """,
    )
    @JvmName("glvjahuqdfrdxkrc")
    public suspend fun specification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.specification = mapped
    }

    /**
     * @param value The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.
     * > **NOTE:** A "Shared-Performance" instance can be changed to "Performance-guaranteed", but the change is irreversible.
     * > **NOTE:** To change a "Shared-Performance" instance to a "Performance-guaranteed" instance, the SLB will have a short probability of business interruption (10 seconds-30 seconds). Advise to change it during the business downturn, or migrate business to other SLB Instances by using GSLB before changing.
     * > **NOTE:** Currently, the alibaba cloud international account does not support creating a PrePaid SLB instance.
     */
    @JvmName("fbdjqcmukmnxxcyd")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance.
     */
    @JvmName("xyahaekphbunjgip")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance.
     */
    @JvmName("pjtcdietdqypmhjm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The vSwitch ID to launch in. If `address_type` is internet, it will be ignore.
     */
    @JvmName("iinxyiabdtggmeui")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): LoadBalancerArgs = LoadBalancerArgs(
        address = address,
        addressIpVersion = addressIpVersion,
        addressType = addressType,
        bandwidth = bandwidth,
        deleteProtection = deleteProtection,
        instanceChargeType = instanceChargeType,
        internetChargeType = internetChargeType,
        loadBalancerName = loadBalancerName,
        loadBalancerSpec = loadBalancerSpec,
        masterZoneId = masterZoneId,
        modificationProtectionReason = modificationProtectionReason,
        modificationProtectionStatus = modificationProtectionStatus,
        name = name,
        paymentType = paymentType,
        period = period,
        resourceGroupId = resourceGroupId,
        slaveZoneId = slaveZoneId,
        specification = specification,
        status = status,
        tags = tags,
        vswitchId = vswitchId,
    )
}
