@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.alicloud.slb.ServerGroupArgs.builder
import com.pulumi.alicloud.slb.kotlin.inputs.ServerGroupServerArgs
import com.pulumi.alicloud.slb.kotlin.inputs.ServerGroupServerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Load Balancer Virtual Backend Server Group resource.
 * For information about Load Balancer Virtual Backend Server Group and how to use it, see [What is Virtual Backend Server Group](https://www.alibabacloud.com/help/en/doc-detail/35215.html).
 * > **NOTE:** Available since v1.6.0.
 * > **NOTE:** One ECS instance can be added into multiple virtual server groups.
 * > **NOTE:** One virtual server group can be attached with multiple listeners in one load balancer.
 * > **NOTE:** One Classic and Internet load balancer, its virtual server group can add Classic and VPC ECS instances.
 * > **NOTE:** One Classic and Intranet load balancer, its virtual server group can only add Classic ECS instances.
 * > **NOTE:** One VPC load balancer, its virtual server group can only add the same VPC ECS instances.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/16",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultApplicationLoadBalancer = new alicloud.slb.ApplicationLoadBalancer("default", {
 *     loadBalancerName: name,
 *     vswitchId: defaultSwitch.id,
 *     loadBalancerSpec: "slb.s2.small",
 * });
 * const defaultServerGroup = new alicloud.slb.ServerGroup("default", {
 *     loadBalancerId: defaultApplicationLoadBalancer.id,
 *     name: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/16",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("default",
 *     load_balancer_name=name,
 *     vswitch_id=default_switch.id,
 *     load_balancer_spec="slb.s2.small")
 * default_server_group = alicloud.slb.ServerGroup("default",
 *     load_balancer_id=default_application_load_balancer.id,
 *     name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/16",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultApplicationLoadBalancer = new AliCloud.Slb.ApplicationLoadBalancer("default", new()
 *     {
 *         LoadBalancerName = name,
 *         VswitchId = defaultSwitch.Id,
 *         LoadBalancerSpec = "slb.s2.small",
 *     });
 *     var defaultServerGroup = new AliCloud.Slb.ServerGroup("default", new()
 *     {
 *         LoadBalancerId = defaultApplicationLoadBalancer.Id,
 *         Name = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/16"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultApplicationLoadBalancer, err := slb.NewApplicationLoadBalancer(ctx, "default", &slb.ApplicationLoadBalancerArgs{
 * 			LoadBalancerName: pulumi.String(name),
 * 			VswitchId:        defaultSwitch.ID(),
 * 			LoadBalancerSpec: pulumi.String("slb.s2.small"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = slb.NewServerGroup(ctx, "default", &slb.ServerGroupArgs{
 * 			LoadBalancerId: defaultApplicationLoadBalancer.ID(),
 * 			Name:           pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.slb.ApplicationLoadBalancer;
 * import com.pulumi.alicloud.slb.ApplicationLoadBalancerArgs;
 * import com.pulumi.alicloud.slb.ServerGroup;
 * import com.pulumi.alicloud.slb.ServerGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/16")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultApplicationLoadBalancer = new ApplicationLoadBalancer("defaultApplicationLoadBalancer", ApplicationLoadBalancerArgs.builder()
 *             .loadBalancerName(name)
 *             .vswitchId(defaultSwitch.id())
 *             .loadBalancerSpec("slb.s2.small")
 *             .build());
 *         var defaultServerGroup = new ServerGroup("defaultServerGroup", ServerGroupArgs.builder()
 *             .loadBalancerId(defaultApplicationLoadBalancer.id())
 *             .name(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/16
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultApplicationLoadBalancer:
 *     type: alicloud:slb:ApplicationLoadBalancer
 *     name: default
 *     properties:
 *       loadBalancerName: ${name}
 *       vswitchId: ${defaultSwitch.id}
 *       loadBalancerSpec: slb.s2.small
 *   defaultServerGroup:
 *     type: alicloud:slb:ServerGroup
 *     name: default
 *     properties:
 *       loadBalancerId: ${defaultApplicationLoadBalancer.id}
 *       name: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Load Balancer Virtual Backend Server Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/serverGroup:ServerGroup example <id>
 * ```
 * @property deleteProtectionValidation Checking DeleteProtection of SLB instance before deleting. Default value: `false`. If `delete_protection_validation` is set to `true`, this resource will not be deleted when its SLB instance enabled DeleteProtection.
 * @property loadBalancerId The ID of the Server Load Balancer (SLB) instance.
 * @property name The name of the vServer group. Default value: `tf-server-group`.
 * @property servers The list of backend servers to be added. See `servers` below.
 * > **NOTE:** Field `servers` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class ServerGroupArgs(
    public val deleteProtectionValidation: Output<Boolean>? = null,
    public val loadBalancerId: Output<String>? = null,
    public val name: Output<String>? = null,
    @Deprecated(
        message = """
  Field `servers` has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
  """,
    )
    public val servers: Output<List<ServerGroupServerArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.ServerGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.ServerGroupArgs =
        com.pulumi.alicloud.slb.ServerGroupArgs.builder()
            .deleteProtectionValidation(deleteProtectionValidation?.applyValue({ args0 -> args0 }))
            .loadBalancerId(loadBalancerId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .servers(
                servers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServerGroupArgs].
 */
@PulumiTagMarker
public class ServerGroupArgsBuilder internal constructor() {
    private var deleteProtectionValidation: Output<Boolean>? = null

    private var loadBalancerId: Output<String>? = null

    private var name: Output<String>? = null

    private var servers: Output<List<ServerGroupServerArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Checking DeleteProtection of SLB instance before deleting. Default value: `false`. If `delete_protection_validation` is set to `true`, this resource will not be deleted when its SLB instance enabled DeleteProtection.
     */
    @JvmName("spsgctsnewhwsugv")
    public suspend fun deleteProtectionValidation(`value`: Output<Boolean>) {
        this.deleteProtectionValidation = value
    }

    /**
     * @param value The ID of the Server Load Balancer (SLB) instance.
     */
    @JvmName("fhdgedsutygjqger")
    public suspend fun loadBalancerId(`value`: Output<String>) {
        this.loadBalancerId = value
    }

    /**
     * @param value The name of the vServer group. Default value: `tf-server-group`.
     */
    @JvmName("ylxvsrsbcjbunyau")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The list of backend servers to be added. See `servers` below.
     * > **NOTE:** Field `servers` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
     */
    @Deprecated(
        message = """
  Field `servers` has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
  """,
    )
    @JvmName("vwpvromdgnomqibj")
    public suspend fun servers(`value`: Output<List<ServerGroupServerArgs>>) {
        this.servers = value
    }

    @JvmName("dqmhxulgxjcpdsfi")
    public suspend fun servers(vararg values: Output<ServerGroupServerArgs>) {
        this.servers = Output.all(values.asList())
    }

    /**
     * @param values The list of backend servers to be added. See `servers` below.
     * > **NOTE:** Field `servers` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
     */
    @Deprecated(
        message = """
  Field `servers` has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
  """,
    )
    @JvmName("kowpoegodfnfovqp")
    public suspend fun servers(values: List<Output<ServerGroupServerArgs>>) {
        this.servers = Output.all(values)
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("hijiovvrgpbvmvig")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Checking DeleteProtection of SLB instance before deleting. Default value: `false`. If `delete_protection_validation` is set to `true`, this resource will not be deleted when its SLB instance enabled DeleteProtection.
     */
    @JvmName("wmwsulbwpsudhkeo")
    public suspend fun deleteProtectionValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteProtectionValidation = mapped
    }

    /**
     * @param value The ID of the Server Load Balancer (SLB) instance.
     */
    @JvmName("ehxtlwvbpeohlsow")
    public suspend fun loadBalancerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerId = mapped
    }

    /**
     * @param value The name of the vServer group. Default value: `tf-server-group`.
     */
    @JvmName("pfbgfibfbejjgmra")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The list of backend servers to be added. See `servers` below.
     * > **NOTE:** Field `servers` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
     */
    @Deprecated(
        message = """
  Field `servers` has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
  """,
    )
    @JvmName("prcgcapmueyagvas")
    public suspend fun servers(`value`: List<ServerGroupServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servers = mapped
    }

    /**
     * @param argument The list of backend servers to be added. See `servers` below.
     * > **NOTE:** Field `servers` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
     */
    @Deprecated(
        message = """
  Field `servers` has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
  """,
    )
    @JvmName("fcbgaroumeeatenf")
    public suspend fun servers(argument: List<suspend ServerGroupServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServerGroupServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.servers = mapped
    }

    /**
     * @param argument The list of backend servers to be added. See `servers` below.
     * > **NOTE:** Field `servers` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
     */
    @Deprecated(
        message = """
  Field `servers` has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
  """,
    )
    @JvmName("fgfaslpxbuucyrjh")
    public suspend fun servers(vararg argument: suspend ServerGroupServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServerGroupServerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.servers = mapped
    }

    /**
     * @param argument The list of backend servers to be added. See `servers` below.
     * > **NOTE:** Field `servers` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
     */
    @Deprecated(
        message = """
  Field `servers` has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
  """,
    )
    @JvmName("raacqrbmlxklidso")
    public suspend fun servers(argument: suspend ServerGroupServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServerGroupServerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.servers = mapped
    }

    /**
     * @param values The list of backend servers to be added. See `servers` below.
     * > **NOTE:** Field `servers` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
     */
    @Deprecated(
        message = """
  Field `servers` has been deprecated from provider version 1.163.0 and it will be removed in the
      future version. Please use the new resource `alicloud.slb.ServerGroupServerAttachment`.
  """,
    )
    @JvmName("lhljoreowkgllbaw")
    public suspend fun servers(vararg values: ServerGroupServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servers = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("fcfoubtbwsrccknq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("oynhkaevosxxqnru")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServerGroupArgs = ServerGroupArgs(
        deleteProtectionValidation = deleteProtectionValidation,
        loadBalancerId = loadBalancerId,
        name = name,
        servers = servers,
        tags = tags,
    )
}
