@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerGroupServerAttachment].
 */
@PulumiTagMarker
public class ServerGroupServerAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerGroupServerAttachmentArgs = ServerGroupServerAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerGroupServerAttachmentArgsBuilder.() -> Unit) {
        val builder = ServerGroupServerAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerGroupServerAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.slb.ServerGroupServerAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerGroupServerAttachment(builtJavaResource)
    }
}

/**
 * > **NOTE:** Available in v1.163.0+.
 * For information about server group server attachment and how to use it, see [Configure a server group server attachment](https://www.alibabacloud.com/help/en/doc-detail/35218.html).
 * > **NOTE:** Applying this resource may conflict with applying `alicloud.slb.Listener`,
 * and the `alicloud.slb.Listener` block should use `depends_on = [alicloud_slb_server_group_server_attachment&#46;xxx]` to avoid it.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const slbServerGroupServerAttachment = config.get("slbServerGroupServerAttachment") || "terraform-example";
 * const slbServerGroupServerAttachmentCount = config.getNumber("slbServerGroupServerAttachmentCount") || 5;
 * const serverAttachment = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const serverAttachmentGetInstanceTypes = serverAttachment.then(serverAttachment => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: serverAttachment.zones?.[0]?.id,
 *     cpuCoreCount: 1,
 *     memorySize: 2,
 * }));
 * const serverAttachmentGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const serverAttachmentNetwork = new alicloud.vpc.Network("server_attachment", {
 *     vpcName: slbServerGroupServerAttachment,
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const serverAttachmentSwitch = new alicloud.vpc.Switch("server_attachment", {
 *     vswitchName: slbServerGroupServerAttachment,
 *     cidrBlock: "172.17.3.0/24",
 *     vpcId: serverAttachmentNetwork.id,
 *     zoneId: serverAttachment.then(serverAttachment => serverAttachment.zones?.[0]?.id),
 * });
 * const serverAttachmentSecurityGroup = new alicloud.ecs.SecurityGroup("server_attachment", {
 *     name: slbServerGroupServerAttachment,
 *     vpcId: serverAttachmentNetwork.id,
 * });
 * const serverAttachmentInstance: alicloud.ecs.Instance[] = [];
 * for (const range = {value: 0}; range.value < slbServerGroupServerAttachmentCount; range.value++) {
 *     serverAttachmentInstance.push(new alicloud.ecs.Instance(`server_attachment-${range.value}`, {
 *         imageId: serverAttachmentGetImages.then(serverAttachmentGetImages => serverAttachmentGetImages.images?.[0]?.id),
 *         instanceType: serverAttachmentGetInstanceTypes.then(serverAttachmentGetInstanceTypes => serverAttachmentGetInstanceTypes.instanceTypes?.[0]?.id),
 *         instanceName: slbServerGroupServerAttachment,
 *         securityGroups: [serverAttachmentSecurityGroup].map(__item => __item.id),
 *         internetChargeType: "PayByTraffic",
 *         internetMaxBandwidthOut: 10,
 *         availabilityZone: serverAttachment.then(serverAttachment => serverAttachment.zones?.[0]?.id),
 *         instanceChargeType: "PostPaid",
 *         systemDiskCategory: "cloud_efficiency",
 *         vswitchId: serverAttachmentSwitch.id,
 *     }));
 * }
 * const serverAttachmentApplicationLoadBalancer = new alicloud.slb.ApplicationLoadBalancer("server_attachment", {
 *     loadBalancerName: slbServerGroupServerAttachment,
 *     vswitchId: serverAttachmentSwitch.id,
 *     loadBalancerSpec: "slb.s2.small",
 *     addressType: "intranet",
 * });
 * const serverAttachmentServerGroup = new alicloud.slb.ServerGroup("server_attachment", {
 *     loadBalancerId: serverAttachmentApplicationLoadBalancer.id,
 *     name: slbServerGroupServerAttachment,
 * });
 * const serverAttachmentServerGroupServerAttachment: alicloud.slb.ServerGroupServerAttachment[] = [];
 * for (const range = {value: 0}; range.value < slbServerGroupServerAttachmentCount; range.value++) {
 *     serverAttachmentServerGroupServerAttachment.push(new alicloud.slb.ServerGroupServerAttachment(`server_attachment-${range.value}`, {
 *         serverGroupId: serverAttachmentServerGroup.id,
 *         serverId: serverAttachmentInstance[range&#46;value].id,
 *         port: 8080,
 *         weight: 0,
 *     }));
 * }
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * slb_server_group_server_attachment = config.get("slbServerGroupServerAttachment")
 * if slb_server_group_server_attachment is None:
 *     slb_server_group_server_attachment = "terraform-example"
 * slb_server_group_server_attachment_count = config.get_float("slbServerGroupServerAttachmentCount")
 * if slb_server_group_server_attachment_count is None:
 *     slb_server_group_server_attachment_count = 5
 * server_attachment = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * server_attachment_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=server_attachment.zones[0].id,
 *     cpu_core_count=1,
 *     memory_size=2)
 * server_attachment_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * server_attachment_network = alicloud.vpc.Network("server_attachment",
 *     vpc_name=slb_server_group_server_attachment,
 *     cidr_block="172.17.3.0/24")
 * server_attachment_switch = alicloud.vpc.Switch("server_attachment",
 *     vswitch_name=slb_server_group_server_attachment,
 *     cidr_block="172.17.3.0/24",
 *     vpc_id=server_attachment_network.id,
 *     zone_id=server_attachment.zones[0].id)
 * server_attachment_security_group = alicloud.ecs.SecurityGroup("server_attachment",
 *     name=slb_server_group_server_attachment,
 *     vpc_id=server_attachment_network.id)
 * server_attachment_instance = []
 * for range in [{"value": i} for i in range(0, slb_server_group_server_attachment_count)]:
 *     server_attachment_instance.append(alicloud.ecs.Instance(f"server_attachment-{range['value']}",
 *         image_id=server_attachment_get_images.images[0].id,
 *         instance_type=server_attachment_get_instance_types.instance_types[0].id,
 *         instance_name=slb_server_group_server_attachment,
 *         security_groups=[__item&#46;id for __item in [server_attachment_security_group]],
 *         internet_charge_type="PayByTraffic",
 *         internet_max_bandwidth_out=10,
 *         availability_zone=server_attachment.zones[0].id,
 *         instance_charge_type="PostPaid",
 *         system_disk_category="cloud_efficiency",
 *         vswitch_id=server_attachment_switch.id))
 * server_attachment_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("server_attachment",
 *     load_balancer_name=slb_server_group_server_attachment,
 *     vswitch_id=server_attachment_switch.id,
 *     load_balancer_spec="slb.s2.small",
 *     address_type="intranet")
 * server_attachment_server_group = alicloud.slb.ServerGroup("server_attachment",
 *     load_balancer_id=server_attachment_application_load_balancer.id,
 *     name=slb_server_group_server_attachment)
 * server_attachment_server_group_server_attachment = []
 * for range in [{"value": i} for i in range(0, slb_server_group_server_attachment_count)]:
 *     server_attachment_server_group_server_attachment.append(alicloud.slb.ServerGroupServerAttachment(f"server_attachment-{range['value']}",
 *         server_group_id=server_attachment_server_group.id,
 *         server_id=server_attachment_instance[range["value"]].id,
 *         port=8080,
 *         weight=0))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var slbServerGroupServerAttachment = config.Get("slbServerGroupServerAttachment") ?? "terraform-example";
 *     var slbServerGroupServerAttachmentCount = config.GetDouble("slbServerGroupServerAttachmentCount") ?? 5;
 *     var serverAttachment = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var serverAttachmentGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = serverAttachment.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 1,
 *         MemorySize = 2,
 *     });
 *     var serverAttachmentGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var serverAttachmentNetwork = new AliCloud.Vpc.Network("server_attachment", new()
 *     {
 *         VpcName = slbServerGroupServerAttachment,
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var serverAttachmentSwitch = new AliCloud.Vpc.Switch("server_attachment", new()
 *     {
 *         VswitchName = slbServerGroupServerAttachment,
 *         CidrBlock = "172.17.3.0/24",
 *         VpcId = serverAttachmentNetwork.Id,
 *         ZoneId = serverAttachment.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var serverAttachmentSecurityGroup = new AliCloud.Ecs.SecurityGroup("server_attachment", new()
 *     {
 *         Name = slbServerGroupServerAttachment,
 *         VpcId = serverAttachmentNetwork.Id,
 *     });
 *     var serverAttachmentInstance = new List<AliCloud.Ecs.Instance>();
 *     for (var rangeIndex = 0; rangeIndex < slbServerGroupServerAttachmentCount; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         serverAttachmentInstance.Add(new AliCloud.Ecs.Instance($"server_attachment-{range.Value}", new()
 *         {
 *             ImageId = serverAttachmentGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *             InstanceType = serverAttachmentGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *             InstanceName = slbServerGroupServerAttachment,
 *             SecurityGroups = new[]
 *             {
 *                 serverAttachmentSecurityGroup,
 *             }.Select(__item => __item.Id).ToList(),
 *             InternetChargeType = "PayByTraffic",
 *             InternetMaxBandwidthOut = 10,
 *             AvailabilityZone = serverAttachment.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *             InstanceChargeType = "PostPaid",
 *             SystemDiskCategory = "cloud_efficiency",
 *             VswitchId = serverAttachmentSwitch.Id,
 *         }));
 *     }
 *     var serverAttachmentApplicationLoadBalancer = new AliCloud.Slb.ApplicationLoadBalancer("server_attachment", new()
 *     {
 *         LoadBalancerName = slbServerGroupServerAttachment,
 *         VswitchId = serverAttachmentSwitch.Id,
 *         LoadBalancerSpec = "slb.s2.small",
 *         AddressType = "intranet",
 *     });
 *     var serverAttachmentServerGroup = new AliCloud.Slb.ServerGroup("server_attachment", new()
 *     {
 *         LoadBalancerId = serverAttachmentApplicationLoadBalancer.Id,
 *         Name = slbServerGroupServerAttachment,
 *     });
 *     var serverAttachmentServerGroupServerAttachment = new List<AliCloud.Slb.ServerGroupServerAttachment>();
 *     for (var rangeIndex = 0; rangeIndex < slbServerGroupServerAttachmentCount; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         serverAttachmentServerGroupServerAttachment.Add(new AliCloud.Slb.ServerGroupServerAttachment($"server_attachment-{range.Value}", new()
 *         {
 *             ServerGroupId = serverAttachmentServerGroup.Id,
 *             ServerId = serverAttachmentInstance[range&#46;Value].Id,
 *             Port = 8080,
 *             Weight = 0,
 *         }));
 *     }
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * cfg := config.New(ctx, "")
 * slbServerGroupServerAttachment := "terraform-example";
 * if param := cfg.Get("slbServerGroupServerAttachment"); param != ""{
 * slbServerGroupServerAttachment = param
 * }
 * slbServerGroupServerAttachmentCount := float64(5);
 * if param := cfg.GetFloat64("slbServerGroupServerAttachmentCount"); param != 0 {
 * slbServerGroupServerAttachmentCount = param
 * }
 * serverAttachment, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * AvailableDiskCategory: pulumi.StringRef("cloud_efficiency"),
 * AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * serverAttachmentGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * AvailabilityZone: pulumi.StringRef(serverAttachment.Zones[0].Id),
 * CpuCoreCount: pulumi.IntRef(1),
 * MemorySize: pulumi.Float64Ref(2),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * serverAttachmentGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * NameRegex: pulumi.StringRef("^ubuntu_18.*64"),
 * MostRecent: pulumi.BoolRef(true),
 * Owners: pulumi.StringRef("system"),
 * }, nil);
 * if err != nil {
 * return err
 * }
 * serverAttachmentNetwork, err := vpc.NewNetwork(ctx, "server_attachment", &vpc.NetworkArgs{
 * VpcName: pulumi.String(slbServerGroupServerAttachment),
 * CidrBlock: pulumi.String("172.17.3.0/24"),
 * })
 * if err != nil {
 * return err
 * }
 * serverAttachmentSwitch, err := vpc.NewSwitch(ctx, "server_attachment", &vpc.SwitchArgs{
 * VswitchName: pulumi.String(slbServerGroupServerAttachment),
 * CidrBlock: pulumi.String("172.17.3.0/24"),
 * VpcId: serverAttachmentNetwork.ID(),
 * ZoneId: pulumi.String(serverAttachment.Zones[0].Id),
 * })
 * if err != nil {
 * return err
 * }
 * serverAttachmentSecurityGroup, err := ecs.NewSecurityGroup(ctx, "server_attachment", &ecs.SecurityGroupArgs{
 * Name: pulumi.String(slbServerGroupServerAttachment),
 * VpcId: serverAttachmentNetwork.ID(),
 * })
 * if err != nil {
 * return err
 * }
 * var splat0 pulumi.StringArray
 * for _, val0 := range %!v(PANIC=Format method: fatal: An assertion has failed: tok: ) {
 * splat0 = append(splat0, val0.ID())
 * }
 * var serverAttachmentInstance []*ecs.Instance
 * for index := 0; index < slbServerGroupServerAttachmentCount; index++ {
 *     key0 := index
 *     _ := index
 * __res, err := ecs.NewInstance(ctx, fmt.Sprintf("server_attachment-%v", key0), &ecs.InstanceArgs{
 * ImageId: pulumi.String(serverAttachmentGetImages.Images[0].Id),
 * InstanceType: pulumi.String(serverAttachmentGetInstanceTypes.InstanceTypes[0].Id),
 * InstanceName: pulumi.String(slbServerGroupServerAttachment),
 * SecurityGroups: splat0,
 * InternetChargeType: pulumi.String("PayByTraffic"),
 * InternetMaxBandwidthOut: pulumi.Int(10),
 * AvailabilityZone: pulumi.String(serverAttachment.Zones[0].Id),
 * InstanceChargeType: pulumi.String("PostPaid"),
 * SystemDiskCategory: pulumi.String("cloud_efficiency"),
 * VswitchId: serverAttachmentSwitch.ID(),
 * })
 * if err != nil {
 * return err
 * }
 * serverAttachmentInstance = append(serverAttachmentInstance, __res)
 * }
 * serverAttachmentApplicationLoadBalancer, err := slb.NewApplicationLoadBalancer(ctx, "server_attachment", &slb.ApplicationLoadBalancerArgs{
 * LoadBalancerName: pulumi.String(slbServerGroupServerAttachment),
 * VswitchId: serverAttachmentSwitch.ID(),
 * LoadBalancerSpec: pulumi.String("slb.s2.small"),
 * AddressType: pulumi.String("intranet"),
 * })
 * if err != nil {
 * return err
 * }
 * serverAttachmentServerGroup, err := slb.NewServerGroup(ctx, "server_attachment", &slb.ServerGroupArgs{
 * LoadBalancerId: serverAttachmentApplicationLoadBalancer.ID(),
 * Name: pulumi.String(slbServerGroupServerAttachment),
 * })
 * if err != nil {
 * return err
 * }
 * var serverAttachmentServerGroupServerAttachment []*slb.ServerGroupServerAttachment
 * for index := 0; index < slbServerGroupServerAttachmentCount; index++ {
 *     key0 := index
 *     val0 := index
 * __res, err := slb.NewServerGroupServerAttachment(ctx, fmt.Sprintf("server_attachment-%v", key0), &slb.ServerGroupServerAttachmentArgs{
 * ServerGroupId: serverAttachmentServerGroup.ID(),
 * ServerId: serverAttachmentInstance[val0].ID(),
 * Port: pulumi.Int(8080),
 * Weight: pulumi.Int(0),
 * })
 * if err != nil {
 * return err
 * }
 * serverAttachmentServerGroupServerAttachment = append(serverAttachmentServerGroupServerAttachment, __res)
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.slb.ApplicationLoadBalancer;
 * import com.pulumi.alicloud.slb.ApplicationLoadBalancerArgs;
 * import com.pulumi.alicloud.slb.ServerGroup;
 * import com.pulumi.alicloud.slb.ServerGroupArgs;
 * import com.pulumi.alicloud.slb.ServerGroupServerAttachment;
 * import com.pulumi.alicloud.slb.ServerGroupServerAttachmentArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var slbServerGroupServerAttachment = config.get("slbServerGroupServerAttachment").orElse("terraform-example");
 *         final var slbServerGroupServerAttachmentCount = config.get("slbServerGroupServerAttachmentCount").orElse(5);
 *         final var serverAttachment = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var serverAttachmentGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(serverAttachment.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .cpuCoreCount(1)
 *             .memorySize(2)
 *             .build());
 *         final var serverAttachmentGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var serverAttachmentNetwork = new Network("serverAttachmentNetwork", NetworkArgs.builder()
 *             .vpcName(slbServerGroupServerAttachment)
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var serverAttachmentSwitch = new Switch("serverAttachmentSwitch", SwitchArgs.builder()
 *             .vswitchName(slbServerGroupServerAttachment)
 *             .cidrBlock("172.17.3.0/24")
 *             .vpcId(serverAttachmentNetwork.id())
 *             .zoneId(serverAttachment.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var serverAttachmentSecurityGroup = new SecurityGroup("serverAttachmentSecurityGroup", SecurityGroupArgs.builder()
 *             .name(slbServerGroupServerAttachment)
 *             .vpcId(serverAttachmentNetwork.id())
 *             .build());
 *         for (var i = 0; i < slbServerGroupServerAttachmentCount; i++) {
 *             new Instance("serverAttachmentInstance-" + i, InstanceArgs.builder()
 *                 .imageId(serverAttachmentGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *                 .instanceType(serverAttachmentGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *                 .instanceName(slbServerGroupServerAttachment)
 *                 .securityGroups(serverAttachmentSecurityGroup.stream().map(element -> element.id()).collect(toList()))
 *                 .internetChargeType("PayByTraffic")
 *                 .internetMaxBandwidthOut("10")
 *                 .availabilityZone(serverAttachment.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *                 .instanceChargeType("PostPaid")
 *                 .systemDiskCategory("cloud_efficiency")
 *                 .vswitchId(serverAttachmentSwitch.id())
 *                 .build());
 * }
 *         var serverAttachmentApplicationLoadBalancer = new ApplicationLoadBalancer("serverAttachmentApplicationLoadBalancer", ApplicationLoadBalancerArgs.builder()
 *             .loadBalancerName(slbServerGroupServerAttachment)
 *             .vswitchId(serverAttachmentSwitch.id())
 *             .loadBalancerSpec("slb.s2.small")
 *             .addressType("intranet")
 *             .build());
 *         var serverAttachmentServerGroup = new ServerGroup("serverAttachmentServerGroup", ServerGroupArgs.builder()
 *             .loadBalancerId(serverAttachmentApplicationLoadBalancer.id())
 *             .name(slbServerGroupServerAttachment)
 *             .build());
 *         for (var i = 0; i < slbServerGroupServerAttachmentCount; i++) {
 *             new ServerGroupServerAttachment("serverAttachmentServerGroupServerAttachment-" + i, ServerGroupServerAttachmentArgs.builder()
 *                 .serverGroupId(serverAttachmentServerGroup.id())
 *                 .serverId(serverAttachmentInstance[range&#46;value()].id())
 *                 .port(8080)
 *                 .weight(0)
 *                 .build());
 * }
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Load balancer backend server group server attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/serverGroupServerAttachment:ServerGroupServerAttachment example <server_group_id>:<server_id>:<port>
 * ```
 */
public class ServerGroupServerAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.slb.ServerGroupServerAttachment,
) : KotlinCustomResource(javaResource, ServerGroupServerAttachmentMapper) {
    /**
     * The description of the backend server.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The port that is used by the backend server. Valid values: `1` to `65535`.
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * The ID of the server group.
     */
    public val serverGroupId: Output<String>
        get() = javaResource.serverGroupId().applyValue({ args0 -> args0 })

    /**
     * The ID of the backend server. You can specify the ID of an Elastic Compute Service (ECS) instance or an elastic network interface (ENI).
     */
    public val serverId: Output<String>
        get() = javaResource.serverId().applyValue({ args0 -> args0 })

    /**
     * The type of backend server. Valid values: `ecs`, `eni`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The weight of the backend server. Valid values: `0` to `100`. Default value: `100`. If the value is set to `0`, no requests are forwarded to the backend server.
     */
    public val weight: Output<Int>
        get() = javaResource.weight().applyValue({ args0 -> args0 })
}

public object ServerGroupServerAttachmentMapper : ResourceMapper<ServerGroupServerAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.slb.ServerGroupServerAttachment::class == javaResource::class

    override fun map(javaResource: Resource): ServerGroupServerAttachment =
        ServerGroupServerAttachment(
            javaResource as
                com.pulumi.alicloud.slb.ServerGroupServerAttachment,
        )
}

/**
 * @see [ServerGroupServerAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerGroupServerAttachment].
 */
public suspend fun serverGroupServerAttachment(
    name: String,
    block: suspend ServerGroupServerAttachmentResourceBuilder.() -> Unit,
): ServerGroupServerAttachment {
    val builder = ServerGroupServerAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerGroupServerAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverGroupServerAttachment(name: String): ServerGroupServerAttachment {
    val builder = ServerGroupServerAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
