@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.alicloud.slb.SlbFunctions.getAclsPlain
import com.pulumi.alicloud.slb.SlbFunctions.getApplicationLoadBalancersPlain
import com.pulumi.alicloud.slb.SlbFunctions.getAttachmentsPlain
import com.pulumi.alicloud.slb.SlbFunctions.getBackendServersPlain
import com.pulumi.alicloud.slb.SlbFunctions.getCaCertificatesPlain
import com.pulumi.alicloud.slb.SlbFunctions.getDomainExtensionsPlain
import com.pulumi.alicloud.slb.SlbFunctions.getListenersPlain
import com.pulumi.alicloud.slb.SlbFunctions.getLoadBalancersPlain
import com.pulumi.alicloud.slb.SlbFunctions.getMasterSlaveServerGroupsPlain
import com.pulumi.alicloud.slb.SlbFunctions.getRulesPlain
import com.pulumi.alicloud.slb.SlbFunctions.getServerCertificatesPlain
import com.pulumi.alicloud.slb.SlbFunctions.getServerGroupsPlain
import com.pulumi.alicloud.slb.SlbFunctions.getTlsCipherPoliciesPlain
import com.pulumi.alicloud.slb.SlbFunctions.getZonesPlain
import com.pulumi.alicloud.slb.kotlin.inputs.GetAclsPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetAclsPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetApplicationLoadBalancersPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetApplicationLoadBalancersPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetAttachmentsPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetBackendServersPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetBackendServersPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetCaCertificatesPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetCaCertificatesPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetDomainExtensionsPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetDomainExtensionsPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetListenersPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetListenersPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetLoadBalancersPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetLoadBalancersPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetMasterSlaveServerGroupsPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetMasterSlaveServerGroupsPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetRulesPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetRulesPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetServerCertificatesPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetServerCertificatesPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetServerGroupsPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetServerGroupsPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetTlsCipherPoliciesPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetTlsCipherPoliciesPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.slb.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.slb.kotlin.outputs.GetAclsResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetApplicationLoadBalancersResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetAttachmentsResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetBackendServersResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetCaCertificatesResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetDomainExtensionsResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetListenersResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetLoadBalancersResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetMasterSlaveServerGroupsResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetRulesResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetServerCertificatesResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetServerGroupsResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetTlsCipherPoliciesResult
import com.pulumi.alicloud.slb.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.slb.kotlin.outputs.GetAclsResult.Companion.toKotlin as getAclsResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetApplicationLoadBalancersResult.Companion.toKotlin as getApplicationLoadBalancersResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetAttachmentsResult.Companion.toKotlin as getAttachmentsResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetBackendServersResult.Companion.toKotlin as getBackendServersResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetCaCertificatesResult.Companion.toKotlin as getCaCertificatesResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetDomainExtensionsResult.Companion.toKotlin as getDomainExtensionsResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetListenersResult.Companion.toKotlin as getListenersResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetLoadBalancersResult.Companion.toKotlin as getLoadBalancersResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetMasterSlaveServerGroupsResult.Companion.toKotlin as getMasterSlaveServerGroupsResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetRulesResult.Companion.toKotlin as getRulesResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetServerCertificatesResult.Companion.toKotlin as getServerCertificatesResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetServerGroupsResult.Companion.toKotlin as getServerGroupsResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetTlsCipherPoliciesResult.Companion.toKotlin as getTlsCipherPoliciesResultToKotlin
import com.pulumi.alicloud.slb.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object SlbFunctions {
    /**
     * This data source provides the acls in the region.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const sampleDs = alicloud.slb.getAcls({});
     * export const firstSlbAclId = sampleDs.then(sampleDs => sampleDs.acls?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * sample_ds = alicloud.slb.get_acls()
     * pulumi.export("firstSlbAclId", sample_ds.acls[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var sampleDs = AliCloud.Slb.GetAcls.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSlbAclId"] = sampleDs&#46;Apply(getAclsResult => getAclsResult&#46;Acls[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		sampleDs, err := slb.GetAcls(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstSlbAclId", sampleDs.Acls[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetAclsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var sampleDs = SlbFunctions.getAcls();
     *         ctx.export("firstSlbAclId", sampleDs.applyValue(getAclsResult -> getAclsResult.acls()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   sampleDs:
     *     fn::invoke:
     *       Function: alicloud:slb:getAcls
     *       Arguments: {}
     * outputs:
     *   firstSlbAclId: ${sampleDs.acls[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * ## Entry Block
     * The entry mapping supports the following:
     * * `entry`   - An IP addresses or CIDR blocks.
     * * `comment` - the comment of the entry.
     * ## Listener Block
     * The Listener mapping supports the following:
     * * `load_balancer_id` - the id of load balancer instance, the listener belongs to.
     * * `frontend_port` - the listener port.
     * * `protocol`      - the listener protocol (such as tcp/udp/http/https, etc).
     * * `acl_type`      - the type of acl (such as white/black).
     * @param argument A collection of arguments for invoking getAcls.
     * @return A collection of values returned by getAcls.
     */
    public suspend fun getAcls(argument: GetAclsPlainArgs): GetAclsResult =
        getAclsResultToKotlin(getAclsPlain(argument.toJava()).await())

    /**
     * @see [getAcls].
     * @param ids A list of acls IDs to filter results.
     * @param nameRegex A regex string to filter results by acl name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The Id of resource group which acl belongs.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getAcls.
     */
    public suspend fun getAcls(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        tags: Map<String, String>? = null,
    ): GetAclsResult {
        val argument = GetAclsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            tags = tags,
        )
        return getAclsResultToKotlin(getAclsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAcls].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetAclsPlainArgs].
     * @return A collection of values returned by getAcls.
     */
    public suspend fun getAcls(argument: suspend GetAclsPlainArgsBuilder.() -> Unit): GetAclsResult {
        val builder = GetAclsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAclsResultToKotlin(getAclsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the server load balancers of the current Alibaba Cloud user.
     * > **NOTE:** Available in 1.123.1+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.slb.getApplicationLoadBalancers({
     *     nameRegex: "sample_slb",
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * export const firstSlbId = example.then(example => example.balancers?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.slb.get_application_load_balancers(name_regex="sample_slb",
     *     tags={
     *         "tagKey1": "tagValue1",
     *         "tagKey2": "tagValue2",
     *     })
     * pulumi.export("firstSlbId", example.balancers[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Slb.GetApplicationLoadBalancers.Invoke(new()
     *     {
     *         NameRegex = "sample_slb",
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSlbId"] = example&#46;Apply(getApplicationLoadBalancersResult => getApplicationLoadBalancersResult&#46;Balancers[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := slb.GetApplicationLoadBalancers(ctx, &slb.GetApplicationLoadBalancersArgs{
     * 			NameRegex: pulumi.StringRef("sample_slb"),
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstSlbId", example.Balancers[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetApplicationLoadBalancersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SlbFunctions.getApplicationLoadBalancers(GetApplicationLoadBalancersArgs.builder()
     *             .nameRegex("sample_slb")
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *         ctx.export("firstSlbId", example.applyValue(getApplicationLoadBalancersResult -> getApplicationLoadBalancersResult.balancers()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:slb:getApplicationLoadBalancers
     *       Arguments:
     *         nameRegex: sample_slb
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * outputs:
     *   firstSlbId: ${example.balancers[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApplicationLoadBalancers.
     * @return A collection of values returned by getApplicationLoadBalancers.
     */
    public suspend fun getApplicationLoadBalancers(argument: GetApplicationLoadBalancersPlainArgs): GetApplicationLoadBalancersResult =
        getApplicationLoadBalancersResultToKotlin(getApplicationLoadBalancersPlain(argument.toJava()).await())

    /**
     * @see [getApplicationLoadBalancers].
     * @param address Service address of the SLBs.
     * @param addressIpVersion The address ip version. Valid values `ipv4` and `ipv6`.
     * @param addressType The address type of the SLB. Valid values `internet` and `intranet`.
     * @param enableDetails
     * @param ids A list of SLBs IDs.
     * @param internetChargeType The internet charge type. Valid values `PayByBandwidth` and `PayByTraffic`.
     * @param loadBalancerName The name of the SLB.
     * @param masterZoneId The master zone id of the SLB.
     * @param nameRegex A regex string to filter results by SLB name.
     * @param networkType Network type of the SLBs. Valid values: `vpc` and `classic`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param paymentType The payment type of SLB. Valid values `PayAsYouGo` and `Subscription`.
     * @param resourceGroupId The Id of resource group which SLB belongs.
     * @param serverId The server ID.
     * @param serverIntranetAddress The server intranet address.
     * @param slaveZoneId The slave zone id of the SLB.
     * @param status SLB current status. Possible values: `inactive`, `active` and `locked`.
     * @param tags A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
     * @param vpcId ID of the VPC linked to the SLBs.
     * @param vswitchId ID of the vSwitch linked to the SLBs.
     * @return A collection of values returned by getApplicationLoadBalancers.
     */
    public suspend fun getApplicationLoadBalancers(
        address: String? = null,
        addressIpVersion: String? = null,
        addressType: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        internetChargeType: String? = null,
        loadBalancerName: String? = null,
        masterZoneId: String? = null,
        nameRegex: String? = null,
        networkType: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        paymentType: String? = null,
        resourceGroupId: String? = null,
        serverId: String? = null,
        serverIntranetAddress: String? = null,
        slaveZoneId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
        vswitchId: String? = null,
    ): GetApplicationLoadBalancersResult {
        val argument = GetApplicationLoadBalancersPlainArgs(
            address = address,
            addressIpVersion = addressIpVersion,
            addressType = addressType,
            enableDetails = enableDetails,
            ids = ids,
            internetChargeType = internetChargeType,
            loadBalancerName = loadBalancerName,
            masterZoneId = masterZoneId,
            nameRegex = nameRegex,
            networkType = networkType,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            paymentType = paymentType,
            resourceGroupId = resourceGroupId,
            serverId = serverId,
            serverIntranetAddress = serverIntranetAddress,
            slaveZoneId = slaveZoneId,
            status = status,
            tags = tags,
            vpcId = vpcId,
            vswitchId = vswitchId,
        )
        return getApplicationLoadBalancersResultToKotlin(getApplicationLoadBalancersPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationLoadBalancers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetApplicationLoadBalancersPlainArgs].
     * @return A collection of values returned by getApplicationLoadBalancers.
     */
    public suspend fun getApplicationLoadBalancers(argument: suspend GetApplicationLoadBalancersPlainArgsBuilder.() -> Unit): GetApplicationLoadBalancersResult {
        val builder = GetApplicationLoadBalancersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationLoadBalancersResultToKotlin(getApplicationLoadBalancersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the server load balancer attachments of the current Alibaba Cloud user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const sampleDs = alicloud.slb.getAttachments({
     *     loadBalancerId: sampleSlb.id,
     * });
     * export const firstSlbAttachmentInstanceId = sampleDs.then(sampleDs => sampleDs.slbAttachments?.[0]?.instanceId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * sample_ds = alicloud.slb.get_attachments(load_balancer_id=sample_slb["id"])
     * pulumi.export("firstSlbAttachmentInstanceId", sample_ds.slb_attachments[0].instance_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var sampleDs = AliCloud.Slb.GetAttachments.Invoke(new()
     *     {
     *         LoadBalancerId = sampleSlb.Id,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSlbAttachmentInstanceId"] = sampleDs&#46;Apply(getAttachmentsResult => getAttachmentsResult&#46;SlbAttachments[0]?.InstanceId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		sampleDs, err := slb.GetAttachments(ctx, &slb.GetAttachmentsArgs{
     * 			LoadBalancerId: sampleSlb.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstSlbAttachmentInstanceId", sampleDs.SlbAttachments[0].InstanceId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var sampleDs = SlbFunctions.getAttachments(GetAttachmentsArgs.builder()
     *             .loadBalancerId(sampleSlb.id())
     *             .build());
     *         ctx.export("firstSlbAttachmentInstanceId", sampleDs.applyValue(getAttachmentsResult -> getAttachmentsResult.slbAttachments()[0].instanceId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   sampleDs:
     *     fn::invoke:
     *       Function: alicloud:slb:getAttachments
     *       Arguments:
     *         loadBalancerId: ${sampleSlb.id}
     * outputs:
     *   firstSlbAttachmentInstanceId: ${sampleDs.slbAttachments[0].instanceId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAttachments.
     * @return A collection of values returned by getAttachments.
     */
    public suspend fun getAttachments(argument: GetAttachmentsPlainArgs): GetAttachmentsResult =
        getAttachmentsResultToKotlin(getAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getAttachments].
     * @param instanceIds List of attached ECS instance IDs.
     * @param loadBalancerId ID of the SLB with attachments.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAttachments.
     */
    public suspend fun getAttachments(
        instanceIds: List<String>? = null,
        loadBalancerId: String,
        outputFile: String? = null,
    ): GetAttachmentsResult {
        val argument = GetAttachmentsPlainArgs(
            instanceIds = instanceIds,
            loadBalancerId = loadBalancerId,
            outputFile = outputFile,
        )
        return getAttachmentsResultToKotlin(getAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetAttachmentsPlainArgs].
     * @return A collection of values returned by getAttachments.
     */
    public suspend fun getAttachments(argument: suspend GetAttachmentsPlainArgsBuilder.() -> Unit): GetAttachmentsResult {
        val builder = GetAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAttachmentsResultToKotlin(getAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the server load balancer backend servers related to a server load balancer..
     * > **NOTE:** Available in 1.53.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const sampleDs = alicloud.slb.getBackendServers({
     *     loadBalancerId: sampleSlb.id,
     * });
     * export const firstSlbBackendServerId = sampleDs.then(sampleDs => sampleDs.backendServers?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * sample_ds = alicloud.slb.get_backend_servers(load_balancer_id=sample_slb["id"])
     * pulumi.export("firstSlbBackendServerId", sample_ds.backend_servers[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var sampleDs = AliCloud.Slb.GetBackendServers.Invoke(new()
     *     {
     *         LoadBalancerId = sampleSlb.Id,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSlbBackendServerId"] = sampleDs&#46;Apply(getBackendServersResult => getBackendServersResult&#46;BackendServers[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		sampleDs, err := slb.GetBackendServers(ctx, &slb.GetBackendServersArgs{
     * 			LoadBalancerId: sampleSlb.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstSlbBackendServerId", sampleDs.BackendServers[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetBackendServersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var sampleDs = SlbFunctions.getBackendServers(GetBackendServersArgs.builder()
     *             .loadBalancerId(sampleSlb.id())
     *             .build());
     *         ctx.export("firstSlbBackendServerId", sampleDs.applyValue(getBackendServersResult -> getBackendServersResult.backendServers()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   sampleDs:
     *     fn::invoke:
     *       Function: alicloud:slb:getBackendServers
     *       Arguments:
     *         loadBalancerId: ${sampleSlb.id}
     * outputs:
     *   firstSlbBackendServerId: ${sampleDs.backendServers[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBackendServers.
     * @return A collection of values returned by getBackendServers.
     */
    public suspend fun getBackendServers(argument: GetBackendServersPlainArgs): GetBackendServersResult =
        getBackendServersResultToKotlin(getBackendServersPlain(argument.toJava()).await())

    /**
     * @see [getBackendServers].
     * @param ids List of attached ECS instance IDs.
     * @param loadBalancerId ID of the SLB with attachments.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getBackendServers.
     */
    public suspend fun getBackendServers(
        ids: List<String>? = null,
        loadBalancerId: String,
        outputFile: String? = null,
    ): GetBackendServersResult {
        val argument = GetBackendServersPlainArgs(
            ids = ids,
            loadBalancerId = loadBalancerId,
            outputFile = outputFile,
        )
        return getBackendServersResultToKotlin(getBackendServersPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackendServers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetBackendServersPlainArgs].
     * @return A collection of values returned by getBackendServers.
     */
    public suspend fun getBackendServers(argument: suspend GetBackendServersPlainArgsBuilder.() -> Unit): GetBackendServersResult {
        val builder = GetBackendServersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackendServersResultToKotlin(getBackendServersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the CA certificate list.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const sampleDs = alicloud.slb.getCaCertificates({});
     * export const firstSlbCaCertificateId = sampleDs.then(sampleDs => sampleDs.certificates?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * sample_ds = alicloud.slb.get_ca_certificates()
     * pulumi.export("firstSlbCaCertificateId", sample_ds.certificates[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var sampleDs = AliCloud.Slb.GetCaCertificates.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSlbCaCertificateId"] = sampleDs&#46;Apply(getCaCertificatesResult => getCaCertificatesResult&#46;Certificates[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		sampleDs, err := slb.GetCaCertificates(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstSlbCaCertificateId", sampleDs.Certificates[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetCaCertificatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var sampleDs = SlbFunctions.getCaCertificates();
     *         ctx.export("firstSlbCaCertificateId", sampleDs.applyValue(getCaCertificatesResult -> getCaCertificatesResult.certificates()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   sampleDs:
     *     fn::invoke:
     *       Function: alicloud:slb:getCaCertificates
     *       Arguments: {}
     * outputs:
     *   firstSlbCaCertificateId: ${sampleDs.certificates[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCaCertificates.
     * @return A collection of values returned by getCaCertificates.
     */
    public suspend fun getCaCertificates(argument: GetCaCertificatesPlainArgs): GetCaCertificatesResult =
        getCaCertificatesResultToKotlin(getCaCertificatesPlain(argument.toJava()).await())

    /**
     * @see [getCaCertificates].
     * @param ids A list of ca certificates IDs to filter results.
     * @param nameRegex A regex string to filter results by ca certificate name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The Id of resource group which ca certificates belongs.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getCaCertificates.
     */
    public suspend fun getCaCertificates(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        tags: Map<String, String>? = null,
    ): GetCaCertificatesResult {
        val argument = GetCaCertificatesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            tags = tags,
        )
        return getCaCertificatesResultToKotlin(getCaCertificatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getCaCertificates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetCaCertificatesPlainArgs].
     * @return A collection of values returned by getCaCertificates.
     */
    public suspend fun getCaCertificates(argument: suspend GetCaCertificatesPlainArgsBuilder.() -> Unit): GetCaCertificatesResult {
        val builder = GetCaCertificatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCaCertificatesResultToKotlin(getCaCertificatesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the domain extensions associated with a server load balancer listener.
     * > **NOTE:** Available in 1.60.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const foo = alicloud.slb.getDomainExtensions({
     *     ids: ["fake-de-id"],
     *     loadBalancerId: "fake-lb-id",
     *     frontendPort: "fake-port",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * foo = alicloud.slb.get_domain_extensions(ids=["fake-de-id"],
     *     load_balancer_id="fake-lb-id",
     *     frontend_port="fake-port")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = AliCloud.Slb.GetDomainExtensions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "fake-de-id",
     *         },
     *         LoadBalancerId = "fake-lb-id",
     *         FrontendPort = "fake-port",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := slb.GetDomainExtensions(ctx, &slb.GetDomainExtensionsArgs{
     * 			Ids: []string{
     * 				"fake-de-id",
     * 			},
     * 			LoadBalancerId: "fake-lb-id",
     * 			FrontendPort:   "fake-port",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetDomainExtensionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = SlbFunctions.getDomainExtensions(GetDomainExtensionsArgs.builder()
     *             .ids("fake-de-id")
     *             .loadBalancerId("fake-lb-id")
     *             .frontendPort("fake-port")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: alicloud:slb:getDomainExtensions
     *       Arguments:
     *         ids:
     *           - fake-de-id
     *         loadBalancerId: fake-lb-id
     *         frontendPort: fake-port
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomainExtensions.
     * @return A collection of values returned by getDomainExtensions.
     */
    public suspend fun getDomainExtensions(argument: GetDomainExtensionsPlainArgs): GetDomainExtensionsResult =
        getDomainExtensionsResultToKotlin(getDomainExtensionsPlain(argument.toJava()).await())

    /**
     * @see [getDomainExtensions].
     * @param frontendPort The frontend port used by the HTTPS listener of the SLB instance. Valid values: 1–65535.
     * @param ids IDs of the SLB domain extensions.
     * @param loadBalancerId The ID of the SLB instance.
     * @param outputFile
     * @return A collection of values returned by getDomainExtensions.
     */
    public suspend fun getDomainExtensions(
        frontendPort: Int,
        ids: List<String>? = null,
        loadBalancerId: String,
        outputFile: String? = null,
    ): GetDomainExtensionsResult {
        val argument = GetDomainExtensionsPlainArgs(
            frontendPort = frontendPort,
            ids = ids,
            loadBalancerId = loadBalancerId,
            outputFile = outputFile,
        )
        return getDomainExtensionsResultToKotlin(getDomainExtensionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainExtensions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetDomainExtensionsPlainArgs].
     * @return A collection of values returned by getDomainExtensions.
     */
    public suspend fun getDomainExtensions(argument: suspend GetDomainExtensionsPlainArgsBuilder.() -> Unit): GetDomainExtensionsResult {
        val builder = GetDomainExtensionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainExtensionsResultToKotlin(getDomainExtensionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the listeners related to a server load balancer of the current Alibaba Cloud user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const _default = new alicloud.slb.ApplicationLoadBalancer("default", {loadBalancerName: "tf-testAccSlbListenertcp"});
     * const tcp = new alicloud.slb.Listener("tcp", {
     *     loadBalancerId: _default.id,
     *     backendPort: 22,
     *     frontendPort: 22,
     *     protocol: "tcp",
     *     bandwidth: 10,
     *     healthCheckType: "tcp",
     *     persistenceTimeout: 3600,
     *     healthyThreshold: 8,
     *     unhealthyThreshold: 8,
     *     healthCheckTimeout: 8,
     *     healthCheckInterval: 5,
     *     healthCheckHttpCode: "http_2xx",
     *     healthCheckConnectPort: 20,
     *     healthCheckUri: "/console",
     *     establishedTimeout: 600,
     * });
     * const sampleDs = alicloud.slb.getListenersOutput({
     *     loadBalancerId: _default.id,
     * });
     * export const firstSlbListenerProtocol = sampleDs.apply(sampleDs => sampleDs.slbListeners?.[0]?.protocol);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.slb.ApplicationLoadBalancer("default", load_balancer_name="tf-testAccSlbListenertcp")
     * tcp = alicloud.slb.Listener("tcp",
     *     load_balancer_id=default.id,
     *     backend_port=22,
     *     frontend_port=22,
     *     protocol="tcp",
     *     bandwidth=10,
     *     health_check_type="tcp",
     *     persistence_timeout=3600,
     *     healthy_threshold=8,
     *     unhealthy_threshold=8,
     *     health_check_timeout=8,
     *     health_check_interval=5,
     *     health_check_http_code="http_2xx",
     *     health_check_connect_port=20,
     *     health_check_uri="/console",
     *     established_timeout=600)
     * sample_ds = alicloud.slb.get_listeners_output(load_balancer_id=default.id)
     * pulumi.export("firstSlbListenerProtocol", sample_ds.slb_listeners[0].protocol)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = new AliCloud.Slb.ApplicationLoadBalancer("default", new()
     *     {
     *         LoadBalancerName = "tf-testAccSlbListenertcp",
     *     });
     *     var tcp = new AliCloud.Slb.Listener("tcp", new()
     *     {
     *         LoadBalancerId = @default.Id,
     *         BackendPort = 22,
     *         FrontendPort = 22,
     *         Protocol = "tcp",
     *         Bandwidth = 10,
     *         HealthCheckType = "tcp",
     *         PersistenceTimeout = 3600,
     *         HealthyThreshold = 8,
     *         UnhealthyThreshold = 8,
     *         HealthCheckTimeout = 8,
     *         HealthCheckInterval = 5,
     *         HealthCheckHttpCode = "http_2xx",
     *         HealthCheckConnectPort = 20,
     *         HealthCheckUri = "/console",
     *         EstablishedTimeout = 600,
     *     });
     *     var sampleDs = AliCloud.Slb.GetListeners.Invoke(new()
     *     {
     *         LoadBalancerId = @default.Id,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSlbListenerProtocol"] = sampleDs&#46;Apply(getListenersResult => getListenersResult&#46;SlbListeners[0]?.Protocol),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := slb.NewApplicationLoadBalancer(ctx, "default", &slb.ApplicationLoadBalancerArgs{
     * 			LoadBalancerName: pulumi.String("tf-testAccSlbListenertcp"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = slb.NewListener(ctx, "tcp", &slb.ListenerArgs{
     * 			LoadBalancerId:         _default.ID(),
     * 			BackendPort:            pulumi.Int(22),
     * 			FrontendPort:           pulumi.Int(22),
     * 			Protocol:               pulumi.String("tcp"),
     * 			Bandwidth:              pulumi.Int(10),
     * 			HealthCheckType:        pulumi.String("tcp"),
     * 			PersistenceTimeout:     pulumi.Int(3600),
     * 			HealthyThreshold:       pulumi.Int(8),
     * 			UnhealthyThreshold:     pulumi.Int(8),
     * 			HealthCheckTimeout:     pulumi.Int(8),
     * 			HealthCheckInterval:    pulumi.Int(5),
     * 			HealthCheckHttpCode:    pulumi.String("http_2xx"),
     * 			HealthCheckConnectPort: pulumi.Int(20),
     * 			HealthCheckUri:         pulumi.String("/console"),
     * 			EstablishedTimeout:     pulumi.Int(600),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		sampleDs := slb.GetListenersOutput(ctx, slb.GetListenersOutputArgs{
     * 			LoadBalancerId: _default.ID(),
     * 		}, nil)
     * 		ctx.Export("firstSlbListenerProtocol", sampleDs.ApplyT(func(sampleDs slb.GetListenersResult) (*string, error) {
     * 			return &sampleDs.SlbListeners[0].Protocol, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.ApplicationLoadBalancer;
     * import com.pulumi.alicloud.slb.ApplicationLoadBalancerArgs;
     * import com.pulumi.alicloud.slb.Listener;
     * import com.pulumi.alicloud.slb.ListenerArgs;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetListenersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var default_ = new ApplicationLoadBalancer("default", ApplicationLoadBalancerArgs.builder()
     *             .loadBalancerName("tf-testAccSlbListenertcp")
     *             .build());
     *         var tcp = new Listener("tcp", ListenerArgs.builder()
     *             .loadBalancerId(default_.id())
     *             .backendPort("22")
     *             .frontendPort("22")
     *             .protocol("tcp")
     *             .bandwidth("10")
     *             .healthCheckType("tcp")
     *             .persistenceTimeout(3600)
     *             .healthyThreshold(8)
     *             .unhealthyThreshold(8)
     *             .healthCheckTimeout(8)
     *             .healthCheckInterval(5)
     *             .healthCheckHttpCode("http_2xx")
     *             .healthCheckConnectPort(20)
     *             .healthCheckUri("/console")
     *             .establishedTimeout(600)
     *             .build());
     *         final var sampleDs = SlbFunctions.getListeners(GetListenersArgs.builder()
     *             .loadBalancerId(default_.id())
     *             .build());
     *         ctx.export("firstSlbListenerProtocol", sampleDs.applyValue(getListenersResult -> getListenersResult).applyValue(sampleDs -> sampleDs.applyValue(getListenersResult -> getListenersResult.slbListeners()[0].protocol())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   default:
     *     type: alicloud:slb:ApplicationLoadBalancer
     *     properties:
     *       loadBalancerName: tf-testAccSlbListenertcp
     *   tcp:
     *     type: alicloud:slb:Listener
     *     properties:
     *       loadBalancerId: ${default.id}
     *       backendPort: '22'
     *       frontendPort: '22'
     *       protocol: tcp
     *       bandwidth: '10'
     *       healthCheckType: tcp
     *       persistenceTimeout: 3600
     *       healthyThreshold: 8
     *       unhealthyThreshold: 8
     *       healthCheckTimeout: 8
     *       healthCheckInterval: 5
     *       healthCheckHttpCode: http_2xx
     *       healthCheckConnectPort: 20
     *       healthCheckUri: /console
     *       establishedTimeout: 600
     * variables:
     *   sampleDs:
     *     fn::invoke:
     *       Function: alicloud:slb:getListeners
     *       Arguments:
     *         loadBalancerId: ${default.id}
     * outputs:
     *   firstSlbListenerProtocol: ${sampleDs.slbListeners[0].protocol}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getListeners.
     * @return A collection of values returned by getListeners.
     */
    public suspend fun getListeners(argument: GetListenersPlainArgs): GetListenersResult =
        getListenersResultToKotlin(getListenersPlain(argument.toJava()).await())

    /**
     * @see [getListeners].
     * @param descriptionRegex A regex string to filter results by SLB listener description.
     * @param frontendPort Filter listeners by the specified frontend port.
     * @param loadBalancerId ID of the SLB with listeners.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param protocol Filter listeners by the specified protocol. Valid values: `http`, `https`, `tcp` and `udp`.
     * @return A collection of values returned by getListeners.
     */
    public suspend fun getListeners(
        descriptionRegex: String? = null,
        frontendPort: Int? = null,
        loadBalancerId: String,
        outputFile: String? = null,
        protocol: String? = null,
    ): GetListenersResult {
        val argument = GetListenersPlainArgs(
            descriptionRegex = descriptionRegex,
            frontendPort = frontendPort,
            loadBalancerId = loadBalancerId,
            outputFile = outputFile,
            protocol = protocol,
        )
        return getListenersResultToKotlin(getListenersPlain(argument.toJava()).await())
    }

    /**
     * @see [getListeners].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetListenersPlainArgs].
     * @return A collection of values returned by getListeners.
     */
    public suspend fun getListeners(argument: suspend GetListenersPlainArgsBuilder.() -> Unit): GetListenersResult {
        val builder = GetListenersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getListenersResultToKotlin(getListenersPlain(builtArgument.toJava()).await())
    }

    /**
     * > **DEPRECATED:** This datasource has been renamed to alicloud.slb.getApplicationLoadBalancers from version 1.123.1.
     * This data source provides the server load balancers of the current Alibaba Cloud user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const _default = new alicloud.slb.LoadBalancer("default", {name: "sample_slb"});
     * const slbsDs = alicloud.slb.getLoadBalancers({
     *     nameRegex: "sample_slb",
     * });
     * export const firstSlbId = slbsDs.then(slbsDs => slbsDs.slbs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.slb.LoadBalancer("default", name="sample_slb")
     * slbs_ds = alicloud.slb.get_load_balancers(name_regex="sample_slb")
     * pulumi.export("firstSlbId", slbs_ds.slbs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = new AliCloud.Slb.LoadBalancer("default", new()
     *     {
     *         Name = "sample_slb",
     *     });
     *     var slbsDs = AliCloud.Slb.GetLoadBalancers.Invoke(new()
     *     {
     *         NameRegex = "sample_slb",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSlbId"] = slbsDs&#46;Apply(getLoadBalancersResult => getLoadBalancersResult&#46;Slbs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := slb.NewLoadBalancer(ctx, "default", &slb.LoadBalancerArgs{
     * 			Name: pulumi.String("sample_slb"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		slbsDs, err := slb.GetLoadBalancers(ctx, &slb.GetLoadBalancersArgs{
     * 			NameRegex: pulumi.StringRef("sample_slb"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstSlbId", slbsDs.Slbs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.LoadBalancer;
     * import com.pulumi.alicloud.slb.LoadBalancerArgs;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetLoadBalancersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var default_ = new LoadBalancer("default", LoadBalancerArgs.builder()
     *             .name("sample_slb")
     *             .build());
     *         final var slbsDs = SlbFunctions.getLoadBalancers(GetLoadBalancersArgs.builder()
     *             .nameRegex("sample_slb")
     *             .build());
     *         ctx.export("firstSlbId", slbsDs.applyValue(getLoadBalancersResult -> getLoadBalancersResult.slbs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   default:
     *     type: alicloud:slb:LoadBalancer
     *     properties:
     *       name: sample_slb
     * variables:
     *   slbsDs:
     *     fn::invoke:
     *       Function: alicloud:slb:getLoadBalancers
     *       Arguments:
     *         nameRegex: sample_slb
     * outputs:
     *   firstSlbId: ${slbsDs.slbs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLoadBalancers.
     * @return A collection of values returned by getLoadBalancers.
     */
    public suspend fun getLoadBalancers(argument: GetLoadBalancersPlainArgs): GetLoadBalancersResult =
        getLoadBalancersResultToKotlin(getLoadBalancersPlain(argument.toJava()).await())

    /**
     * @see [getLoadBalancers].
     * @param address Service address of the SLBs.
     * @param addressIpVersion
     * @param addressType
     * @param enableDetails
     * @param ids A list of SLBs IDs.
     * @param internetChargeType
     * @param loadBalancerName
     * @param masterZoneId
     * @param nameRegex A regex string to filter results by SLB name.
     * @param networkType Network type of the SLBs. Valid values: `vpc` and `classic`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param paymentType
     * @param resourceGroupId The Id of resource group which SLB belongs.
     * @param serverId
     * @param serverIntranetAddress
     * @param slaveZoneId
     * @param status SLB current status. Possible values: `inactive`, `active` and `locked`.
     * @param tags A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const taggedInstances = alicloud.slb.getLoadBalancers({
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * tagged_instances = alicloud.slb.get_load_balancers(tags={
     *     "tagKey1": "tagValue1",
     *     "tagKey2": "tagValue2",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var taggedInstances = AliCloud.Slb.GetLoadBalancers.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := slb.GetLoadBalancers(ctx, &slb.GetLoadBalancersArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetLoadBalancersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var taggedInstances = SlbFunctions.getLoadBalancers(GetLoadBalancersArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   taggedInstances:
     *     fn::invoke:
     *       Function: alicloud:slb:getLoadBalancers
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * ```
     * <!--End PulumiCodeChooser -->
     * @param vpcId ID of the VPC linked to the SLBs.
     * @param vswitchId ID of the vSwitch linked to the SLBs.
     * @return A collection of values returned by getLoadBalancers.
     */
    public suspend fun getLoadBalancers(
        address: String? = null,
        addressIpVersion: String? = null,
        addressType: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        internetChargeType: String? = null,
        loadBalancerName: String? = null,
        masterZoneId: String? = null,
        nameRegex: String? = null,
        networkType: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        paymentType: String? = null,
        resourceGroupId: String? = null,
        serverId: String? = null,
        serverIntranetAddress: String? = null,
        slaveZoneId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
        vswitchId: String? = null,
    ): GetLoadBalancersResult {
        val argument = GetLoadBalancersPlainArgs(
            address = address,
            addressIpVersion = addressIpVersion,
            addressType = addressType,
            enableDetails = enableDetails,
            ids = ids,
            internetChargeType = internetChargeType,
            loadBalancerName = loadBalancerName,
            masterZoneId = masterZoneId,
            nameRegex = nameRegex,
            networkType = networkType,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            paymentType = paymentType,
            resourceGroupId = resourceGroupId,
            serverId = serverId,
            serverIntranetAddress = serverIntranetAddress,
            slaveZoneId = slaveZoneId,
            status = status,
            tags = tags,
            vpcId = vpcId,
            vswitchId = vswitchId,
        )
        return getLoadBalancersResultToKotlin(getLoadBalancersPlain(argument.toJava()).await())
    }

    /**
     * @see [getLoadBalancers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetLoadBalancersPlainArgs].
     * @return A collection of values returned by getLoadBalancers.
     */
    public suspend fun getLoadBalancers(argument: suspend GetLoadBalancersPlainArgsBuilder.() -> Unit): GetLoadBalancersResult {
        val builder = GetLoadBalancersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLoadBalancersResultToKotlin(getLoadBalancersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the master slave server groups related to a server load balancer.
     * > **NOTE:** Available in 1.54.0+
     * @param argument A collection of arguments for invoking getMasterSlaveServerGroups.
     * @return A collection of values returned by getMasterSlaveServerGroups.
     */
    public suspend fun getMasterSlaveServerGroups(argument: GetMasterSlaveServerGroupsPlainArgs): GetMasterSlaveServerGroupsResult =
        getMasterSlaveServerGroupsResultToKotlin(getMasterSlaveServerGroupsPlain(argument.toJava()).await())

    /**
     * @see [getMasterSlaveServerGroups].
     * @param ids A list of master slave server group IDs to filter results.
     * @param loadBalancerId ID of the SLB.
     * @param nameRegex A regex string to filter results by master slave server group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getMasterSlaveServerGroups.
     */
    public suspend fun getMasterSlaveServerGroups(
        ids: List<String>? = null,
        loadBalancerId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetMasterSlaveServerGroupsResult {
        val argument = GetMasterSlaveServerGroupsPlainArgs(
            ids = ids,
            loadBalancerId = loadBalancerId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getMasterSlaveServerGroupsResultToKotlin(getMasterSlaveServerGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getMasterSlaveServerGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetMasterSlaveServerGroupsPlainArgs].
     * @return A collection of values returned by getMasterSlaveServerGroups.
     */
    public suspend fun getMasterSlaveServerGroups(argument: suspend GetMasterSlaveServerGroupsPlainArgsBuilder.() -> Unit): GetMasterSlaveServerGroupsResult {
        val builder = GetMasterSlaveServerGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMasterSlaveServerGroupsResultToKotlin(getMasterSlaveServerGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the rules associated with a server load balancer listener.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "slbrulebasicconfig";
     * const default = alicloud.getZones({
     *     availableDiskCategory: "cloud_efficiency",
     *     availableResourceCreation: "VSwitch",
     * });
     * const defaultNetwork = new alicloud.vpc.Network("default", {
     *     name: name,
     *     cidrBlock: "172.16.0.0/16",
     * });
     * const defaultSwitch = new alicloud.vpc.Switch("default", {
     *     vpcId: defaultNetwork.id,
     *     cidrBlock: "172.16.0.0/16",
     *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
     *     vswitchName: name,
     * });
     * const defaultApplicationLoadBalancer = new alicloud.slb.ApplicationLoadBalancer("default", {
     *     loadBalancerName: name,
     *     vswitchId: defaultSwitch.id,
     * });
     * const defaultListener = new alicloud.slb.Listener("default", {
     *     loadBalancerId: defaultApplicationLoadBalancer.id,
     *     backendPort: 22,
     *     frontendPort: 22,
     *     protocol: "http",
     *     bandwidth: 5,
     *     healthCheckConnectPort: 20,
     * });
     * const defaultServerGroup = new alicloud.slb.ServerGroup("default", {loadBalancerId: defaultApplicationLoadBalancer.id});
     * const defaultRule = new alicloud.slb.Rule("default", {
     *     loadBalancerId: defaultApplicationLoadBalancer.id,
     *     frontendPort: defaultListener.frontendPort,
     *     name: name,
     *     domain: "*.aliyun.com",
     *     url: "/image",
     *     serverGroupId: defaultServerGroup.id,
     * });
     * const sampleDs = defaultApplicationLoadBalancer.id.apply(id => alicloud.slb.getRulesOutput({
     *     loadBalancerId: id,
     *     frontendPort: 22,
     * }));
     * export const firstSlbRuleId = sampleDs.apply(sampleDs => sampleDs.slbRules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "slbrulebasicconfig"
     * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
     *     available_resource_creation="VSwitch")
     * default_network = alicloud.vpc.Network("default",
     *     name=name,
     *     cidr_block="172.16.0.0/16")
     * default_switch = alicloud.vpc.Switch("default",
     *     vpc_id=default_network.id,
     *     cidr_block="172.16.0.0/16",
     *     zone_id=default.zones[0].id,
     *     vswitch_name=name)
     * default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("default",
     *     load_balancer_name=name,
     *     vswitch_id=default_switch.id)
     * default_listener = alicloud.slb.Listener("default",
     *     load_balancer_id=default_application_load_balancer.id,
     *     backend_port=22,
     *     frontend_port=22,
     *     protocol="http",
     *     bandwidth=5,
     *     health_check_connect_port=20)
     * default_server_group = alicloud.slb.ServerGroup("default", load_balancer_id=default_application_load_balancer.id)
     * default_rule = alicloud.slb.Rule("default",
     *     load_balancer_id=default_application_load_balancer.id,
     *     frontend_port=default_listener.frontend_port,
     *     name=name,
     *     domain="*.aliyun.com",
     *     url="/image",
     *     server_group_id=default_server_group.id)
     * sample_ds = default_application_load_balancer.id.apply(lambda id: alicloud.slb.get_rules_output(load_balancer_id=id,
     *     frontend_port=22))
     * pulumi.export("firstSlbRuleId", sample_ds.slb_rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "slbrulebasicconfig";
     *     var @default = AliCloud.GetZones.Invoke(new()
     *     {
     *         AvailableDiskCategory = "cloud_efficiency",
     *         AvailableResourceCreation = "VSwitch",
     *     });
     *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
     *     {
     *         Name = name,
     *         CidrBlock = "172.16.0.0/16",
     *     });
     *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
     *     {
     *         VpcId = defaultNetwork.Id,
     *         CidrBlock = "172.16.0.0/16",
     *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
     *         VswitchName = name,
     *     });
     *     var defaultApplicationLoadBalancer = new AliCloud.Slb.ApplicationLoadBalancer("default", new()
     *     {
     *         LoadBalancerName = name,
     *         VswitchId = defaultSwitch.Id,
     *     });
     *     var defaultListener = new AliCloud.Slb.Listener("default", new()
     *     {
     *         LoadBalancerId = defaultApplicationLoadBalancer.Id,
     *         BackendPort = 22,
     *         FrontendPort = 22,
     *         Protocol = "http",
     *         Bandwidth = 5,
     *         HealthCheckConnectPort = 20,
     *     });
     *     var defaultServerGroup = new AliCloud.Slb.ServerGroup("default", new()
     *     {
     *         LoadBalancerId = defaultApplicationLoadBalancer.Id,
     *     });
     *     var defaultRule = new AliCloud.Slb.Rule("default", new()
     *     {
     *         LoadBalancerId = defaultApplicationLoadBalancer.Id,
     *         FrontendPort = defaultListener.FrontendPort,
     *         Name = name,
     *         Domain = "*.aliyun.com",
     *         Url = "/image",
     *         ServerGroupId = defaultServerGroup.Id,
     *     });
     *     var sampleDs = AliCloud.Slb.GetRules.Invoke(new()
     *     {
     *         LoadBalancerId = defaultApplicationLoadBalancer.Id,
     *         FrontendPort = 22,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSlbRuleId"] = sampleDs&#46;Apply(getRulesResult => getRulesResult&#46;SlbRules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "slbrulebasicconfig"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
     * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
     * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
     * 			Name:      pulumi.String(name),
     * 			CidrBlock: pulumi.String("172.16.0.0/16"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
     * 			VpcId:       defaultNetwork.ID(),
     * 			CidrBlock:   pulumi.String("172.16.0.0/16"),
     * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
     * 			VswitchName: pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultApplicationLoadBalancer, err := slb.NewApplicationLoadBalancer(ctx, "default", &slb.ApplicationLoadBalancerArgs{
     * 			LoadBalancerName: pulumi.String(name),
     * 			VswitchId:        defaultSwitch.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultListener, err := slb.NewListener(ctx, "default", &slb.ListenerArgs{
     * 			LoadBalancerId:         defaultApplicationLoadBalancer.ID(),
     * 			BackendPort:            pulumi.Int(22),
     * 			FrontendPort:           pulumi.Int(22),
     * 			Protocol:               pulumi.String("http"),
     * 			Bandwidth:              pulumi.Int(5),
     * 			HealthCheckConnectPort: pulumi.Int(20),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultServerGroup, err := slb.NewServerGroup(ctx, "default", &slb.ServerGroupArgs{
     * 			LoadBalancerId: defaultApplicationLoadBalancer.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = slb.NewRule(ctx, "default", &slb.RuleArgs{
     * 			LoadBalancerId: defaultApplicationLoadBalancer.ID(),
     * 			FrontendPort:   defaultListener.FrontendPort,
     * 			Name:           pulumi.String(name),
     * 			Domain:         pulumi.String("*.aliyun.com"),
     * 			Url:            pulumi.String("/image"),
     * 			ServerGroupId:  defaultServerGroup.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		sampleDs := defaultApplicationLoadBalancer.ID().ApplyT(func(id string) (slb.GetRulesResult, error) {
     * 			return slb.GetRulesResult(interface{}(slb.GetRulesOutput(ctx, slb.GetRulesOutputArgs{
     * 				LoadBalancerId: id,
     * 				FrontendPort:   22,
     * 			}, nil))), nil
     * 		}).(slb.GetRulesResultOutput)
     * 		ctx.Export("firstSlbRuleId", sampleDs.ApplyT(func(sampleDs slb.GetRulesResult) (*string, error) {
     * 			return &sampleDs.SlbRules[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.slb.ApplicationLoadBalancer;
     * import com.pulumi.alicloud.slb.ApplicationLoadBalancerArgs;
     * import com.pulumi.alicloud.slb.Listener;
     * import com.pulumi.alicloud.slb.ListenerArgs;
     * import com.pulumi.alicloud.slb.ServerGroup;
     * import com.pulumi.alicloud.slb.ServerGroupArgs;
     * import com.pulumi.alicloud.slb.Rule;
     * import com.pulumi.alicloud.slb.RuleArgs;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("slbrulebasicconfig");
     *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
     *             .availableDiskCategory("cloud_efficiency")
     *             .availableResourceCreation("VSwitch")
     *             .build());
     *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
     *             .name(name)
     *             .cidrBlock("172.16.0.0/16")
     *             .build());
     *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
     *             .vpcId(defaultNetwork.id())
     *             .cidrBlock("172.16.0.0/16")
     *             .zoneId(default_.zones()[0].id())
     *             .vswitchName(name)
     *             .build());
     *         var defaultApplicationLoadBalancer = new ApplicationLoadBalancer("defaultApplicationLoadBalancer", ApplicationLoadBalancerArgs.builder()
     *             .loadBalancerName(name)
     *             .vswitchId(defaultSwitch.id())
     *             .build());
     *         var defaultListener = new Listener("defaultListener", ListenerArgs.builder()
     *             .loadBalancerId(defaultApplicationLoadBalancer.id())
     *             .backendPort(22)
     *             .frontendPort(22)
     *             .protocol("http")
     *             .bandwidth(5)
     *             .healthCheckConnectPort("20")
     *             .build());
     *         var defaultServerGroup = new ServerGroup("defaultServerGroup", ServerGroupArgs.builder()
     *             .loadBalancerId(defaultApplicationLoadBalancer.id())
     *             .build());
     *         var defaultRule = new Rule("defaultRule", RuleArgs.builder()
     *             .loadBalancerId(defaultApplicationLoadBalancer.id())
     *             .frontendPort(defaultListener.frontendPort())
     *             .name(name)
     *             .domain("*.aliyun.com")
     *             .url("/image")
     *             .serverGroupId(defaultServerGroup.id())
     *             .build());
     *         final var sampleDs = SlbFunctions.getRules(GetRulesArgs.builder()
     *             .loadBalancerId(defaultApplicationLoadBalancer.id())
     *             .frontendPort(22)
     *             .build());
     *         ctx.export("firstSlbRuleId", sampleDs.applyValue(getRulesResult -> getRulesResult).applyValue(sampleDs -> sampleDs.applyValue(getRulesResult -> getRulesResult.slbRules()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: slbrulebasicconfig
     * resources:
     *   defaultNetwork:
     *     type: alicloud:vpc:Network
     *     name: default
     *     properties:
     *       name: ${name}
     *       cidrBlock: 172.16.0.0/16
     *   defaultSwitch:
     *     type: alicloud:vpc:Switch
     *     name: default
     *     properties:
     *       vpcId: ${defaultNetwork.id}
     *       cidrBlock: 172.16.0.0/16
     *       zoneId: ${default.zones[0].id}
     *       vswitchName: ${name}
     *   defaultApplicationLoadBalancer:
     *     type: alicloud:slb:ApplicationLoadBalancer
     *     name: default
     *     properties:
     *       loadBalancerName: ${name}
     *       vswitchId: ${defaultSwitch.id}
     *   defaultListener:
     *     type: alicloud:slb:Listener
     *     name: default
     *     properties:
     *       loadBalancerId: ${defaultApplicationLoadBalancer.id}
     *       backendPort: 22
     *       frontendPort: 22
     *       protocol: http
     *       bandwidth: 5
     *       healthCheckConnectPort: '20'
     *   defaultServerGroup:
     *     type: alicloud:slb:ServerGroup
     *     name: default
     *     properties:
     *       loadBalancerId: ${defaultApplicationLoadBalancer.id}
     *   defaultRule:
     *     type: alicloud:slb:Rule
     *     name: default
     *     properties:
     *       loadBalancerId: ${defaultApplicationLoadBalancer.id}
     *       frontendPort: ${defaultListener.frontendPort}
     *       name: ${name}
     *       domain: '*.aliyun.com'
     *       url: /image
     *       serverGroupId: ${defaultServerGroup.id}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments:
     *         availableDiskCategory: cloud_efficiency
     *         availableResourceCreation: VSwitch
     *   sampleDs:
     *     fn::invoke:
     *       Function: alicloud:slb:getRules
     *       Arguments:
     *         loadBalancerId: ${defaultApplicationLoadBalancer.id}
     *         frontendPort: 22
     * outputs:
     *   firstSlbRuleId: ${sampleDs.slbRules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRules.
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(argument: GetRulesPlainArgs): GetRulesResult =
        getRulesResultToKotlin(getRulesPlain(argument.toJava()).await())

    /**
     * @see [getRules].
     * @param frontendPort SLB listener port.
     * @param ids A list of rules IDs to filter results.
     * @param loadBalancerId ID of the SLB with listener rules.
     * @param nameRegex A regex string to filter results by rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(
        frontendPort: Int,
        ids: List<String>? = null,
        loadBalancerId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetRulesResult {
        val argument = GetRulesPlainArgs(
            frontendPort = frontendPort,
            ids = ids,
            loadBalancerId = loadBalancerId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getRulesResultToKotlin(getRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetRulesPlainArgs].
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(argument: suspend GetRulesPlainArgsBuilder.() -> Unit): GetRulesResult {
        val builder = GetRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRulesResultToKotlin(getRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the server certificate list.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const sampleDs = alicloud.slb.getServerCertificates({});
     * export const firstSlbServerCertificateId = sampleDs.then(sampleDs => sampleDs.certificates?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * sample_ds = alicloud.slb.get_server_certificates()
     * pulumi.export("firstSlbServerCertificateId", sample_ds.certificates[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var sampleDs = AliCloud.Slb.GetServerCertificates.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSlbServerCertificateId"] = sampleDs&#46;Apply(getServerCertificatesResult => getServerCertificatesResult&#46;Certificates[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		sampleDs, err := slb.GetServerCertificates(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstSlbServerCertificateId", sampleDs.Certificates[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetServerCertificatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var sampleDs = SlbFunctions.getServerCertificates();
     *         ctx.export("firstSlbServerCertificateId", sampleDs.applyValue(getServerCertificatesResult -> getServerCertificatesResult.certificates()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   sampleDs:
     *     fn::invoke:
     *       Function: alicloud:slb:getServerCertificates
     *       Arguments: {}
     * outputs:
     *   firstSlbServerCertificateId: ${sampleDs.certificates[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerCertificates.
     * @return A collection of values returned by getServerCertificates.
     */
    public suspend fun getServerCertificates(argument: GetServerCertificatesPlainArgs): GetServerCertificatesResult =
        getServerCertificatesResultToKotlin(getServerCertificatesPlain(argument.toJava()).await())

    /**
     * @see [getServerCertificates].
     * @param ids A list of server certificates IDs to filter results.
     * @param nameRegex A regex string to filter results by server certificate name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The Id of resource group which the slb server certificates belongs.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getServerCertificates.
     */
    public suspend fun getServerCertificates(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        tags: Map<String, String>? = null,
    ): GetServerCertificatesResult {
        val argument = GetServerCertificatesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            tags = tags,
        )
        return getServerCertificatesResultToKotlin(getServerCertificatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerCertificates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetServerCertificatesPlainArgs].
     * @return A collection of values returned by getServerCertificates.
     */
    public suspend fun getServerCertificates(argument: suspend GetServerCertificatesPlainArgsBuilder.() -> Unit): GetServerCertificatesResult {
        val builder = GetServerCertificatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerCertificatesResultToKotlin(getServerCertificatesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the VServer groups related to a server load balancer.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "slbservergroups";
     * const default = alicloud.getZones({
     *     availableDiskCategory: "cloud_efficiency",
     *     availableResourceCreation: "VSwitch",
     * });
     * const defaultNetwork = new alicloud.vpc.Network("default", {
     *     vpcName: name,
     *     cidrBlock: "172.16.0.0/16",
     * });
     * const defaultSwitch = new alicloud.vpc.Switch("default", {
     *     vpcId: defaultNetwork.id,
     *     cidrBlock: "172.16.0.0/16",
     *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
     *     vswitchName: name,
     * });
     * const defaultApplicationLoadBalancer = new alicloud.slb.ApplicationLoadBalancer("default", {
     *     loadBalancerName: name,
     *     vswitchId: defaultSwitch.id,
     * });
     * const defaultServerGroup = new alicloud.slb.ServerGroup("default", {loadBalancerId: defaultApplicationLoadBalancer.id});
     * const sampleDs = alicloud.slb.getServerGroupsOutput({
     *     loadBalancerId: defaultApplicationLoadBalancer.id,
     * });
     * export const firstSlbServerGroupId = sampleDs.apply(sampleDs => sampleDs.slbServerGroups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "slbservergroups"
     * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
     *     available_resource_creation="VSwitch")
     * default_network = alicloud.vpc.Network("default",
     *     vpc_name=name,
     *     cidr_block="172.16.0.0/16")
     * default_switch = alicloud.vpc.Switch("default",
     *     vpc_id=default_network.id,
     *     cidr_block="172.16.0.0/16",
     *     zone_id=default.zones[0].id,
     *     vswitch_name=name)
     * default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("default",
     *     load_balancer_name=name,
     *     vswitch_id=default_switch.id)
     * default_server_group = alicloud.slb.ServerGroup("default", load_balancer_id=default_application_load_balancer.id)
     * sample_ds = alicloud.slb.get_server_groups_output(load_balancer_id=default_application_load_balancer.id)
     * pulumi.export("firstSlbServerGroupId", sample_ds.slb_server_groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "slbservergroups";
     *     var @default = AliCloud.GetZones.Invoke(new()
     *     {
     *         AvailableDiskCategory = "cloud_efficiency",
     *         AvailableResourceCreation = "VSwitch",
     *     });
     *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
     *     {
     *         VpcName = name,
     *         CidrBlock = "172.16.0.0/16",
     *     });
     *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
     *     {
     *         VpcId = defaultNetwork.Id,
     *         CidrBlock = "172.16.0.0/16",
     *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
     *         VswitchName = name,
     *     });
     *     var defaultApplicationLoadBalancer = new AliCloud.Slb.ApplicationLoadBalancer("default", new()
     *     {
     *         LoadBalancerName = name,
     *         VswitchId = defaultSwitch.Id,
     *     });
     *     var defaultServerGroup = new AliCloud.Slb.ServerGroup("default", new()
     *     {
     *         LoadBalancerId = defaultApplicationLoadBalancer.Id,
     *     });
     *     var sampleDs = AliCloud.Slb.GetServerGroups.Invoke(new()
     *     {
     *         LoadBalancerId = defaultApplicationLoadBalancer.Id,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSlbServerGroupId"] = sampleDs&#46;Apply(getServerGroupsResult => getServerGroupsResult&#46;SlbServerGroups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "slbservergroups"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
     * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
     * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
     * 			VpcName:   pulumi.String(name),
     * 			CidrBlock: pulumi.String("172.16.0.0/16"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
     * 			VpcId:       defaultNetwork.ID(),
     * 			CidrBlock:   pulumi.String("172.16.0.0/16"),
     * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
     * 			VswitchName: pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultApplicationLoadBalancer, err := slb.NewApplicationLoadBalancer(ctx, "default", &slb.ApplicationLoadBalancerArgs{
     * 			LoadBalancerName: pulumi.String(name),
     * 			VswitchId:        defaultSwitch.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = slb.NewServerGroup(ctx, "default", &slb.ServerGroupArgs{
     * 			LoadBalancerId: defaultApplicationLoadBalancer.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		sampleDs := slb.GetServerGroupsOutput(ctx, slb.GetServerGroupsOutputArgs{
     * 			LoadBalancerId: defaultApplicationLoadBalancer.ID(),
     * 		}, nil)
     * 		ctx.Export("firstSlbServerGroupId", sampleDs.ApplyT(func(sampleDs slb.GetServerGroupsResult) (*string, error) {
     * 			return &sampleDs.SlbServerGroups[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.slb.ApplicationLoadBalancer;
     * import com.pulumi.alicloud.slb.ApplicationLoadBalancerArgs;
     * import com.pulumi.alicloud.slb.ServerGroup;
     * import com.pulumi.alicloud.slb.ServerGroupArgs;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetServerGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("slbservergroups");
     *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
     *             .availableDiskCategory("cloud_efficiency")
     *             .availableResourceCreation("VSwitch")
     *             .build());
     *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
     *             .vpcName(name)
     *             .cidrBlock("172.16.0.0/16")
     *             .build());
     *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
     *             .vpcId(defaultNetwork.id())
     *             .cidrBlock("172.16.0.0/16")
     *             .zoneId(default_.zones()[0].id())
     *             .vswitchName(name)
     *             .build());
     *         var defaultApplicationLoadBalancer = new ApplicationLoadBalancer("defaultApplicationLoadBalancer", ApplicationLoadBalancerArgs.builder()
     *             .loadBalancerName(name)
     *             .vswitchId(defaultSwitch.id())
     *             .build());
     *         var defaultServerGroup = new ServerGroup("defaultServerGroup", ServerGroupArgs.builder()
     *             .loadBalancerId(defaultApplicationLoadBalancer.id())
     *             .build());
     *         final var sampleDs = SlbFunctions.getServerGroups(GetServerGroupsArgs.builder()
     *             .loadBalancerId(defaultApplicationLoadBalancer.id())
     *             .build());
     *         ctx.export("firstSlbServerGroupId", sampleDs.applyValue(getServerGroupsResult -> getServerGroupsResult).applyValue(sampleDs -> sampleDs.applyValue(getServerGroupsResult -> getServerGroupsResult.slbServerGroups()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: slbservergroups
     * resources:
     *   defaultNetwork:
     *     type: alicloud:vpc:Network
     *     name: default
     *     properties:
     *       vpcName: ${name}
     *       cidrBlock: 172.16.0.0/16
     *   defaultSwitch:
     *     type: alicloud:vpc:Switch
     *     name: default
     *     properties:
     *       vpcId: ${defaultNetwork.id}
     *       cidrBlock: 172.16.0.0/16
     *       zoneId: ${default.zones[0].id}
     *       vswitchName: ${name}
     *   defaultApplicationLoadBalancer:
     *     type: alicloud:slb:ApplicationLoadBalancer
     *     name: default
     *     properties:
     *       loadBalancerName: ${name}
     *       vswitchId: ${defaultSwitch.id}
     *   defaultServerGroup:
     *     type: alicloud:slb:ServerGroup
     *     name: default
     *     properties:
     *       loadBalancerId: ${defaultApplicationLoadBalancer.id}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments:
     *         availableDiskCategory: cloud_efficiency
     *         availableResourceCreation: VSwitch
     *   sampleDs:
     *     fn::invoke:
     *       Function: alicloud:slb:getServerGroups
     *       Arguments:
     *         loadBalancerId: ${defaultApplicationLoadBalancer.id}
     * outputs:
     *   firstSlbServerGroupId: ${sampleDs.slbServerGroups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerGroups.
     * @return A collection of values returned by getServerGroups.
     */
    public suspend fun getServerGroups(argument: GetServerGroupsPlainArgs): GetServerGroupsResult =
        getServerGroupsResultToKotlin(getServerGroupsPlain(argument.toJava()).await())

    /**
     * @see [getServerGroups].
     * @param ids A list of VServer group IDs to filter results.
     * @param loadBalancerId ID of the SLB.
     * @param nameRegex A regex string to filter results by VServer group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getServerGroups.
     */
    public suspend fun getServerGroups(
        ids: List<String>? = null,
        loadBalancerId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetServerGroupsResult {
        val argument = GetServerGroupsPlainArgs(
            ids = ids,
            loadBalancerId = loadBalancerId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getServerGroupsResultToKotlin(getServerGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetServerGroupsPlainArgs].
     * @return A collection of values returned by getServerGroups.
     */
    public suspend fun getServerGroups(argument: suspend GetServerGroupsPlainArgsBuilder.() -> Unit): GetServerGroupsResult {
        val builder = GetServerGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerGroupsResultToKotlin(getServerGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Slb Tls Cipher Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.135.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.slb.getTlsCipherPolicies({
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const slbTlsCipherPolicyId1 = ids.then(ids => ids.policies?.[0]?.id);
     * const nameRegex = alicloud.slb.getTlsCipherPolicies({
     *     nameRegex: "^My-TlsCipherPolicy",
     * });
     * export const slbTlsCipherPolicyId2 = nameRegex.then(nameRegex => nameRegex.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.slb.get_tls_cipher_policies(ids=[
     *     "example_value-1",
     *     "example_value-2",
     * ])
     * pulumi.export("slbTlsCipherPolicyId1", ids.policies[0].id)
     * name_regex = alicloud.slb.get_tls_cipher_policies(name_regex="^My-TlsCipherPolicy")
     * pulumi.export("slbTlsCipherPolicyId2", name_regex.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Slb.GetTlsCipherPolicies.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Slb.GetTlsCipherPolicies.Invoke(new()
     *     {
     *         NameRegex = "^My-TlsCipherPolicy",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["slbTlsCipherPolicyId1"] = ids&#46;Apply(getTlsCipherPoliciesResult => getTlsCipherPoliciesResult&#46;Policies[0]?.Id),
     *         ["slbTlsCipherPolicyId2"] = nameRegex&#46;Apply(getTlsCipherPoliciesResult => getTlsCipherPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := slb.GetTlsCipherPolicies(ctx, &slb.GetTlsCipherPoliciesArgs{
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("slbTlsCipherPolicyId1", ids.Policies[0].Id)
     * 		nameRegex, err := slb.GetTlsCipherPolicies(ctx, &slb.GetTlsCipherPoliciesArgs{
     * 			NameRegex: pulumi.StringRef("^My-TlsCipherPolicy"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("slbTlsCipherPolicyId2", nameRegex.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetTlsCipherPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = SlbFunctions.getTlsCipherPolicies(GetTlsCipherPoliciesArgs.builder()
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("slbTlsCipherPolicyId1", ids.applyValue(getTlsCipherPoliciesResult -> getTlsCipherPoliciesResult.policies()[0].id()));
     *         final var nameRegex = SlbFunctions.getTlsCipherPolicies(GetTlsCipherPoliciesArgs.builder()
     *             .nameRegex("^My-TlsCipherPolicy")
     *             .build());
     *         ctx.export("slbTlsCipherPolicyId2", nameRegex.applyValue(getTlsCipherPoliciesResult -> getTlsCipherPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:slb:getTlsCipherPolicies
     *       Arguments:
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:slb:getTlsCipherPolicies
     *       Arguments:
     *         nameRegex: ^My-TlsCipherPolicy
     * outputs:
     *   slbTlsCipherPolicyId1: ${ids.policies[0].id}
     *   slbTlsCipherPolicyId2: ${nameRegex.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTlsCipherPolicies.
     * @return A collection of values returned by getTlsCipherPolicies.
     */
    public suspend fun getTlsCipherPolicies(argument: GetTlsCipherPoliciesPlainArgs): GetTlsCipherPoliciesResult =
        getTlsCipherPoliciesResultToKotlin(getTlsCipherPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getTlsCipherPolicies].
     * @param ids A list of Tls Cipher Policy IDs.
     * @param includeListener The include listener.
     * @param nameRegex A regex string to filter results by Tls Cipher Policy name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status TLS policy instance state. Valid values: `configuring`, `normal`.
     * @param tlsCipherPolicyName TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
     * @return A collection of values returned by getTlsCipherPolicies.
     */
    public suspend fun getTlsCipherPolicies(
        ids: List<String>? = null,
        includeListener: Boolean? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        tlsCipherPolicyName: String? = null,
    ): GetTlsCipherPoliciesResult {
        val argument = GetTlsCipherPoliciesPlainArgs(
            ids = ids,
            includeListener = includeListener,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            tlsCipherPolicyName = tlsCipherPolicyName,
        )
        return getTlsCipherPoliciesResultToKotlin(getTlsCipherPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTlsCipherPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetTlsCipherPoliciesPlainArgs].
     * @return A collection of values returned by getTlsCipherPolicies.
     */
    public suspend fun getTlsCipherPolicies(argument: suspend GetTlsCipherPoliciesPlainArgsBuilder.() -> Unit): GetTlsCipherPoliciesResult {
        val builder = GetTlsCipherPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTlsCipherPoliciesResultToKotlin(getTlsCipherPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides availability zones for SLB that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** Available in v1.73.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const zonesIds = alicloud.slb.getZones({
     *     availableSlbAddressType: "vpc",
     *     availableSlbAddressIpVersion: "ipv4",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * zones_ids = alicloud.slb.get_zones(available_slb_address_type="vpc",
     *     available_slb_address_ip_version="ipv4")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var zonesIds = AliCloud.Slb.GetZones.Invoke(new()
     *     {
     *         AvailableSlbAddressType = "vpc",
     *         AvailableSlbAddressIpVersion = "ipv4",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := slb.GetZones(ctx, &slb.GetZonesArgs{
     * 			AvailableSlbAddressType:      pulumi.StringRef("vpc"),
     * 			AvailableSlbAddressIpVersion: pulumi.StringRef("ipv4"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var zonesIds = SlbFunctions.getZones(GetZonesArgs.builder()
     *             .availableSlbAddressType("vpc")
     *             .availableSlbAddressIpVersion("ipv4")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   zonesIds:
     *     fn::invoke:
     *       Function: alicloud:slb:getZones
     *       Arguments:
     *         availableSlbAddressType: vpc
     *         availableSlbAddressIpVersion: ipv4
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param availableSlbAddressIpVersion Filter the results by a slb instance address version. Can be either `ipv4`, or `ipv6`.
     * @param availableSlbAddressType Filter the results by a slb instance network type. Valid values:
     * * vpc: an internal SLB instance that is deployed in a virtual private cloud (VPC).
     * * classic_internet: a public-facing SLB instance.
     * * classic_intranet: an internal SLB instance that is deployed in a classic network.
     * @param enableDetails Default to false and only output `id` in the `zones` block. Set it to true can output more details.
     * @param masterZoneId The primary zone.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param slaveZoneId The secondary zone.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(
        availableSlbAddressIpVersion: String? = null,
        availableSlbAddressType: String? = null,
        enableDetails: Boolean? = null,
        masterZoneId: String? = null,
        outputFile: String? = null,
        slaveZoneId: String? = null,
    ): GetZonesResult {
        val argument = GetZonesPlainArgs(
            availableSlbAddressIpVersion = availableSlbAddressIpVersion,
            availableSlbAddressType = availableSlbAddressType,
            enableDetails = enableDetails,
            masterZoneId = masterZoneId,
            outputFile = outputFile,
            slaveZoneId = slaveZoneId,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;slb&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
