@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [TlsCipherPolicy].
 */
@PulumiTagMarker
public class TlsCipherPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TlsCipherPolicyArgs = TlsCipherPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TlsCipherPolicyArgsBuilder.() -> Unit) {
        val builder = TlsCipherPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TlsCipherPolicy {
        val builtJavaResource = com.pulumi.alicloud.slb.TlsCipherPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TlsCipherPolicy(builtJavaResource)
    }
}

/**
 * Provides a SLB Tls Cipher Policy resource.
 * For information about SLB Tls Cipher Policy and how to use it, see [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
 * > **NOTE:** Available in v1.135.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.slb.TlsCipherPolicy("example", {
 *     tlsCipherPolicyName: "Test-example_value",
 *     tlsVersions: ["TLSv1&#46;2"],
 *     ciphers: [
 *         "AES256-SHA256",
 *         "AES128-GCM-SHA256",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.slb.TlsCipherPolicy("example",
 *     tls_cipher_policy_name="Test-example_value",
 *     tls_versions=["TLSv1&#46;2"],
 *     ciphers=[
 *         "AES256-SHA256",
 *         "AES128-GCM-SHA256",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Slb.TlsCipherPolicy("example", new()
 *     {
 *         TlsCipherPolicyName = "Test-example_value",
 *         TlsVersions = new[]
 *         {
 *             "TLSv1.2",
 *         },
 *         Ciphers = new[]
 *         {
 *             "AES256-SHA256",
 *             "AES128-GCM-SHA256",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := slb.NewTlsCipherPolicy(ctx, "example", &slb.TlsCipherPolicyArgs{
 * 			TlsCipherPolicyName: pulumi.String("Test-example_value"),
 * 			TlsVersions: pulumi.StringArray{
 * 				pulumi.String("TLSv1.2"),
 * 			},
 * 			Ciphers: pulumi.StringArray{
 * 				pulumi.String("AES256-SHA256"),
 * 				pulumi.String("AES128-GCM-SHA256"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.slb.TlsCipherPolicy;
 * import com.pulumi.alicloud.slb.TlsCipherPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TlsCipherPolicy("example", TlsCipherPolicyArgs.builder()
 *             .tlsCipherPolicyName("Test-example_value")
 *             .tlsVersions("TLSv1.2")
 *             .ciphers(
 *                 "AES256-SHA256",
 *                 "AES128-GCM-SHA256")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:slb:TlsCipherPolicy
 *     properties:
 *       tlsCipherPolicyName: Test-example_value
 *       tlsVersions:
 *         - TLSv1.2
 *       ciphers:
 *         - AES256-SHA256
 *         - AES128-GCM-SHA256
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SLB Tls Cipher Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/tlsCipherPolicy:TlsCipherPolicy example <id>
 * ```
 */
public class TlsCipherPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.slb.TlsCipherPolicy,
) : KotlinCustomResource(javaResource, TlsCipherPolicyMapper) {
    /**
     * The encryption algorithms supported. It depends on the value of `tls_versions`.
     */
    public val ciphers: Output<List<String>>
        get() = javaResource.ciphers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * TLS policy instance state.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
     */
    public val tlsCipherPolicyName: Output<String>
        get() = javaResource.tlsCipherPolicyName().applyValue({ args0 -> args0 })

    /**
     * The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
     */
    public val tlsVersions: Output<List<String>>
        get() = javaResource.tlsVersions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object TlsCipherPolicyMapper : ResourceMapper<TlsCipherPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.slb.TlsCipherPolicy::class == javaResource::class

    override fun map(javaResource: Resource): TlsCipherPolicy = TlsCipherPolicy(
        javaResource as
            com.pulumi.alicloud.slb.TlsCipherPolicy,
    )
}

/**
 * @see [TlsCipherPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TlsCipherPolicy].
 */
public suspend fun tlsCipherPolicy(
    name: String,
    block: suspend TlsCipherPolicyResourceBuilder.() -> Unit,
): TlsCipherPolicy {
    val builder = TlsCipherPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TlsCipherPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tlsCipherPolicy(name: String): TlsCipherPolicy {
    val builder = TlsCipherPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
