@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin

import com.pulumi.alicloud.slb.TlsCipherPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a SLB Tls Cipher Policy resource.
 * For information about SLB Tls Cipher Policy and how to use it, see [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
 * > **NOTE:** Available in v1.135.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.slb.TlsCipherPolicy("example", {
 *     tlsCipherPolicyName: "Test-example_value",
 *     tlsVersions: ["TLSv1&#46;2"],
 *     ciphers: [
 *         "AES256-SHA256",
 *         "AES128-GCM-SHA256",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.slb.TlsCipherPolicy("example",
 *     tls_cipher_policy_name="Test-example_value",
 *     tls_versions=["TLSv1&#46;2"],
 *     ciphers=[
 *         "AES256-SHA256",
 *         "AES128-GCM-SHA256",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Slb.TlsCipherPolicy("example", new()
 *     {
 *         TlsCipherPolicyName = "Test-example_value",
 *         TlsVersions = new[]
 *         {
 *             "TLSv1.2",
 *         },
 *         Ciphers = new[]
 *         {
 *             "AES256-SHA256",
 *             "AES128-GCM-SHA256",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := slb.NewTlsCipherPolicy(ctx, "example", &slb.TlsCipherPolicyArgs{
 * 			TlsCipherPolicyName: pulumi.String("Test-example_value"),
 * 			TlsVersions: pulumi.StringArray{
 * 				pulumi.String("TLSv1.2"),
 * 			},
 * 			Ciphers: pulumi.StringArray{
 * 				pulumi.String("AES256-SHA256"),
 * 				pulumi.String("AES128-GCM-SHA256"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.slb.TlsCipherPolicy;
 * import com.pulumi.alicloud.slb.TlsCipherPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TlsCipherPolicy("example", TlsCipherPolicyArgs.builder()
 *             .tlsCipherPolicyName("Test-example_value")
 *             .tlsVersions("TLSv1.2")
 *             .ciphers(
 *                 "AES256-SHA256",
 *                 "AES128-GCM-SHA256")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:slb:TlsCipherPolicy
 *     properties:
 *       tlsCipherPolicyName: Test-example_value
 *       tlsVersions:
 *         - TLSv1.2
 *       ciphers:
 *         - AES256-SHA256
 *         - AES128-GCM-SHA256
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SLB Tls Cipher Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:slb/tlsCipherPolicy:TlsCipherPolicy example <id>
 * ```
 * @property ciphers The encryption algorithms supported. It depends on the value of `tls_versions`.
 * @property tlsCipherPolicyName TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
 * @property tlsVersions The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
 */
public data class TlsCipherPolicyArgs(
    public val ciphers: Output<List<String>>? = null,
    public val tlsCipherPolicyName: Output<String>? = null,
    public val tlsVersions: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.TlsCipherPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.TlsCipherPolicyArgs =
        com.pulumi.alicloud.slb.TlsCipherPolicyArgs.builder()
            .ciphers(ciphers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tlsCipherPolicyName(tlsCipherPolicyName?.applyValue({ args0 -> args0 }))
            .tlsVersions(tlsVersions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TlsCipherPolicyArgs].
 */
@PulumiTagMarker
public class TlsCipherPolicyArgsBuilder internal constructor() {
    private var ciphers: Output<List<String>>? = null

    private var tlsCipherPolicyName: Output<String>? = null

    private var tlsVersions: Output<List<String>>? = null

    /**
     * @param value The encryption algorithms supported. It depends on the value of `tls_versions`.
     */
    @JvmName("owqqsjmbgjnxkquu")
    public suspend fun ciphers(`value`: Output<List<String>>) {
        this.ciphers = value
    }

    @JvmName("harsqqrkxwxujjvi")
    public suspend fun ciphers(vararg values: Output<String>) {
        this.ciphers = Output.all(values.asList())
    }

    /**
     * @param values The encryption algorithms supported. It depends on the value of `tls_versions`.
     */
    @JvmName("pfbakjemkemoubgj")
    public suspend fun ciphers(values: List<Output<String>>) {
        this.ciphers = Output.all(values)
    }

    /**
     * @param value TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
     */
    @JvmName("cdfxamvwdkpclqpx")
    public suspend fun tlsCipherPolicyName(`value`: Output<String>) {
        this.tlsCipherPolicyName = value
    }

    /**
     * @param value The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
     */
    @JvmName("attcxlmuqdgerxab")
    public suspend fun tlsVersions(`value`: Output<List<String>>) {
        this.tlsVersions = value
    }

    @JvmName("hokqieryslixnqac")
    public suspend fun tlsVersions(vararg values: Output<String>) {
        this.tlsVersions = Output.all(values.asList())
    }

    /**
     * @param values The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
     */
    @JvmName("euinalqcpriuwcfq")
    public suspend fun tlsVersions(values: List<Output<String>>) {
        this.tlsVersions = Output.all(values)
    }

    /**
     * @param value The encryption algorithms supported. It depends on the value of `tls_versions`.
     */
    @JvmName("ftjpxgmrpnhggmof")
    public suspend fun ciphers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ciphers = mapped
    }

    /**
     * @param values The encryption algorithms supported. It depends on the value of `tls_versions`.
     */
    @JvmName("bgdjyvonnotiwwvm")
    public suspend fun ciphers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ciphers = mapped
    }

    /**
     * @param value TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
     */
    @JvmName("icufnifjffvpkcix")
    public suspend fun tlsCipherPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsCipherPolicyName = mapped
    }

    /**
     * @param value The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
     */
    @JvmName("hndgtwdeioqtfhly")
    public suspend fun tlsVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsVersions = mapped
    }

    /**
     * @param values The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
     */
    @JvmName("ptfsigtrqdftqygw")
    public suspend fun tlsVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tlsVersions = mapped
    }

    internal fun build(): TlsCipherPolicyArgs = TlsCipherPolicyArgs(
        ciphers = ciphers,
        tlsCipherPolicyName = tlsCipherPolicyName,
        tlsVersions = tlsVersions,
    )
}
