@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.AclEntryListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comment
 * @property entry
 */
public data class AclEntryListArgs(
    public val comment: Output<String>? = null,
    public val entry: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.AclEntryListArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.AclEntryListArgs =
        com.pulumi.alicloud.slb.inputs.AclEntryListArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .entry(entry?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AclEntryListArgs].
 */
@PulumiTagMarker
public class AclEntryListArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var entry: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("fcyxfgutufobqaba")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value
     */
    @JvmName("ximjifmyipwerngv")
    public suspend fun entry(`value`: Output<String>) {
        this.entry = value
    }

    /**
     * @param value
     */
    @JvmName("qlifkpbqtvgfdysn")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value
     */
    @JvmName("dcxnkkpwralveeqe")
    public suspend fun entry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entry = mapped
    }

    internal fun build(): AclEntryListArgs = AclEntryListArgs(
        comment = comment,
        entry = entry,
    )
}
