@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.BackendServerBackendServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property serverId
 * @property serverIp
 * @property type
 * @property weight
 */
public data class BackendServerBackendServerArgs(
    public val serverId: Output<String>,
    public val serverIp: Output<String>? = null,
    public val type: Output<String>? = null,
    public val weight: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.BackendServerBackendServerArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.BackendServerBackendServerArgs =
        com.pulumi.alicloud.slb.inputs.BackendServerBackendServerArgs.builder()
            .serverId(serverId.applyValue({ args0 -> args0 }))
            .serverIp(serverIp?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .weight(weight.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackendServerBackendServerArgs].
 */
@PulumiTagMarker
public class BackendServerBackendServerArgsBuilder internal constructor() {
    private var serverId: Output<String>? = null

    private var serverIp: Output<String>? = null

    private var type: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("ndoocwavscnvrsys")
    public suspend fun serverId(`value`: Output<String>) {
        this.serverId = value
    }

    /**
     * @param value
     */
    @JvmName("kflobvkwexaigqwi")
    public suspend fun serverIp(`value`: Output<String>) {
        this.serverIp = value
    }

    /**
     * @param value
     */
    @JvmName("pcqdvhhtyalgbkcq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("lcuelrkcduqjqylk")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value
     */
    @JvmName("ejcbuygqxpcnrmbp")
    public suspend fun serverId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverId = mapped
    }

    /**
     * @param value
     */
    @JvmName("fucttinoluqpyiub")
    public suspend fun serverIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverIp = mapped
    }

    /**
     * @param value
     */
    @JvmName("ggmvenntsxjnhfnf")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("dslgdqowukacythx")
    public suspend fun weight(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): BackendServerBackendServerArgs = BackendServerBackendServerArgs(
        serverId = serverId ?: throw PulumiNullFieldException("serverId"),
        serverIp = serverIp,
        type = type,
        weight = weight ?: throw PulumiNullFieldException("weight"),
    )
}
