@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.GetAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAttachments.
 * @property instanceIds List of attached ECS instance IDs.
 * @property loadBalancerId ID of the SLB with attachments.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetAttachmentsPlainArgs(
    public val instanceIds: List<String>? = null,
    public val loadBalancerId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.GetAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.GetAttachmentsPlainArgs =
        com.pulumi.alicloud.slb.inputs.GetAttachmentsPlainArgs.builder()
            .instanceIds(instanceIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .loadBalancerId(loadBalancerId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetAttachmentsPlainArgsBuilder internal constructor() {
    private var instanceIds: List<String>? = null

    private var loadBalancerId: String? = null

    private var outputFile: String? = null

    /**
     * @param value List of attached ECS instance IDs.
     */
    @JvmName("ckuhbbgdpayusscu")
    public suspend fun instanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceIds = mapped
    }

    /**
     * @param values List of attached ECS instance IDs.
     */
    @JvmName("dgbppkukqldcctnx")
    public suspend fun instanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceIds = mapped
    }

    /**
     * @param value ID of the SLB with attachments.
     */
    @JvmName("aostkodmsupiolec")
    public suspend fun loadBalancerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("yxfkrmocqadpbypl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAttachmentsPlainArgs = GetAttachmentsPlainArgs(
        instanceIds = instanceIds,
        loadBalancerId = loadBalancerId ?: throw PulumiNullFieldException("loadBalancerId"),
        outputFile = outputFile,
    )
}
