@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.GetBackendServersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBackendServers.
 * @property ids List of attached ECS instance IDs.
 * @property loadBalancerId ID of the SLB with attachments.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetBackendServersPlainArgs(
    public val ids: List<String>? = null,
    public val loadBalancerId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.GetBackendServersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.GetBackendServersPlainArgs =
        com.pulumi.alicloud.slb.inputs.GetBackendServersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .loadBalancerId(loadBalancerId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackendServersPlainArgs].
 */
@PulumiTagMarker
public class GetBackendServersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var loadBalancerId: String? = null

    private var outputFile: String? = null

    /**
     * @param value List of attached ECS instance IDs.
     */
    @JvmName("mtijqfldqeaynqfg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values List of attached ECS instance IDs.
     */
    @JvmName("naxwfnfajpwqwnlf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value ID of the SLB with attachments.
     */
    @JvmName("ulyyfhjjnoocmwqe")
    public suspend fun loadBalancerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tylmxxknkdcgfwfx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetBackendServersPlainArgs = GetBackendServersPlainArgs(
        ids = ids,
        loadBalancerId = loadBalancerId ?: throw PulumiNullFieldException("loadBalancerId"),
        outputFile = outputFile,
    )
}
