@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.GetDomainExtensionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomainExtensions.
 * @property frontendPort The frontend port used by the HTTPS listener of the SLB instance. Valid values: 1–65535.
 * @property ids IDs of the SLB domain extensions.
 * @property loadBalancerId The ID of the SLB instance.
 * @property outputFile
 */
public data class GetDomainExtensionsPlainArgs(
    public val frontendPort: Int,
    public val ids: List<String>? = null,
    public val loadBalancerId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.GetDomainExtensionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.GetDomainExtensionsPlainArgs =
        com.pulumi.alicloud.slb.inputs.GetDomainExtensionsPlainArgs.builder()
            .frontendPort(frontendPort.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .loadBalancerId(loadBalancerId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainExtensionsPlainArgs].
 */
@PulumiTagMarker
public class GetDomainExtensionsPlainArgsBuilder internal constructor() {
    private var frontendPort: Int? = null

    private var ids: List<String>? = null

    private var loadBalancerId: String? = null

    private var outputFile: String? = null

    /**
     * @param value The frontend port used by the HTTPS listener of the SLB instance. Valid values: 1–65535.
     */
    @JvmName("dymvfqvxvqkfrxln")
    public suspend fun frontendPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.frontendPort = mapped
    }

    /**
     * @param value IDs of the SLB domain extensions.
     */
    @JvmName("lpiryjlwfpmpprkv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values IDs of the SLB domain extensions.
     */
    @JvmName("wpghugmavbppmcav")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the SLB instance.
     */
    @JvmName("pqlrfrgsxqrkeyvf")
    public suspend fun loadBalancerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerId = mapped
    }

    /**
     * @param value
     */
    @JvmName("wvrvfvamxepustjb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetDomainExtensionsPlainArgs = GetDomainExtensionsPlainArgs(
        frontendPort = frontendPort ?: throw PulumiNullFieldException("frontendPort"),
        ids = ids,
        loadBalancerId = loadBalancerId ?: throw PulumiNullFieldException("loadBalancerId"),
        outputFile = outputFile,
    )
}
