@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.GetListenersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getListeners.
 * @property descriptionRegex A regex string to filter results by SLB listener description.
 * @property frontendPort Filter listeners by the specified frontend port.
 * @property loadBalancerId ID of the SLB with listeners.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property protocol Filter listeners by the specified protocol. Valid values: `http`, `https`, `tcp` and `udp`.
 */
public data class GetListenersPlainArgs(
    public val descriptionRegex: String? = null,
    public val frontendPort: Int? = null,
    public val loadBalancerId: String,
    public val outputFile: String? = null,
    public val protocol: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.GetListenersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.GetListenersPlainArgs =
        com.pulumi.alicloud.slb.inputs.GetListenersPlainArgs.builder()
            .descriptionRegex(descriptionRegex?.let({ args0 -> args0 }))
            .frontendPort(frontendPort?.let({ args0 -> args0 }))
            .loadBalancerId(loadBalancerId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .protocol(protocol?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetListenersPlainArgs].
 */
@PulumiTagMarker
public class GetListenersPlainArgsBuilder internal constructor() {
    private var descriptionRegex: String? = null

    private var frontendPort: Int? = null

    private var loadBalancerId: String? = null

    private var outputFile: String? = null

    private var protocol: String? = null

    /**
     * @param value A regex string to filter results by SLB listener description.
     */
    @JvmName("dxhkcgywlselekik")
    public suspend fun descriptionRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.descriptionRegex = mapped
    }

    /**
     * @param value Filter listeners by the specified frontend port.
     */
    @JvmName("ghkwwkheoyoetfat")
    public suspend fun frontendPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.frontendPort = mapped
    }

    /**
     * @param value ID of the SLB with listeners.
     */
    @JvmName("gbrvhbluefufpwcl")
    public suspend fun loadBalancerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("flqthgwigilrocma")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Filter listeners by the specified protocol. Valid values: `http`, `https`, `tcp` and `udp`.
     */
    @JvmName("gyctygcidajonoyo")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.protocol = mapped
    }

    internal fun build(): GetListenersPlainArgs = GetListenersPlainArgs(
        descriptionRegex = descriptionRegex,
        frontendPort = frontendPort,
        loadBalancerId = loadBalancerId ?: throw PulumiNullFieldException("loadBalancerId"),
        outputFile = outputFile,
        protocol = protocol,
    )
}
