@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.GetLoadBalancersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLoadBalancers.
 * @property address Service address of the SLBs.
 * @property addressIpVersion
 * @property addressType
 * @property enableDetails
 * @property ids A list of SLBs IDs.
 * @property internetChargeType
 * @property loadBalancerName
 * @property masterZoneId
 * @property nameRegex A regex string to filter results by SLB name.
 * @property networkType Network type of the SLBs. Valid values: `vpc` and `classic`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property paymentType
 * @property resourceGroupId The Id of resource group which SLB belongs.
 * @property serverId
 * @property serverIntranetAddress
 * @property slaveZoneId
 * @property status SLB current status. Possible values: `inactive`, `active` and `locked`.
 * @property tags A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const taggedInstances = alicloud.slb.getLoadBalancers({
 *     tags: {
 *         tagKey1: "tagValue1",
 *         tagKey2: "tagValue2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * tagged_instances = alicloud.slb.get_load_balancers(tags={
 *     "tagKey1": "tagValue1",
 *     "tagKey2": "tagValue2",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var taggedInstances = AliCloud.Slb.GetLoadBalancers.Invoke(new()
 *     {
 *         Tags =
 *         {
 *             { "tagKey1", "tagValue1" },
 *             { "tagKey2", "tagValue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := slb.GetLoadBalancers(ctx, &slb.GetLoadBalancersArgs{
 * 			Tags: map[string]interface{}{
 * 				"tagKey1": "tagValue1",
 * 				"tagKey2": "tagValue2",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.slb.SlbFunctions;
 * import com.pulumi.alicloud.slb.inputs.GetLoadBalancersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var taggedInstances = SlbFunctions.getLoadBalancers(GetLoadBalancersArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("tagKey1", "tagValue1"),
 *                 Map.entry("tagKey2", "tagValue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   taggedInstances:
 *     fn::invoke:
 *       Function: alicloud:slb:getLoadBalancers
 *       Arguments:
 *         tags:
 *           tagKey1: tagValue1
 *           tagKey2: tagValue2
 * ```
 * <!--End PulumiCodeChooser -->
 * @property vpcId ID of the VPC linked to the SLBs.
 * @property vswitchId ID of the vSwitch linked to the SLBs.
 */
public data class GetLoadBalancersPlainArgs(
    public val address: String? = null,
    public val addressIpVersion: String? = null,
    public val addressType: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val internetChargeType: String? = null,
    public val loadBalancerName: String? = null,
    public val masterZoneId: String? = null,
    public val nameRegex: String? = null,
    public val networkType: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val paymentType: String? = null,
    public val resourceGroupId: String? = null,
    public val serverId: String? = null,
    public val serverIntranetAddress: String? = null,
    public val slaveZoneId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.GetLoadBalancersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.GetLoadBalancersPlainArgs =
        com.pulumi.alicloud.slb.inputs.GetLoadBalancersPlainArgs.builder()
            .address(address?.let({ args0 -> args0 }))
            .addressIpVersion(addressIpVersion?.let({ args0 -> args0 }))
            .addressType(addressType?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .internetChargeType(internetChargeType?.let({ args0 -> args0 }))
            .loadBalancerName(loadBalancerName?.let({ args0 -> args0 }))
            .masterZoneId(masterZoneId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .networkType(networkType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .paymentType(paymentType?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .serverId(serverId?.let({ args0 -> args0 }))
            .serverIntranetAddress(serverIntranetAddress?.let({ args0 -> args0 }))
            .slaveZoneId(slaveZoneId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 }))
            .vswitchId(vswitchId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLoadBalancersPlainArgs].
 */
@PulumiTagMarker
public class GetLoadBalancersPlainArgsBuilder internal constructor() {
    private var address: String? = null

    private var addressIpVersion: String? = null

    private var addressType: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var internetChargeType: String? = null

    private var loadBalancerName: String? = null

    private var masterZoneId: String? = null

    private var nameRegex: String? = null

    private var networkType: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var paymentType: String? = null

    private var resourceGroupId: String? = null

    private var serverId: String? = null

    private var serverIntranetAddress: String? = null

    private var slaveZoneId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    private var vswitchId: String? = null

    /**
     * @param value Service address of the SLBs.
     */
    @JvmName("mmwemkrsasfkouvp")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.address = mapped
    }

    /**
     * @param value
     */
    @JvmName("edrfwykymncgbmnf")
    public suspend fun addressIpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.addressIpVersion = mapped
    }

    /**
     * @param value
     */
    @JvmName("pdagfuucqyxwaamj")
    public suspend fun addressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.addressType = mapped
    }

    /**
     * @param value
     */
    @JvmName("hwnopbllmvwqrmij")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of SLBs IDs.
     */
    @JvmName("odrlvsocwodhanmm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of SLBs IDs.
     */
    @JvmName("hrmlimgnuthoofnn")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("niexaqeyeffmofjb")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.internetChargeType = mapped
    }

    /**
     * @param value
     */
    @JvmName("foyrneujgihadgwh")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.loadBalancerName = mapped
    }

    /**
     * @param value
     */
    @JvmName("gcoghvvwmbssgknw")
    public suspend fun masterZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.masterZoneId = mapped
    }

    /**
     * @param value A regex string to filter results by SLB name.
     */
    @JvmName("hhikxfjsawmhdhfu")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Network type of the SLBs. Valid values: `vpc` and `classic`.
     */
    @JvmName("umwqpusrhyuhhheh")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nxnvjvstuwepkltu")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("lhcwgwxlgcvfabgp")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("gbpcjpibqbgugtde")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("qkcuegsdhkhiqmjp")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.paymentType = mapped
    }

    /**
     * @param value The Id of resource group which SLB belongs.
     */
    @JvmName("opeptcwbbwmkrcqk")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("untdmflbipuhdeol")
    public suspend fun serverId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serverId = mapped
    }

    /**
     * @param value
     */
    @JvmName("tiokeksahcajljoi")
    public suspend fun serverIntranetAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serverIntranetAddress = mapped
    }

    /**
     * @param value
     */
    @JvmName("rkuucqnpjnxieppi")
    public suspend fun slaveZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.slaveZoneId = mapped
    }

    /**
     * @param value SLB current status. Possible values: `inactive`, `active` and `locked`.
     */
    @JvmName("snxwqlgdlrnnvcik")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const taggedInstances = alicloud.slb.getLoadBalancers({
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * tagged_instances = alicloud.slb.get_load_balancers(tags={
     *     "tagKey1": "tagValue1",
     *     "tagKey2": "tagValue2",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var taggedInstances = AliCloud.Slb.GetLoadBalancers.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := slb.GetLoadBalancers(ctx, &slb.GetLoadBalancersArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetLoadBalancersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var taggedInstances = SlbFunctions.getLoadBalancers(GetLoadBalancersArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   taggedInstances:
     *     fn::invoke:
     *       Function: alicloud:slb:getLoadBalancers
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("qirhsgmnfsgxvntb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const taggedInstances = alicloud.slb.getLoadBalancers({
     *     tags: {
     *         tagKey1: "tagValue1",
     *         tagKey2: "tagValue2",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * tagged_instances = alicloud.slb.get_load_balancers(tags={
     *     "tagKey1": "tagValue1",
     *     "tagKey2": "tagValue2",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var taggedInstances = AliCloud.Slb.GetLoadBalancers.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "tagKey1", "tagValue1" },
     *             { "tagKey2", "tagValue2" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := slb.GetLoadBalancers(ctx, &slb.GetLoadBalancersArgs{
     * 			Tags: map[string]interface{}{
     * 				"tagKey1": "tagValue1",
     * 				"tagKey2": "tagValue2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.slb.SlbFunctions;
     * import com.pulumi.alicloud.slb.inputs.GetLoadBalancersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var taggedInstances = SlbFunctions.getLoadBalancers(GetLoadBalancersArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("tagKey1", "tagValue1"),
     *                 Map.entry("tagKey2", "tagValue2")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   taggedInstances:
     *     fn::invoke:
     *       Function: alicloud:slb:getLoadBalancers
     *       Arguments:
     *         tags:
     *           tagKey1: tagValue1
     *           tagKey2: tagValue2
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("nlplkdvetdpgphrs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value ID of the VPC linked to the SLBs.
     */
    @JvmName("rbuodsjjidnhssnm")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    /**
     * @param value ID of the vSwitch linked to the SLBs.
     */
    @JvmName("xhcymgbbnkbpxymk")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchId = mapped
    }

    internal fun build(): GetLoadBalancersPlainArgs = GetLoadBalancersPlainArgs(
        address = address,
        addressIpVersion = addressIpVersion,
        addressType = addressType,
        enableDetails = enableDetails,
        ids = ids,
        internetChargeType = internetChargeType,
        loadBalancerName = loadBalancerName,
        masterZoneId = masterZoneId,
        nameRegex = nameRegex,
        networkType = networkType,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        paymentType = paymentType,
        resourceGroupId = resourceGroupId,
        serverId = serverId,
        serverIntranetAddress = serverIntranetAddress,
        slaveZoneId = slaveZoneId,
        status = status,
        tags = tags,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
