@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.GetMasterSlaveServerGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMasterSlaveServerGroups.
 * @property ids A list of master slave server group IDs to filter results.
 * @property loadBalancerId ID of the SLB.
 * @property nameRegex A regex string to filter results by master slave server group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetMasterSlaveServerGroupsPlainArgs(
    public val ids: List<String>? = null,
    public val loadBalancerId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.GetMasterSlaveServerGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.GetMasterSlaveServerGroupsPlainArgs =
        com.pulumi.alicloud.slb.inputs.GetMasterSlaveServerGroupsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .loadBalancerId(loadBalancerId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMasterSlaveServerGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetMasterSlaveServerGroupsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var loadBalancerId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of master slave server group IDs to filter results.
     */
    @JvmName("svmdffjbdodkhohp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of master slave server group IDs to filter results.
     */
    @JvmName("jauikbivvpnyqwbs")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value ID of the SLB.
     */
    @JvmName("gqgtxutktpgbnxrx")
    public suspend fun loadBalancerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerId = mapped
    }

    /**
     * @param value A regex string to filter results by master slave server group name.
     */
    @JvmName("gwynitrecwiahqiu")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("uohqwtcvyotkitgh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetMasterSlaveServerGroupsPlainArgs = GetMasterSlaveServerGroupsPlainArgs(
        ids = ids,
        loadBalancerId = loadBalancerId ?: throw PulumiNullFieldException("loadBalancerId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
