@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.GetRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRules.
 * @property frontendPort SLB listener port.
 * @property ids A list of rules IDs to filter results.
 * @property loadBalancerId ID of the SLB with listener rules.
 * @property nameRegex A regex string to filter results by rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetRulesPlainArgs(
    public val frontendPort: Int,
    public val ids: List<String>? = null,
    public val loadBalancerId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.GetRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.GetRulesPlainArgs =
        com.pulumi.alicloud.slb.inputs.GetRulesPlainArgs.builder()
            .frontendPort(frontendPort.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .loadBalancerId(loadBalancerId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRulesPlainArgs].
 */
@PulumiTagMarker
public class GetRulesPlainArgsBuilder internal constructor() {
    private var frontendPort: Int? = null

    private var ids: List<String>? = null

    private var loadBalancerId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value SLB listener port.
     */
    @JvmName("bwsbdvwmpouptylg")
    public suspend fun frontendPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.frontendPort = mapped
    }

    /**
     * @param value A list of rules IDs to filter results.
     */
    @JvmName("opbkoivmrewgbjsn")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of rules IDs to filter results.
     */
    @JvmName("ogcnjwqdhoqxnwxy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value ID of the SLB with listener rules.
     */
    @JvmName("qxbcmgrjjwuewnum")
    public suspend fun loadBalancerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerId = mapped
    }

    /**
     * @param value A regex string to filter results by rule name.
     */
    @JvmName("fehbkaskmdjfblpl")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rfoowphwufjfeoel")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetRulesPlainArgs = GetRulesPlainArgs(
        frontendPort = frontendPort ?: throw PulumiNullFieldException("frontendPort"),
        ids = ids,
        loadBalancerId = loadBalancerId ?: throw PulumiNullFieldException("loadBalancerId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
