@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.GetServerGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerGroups.
 * @property ids A list of VServer group IDs to filter results.
 * @property loadBalancerId ID of the SLB.
 * @property nameRegex A regex string to filter results by VServer group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetServerGroupsPlainArgs(
    public val ids: List<String>? = null,
    public val loadBalancerId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.GetServerGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.GetServerGroupsPlainArgs =
        com.pulumi.alicloud.slb.inputs.GetServerGroupsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .loadBalancerId(loadBalancerId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetServerGroupsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var loadBalancerId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of VServer group IDs to filter results.
     */
    @JvmName("igkmbeulbukuwpde")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of VServer group IDs to filter results.
     */
    @JvmName("dhgxmhvtegukqssd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value ID of the SLB.
     */
    @JvmName("poivbqrhhvwvxbrc")
    public suspend fun loadBalancerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerId = mapped
    }

    /**
     * @param value A regex string to filter results by VServer group name.
     */
    @JvmName("aowfpiimxapimewt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("llbfashnuksioglt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetServerGroupsPlainArgs = GetServerGroupsPlainArgs(
        ids = ids,
        loadBalancerId = loadBalancerId ?: throw PulumiNullFieldException("loadBalancerId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
