@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.GetTlsCipherPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTlsCipherPolicies.
 * @property ids A list of Tls Cipher Policy IDs.
 * @property includeListener The include listener.
 * @property nameRegex A regex string to filter results by Tls Cipher Policy name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status TLS policy instance state. Valid values: `configuring`, `normal`.
 * @property tlsCipherPolicyName TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
 */
public data class GetTlsCipherPoliciesPlainArgs(
    public val ids: List<String>? = null,
    public val includeListener: Boolean? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val tlsCipherPolicyName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.GetTlsCipherPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.GetTlsCipherPoliciesPlainArgs =
        com.pulumi.alicloud.slb.inputs.GetTlsCipherPoliciesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeListener(includeListener?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tlsCipherPolicyName(tlsCipherPolicyName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTlsCipherPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetTlsCipherPoliciesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var includeListener: Boolean? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var tlsCipherPolicyName: String? = null

    /**
     * @param value A list of Tls Cipher Policy IDs.
     */
    @JvmName("fdycduhpmqlhdcyg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Tls Cipher Policy IDs.
     */
    @JvmName("hqywgwlkkdmxqqiu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The include listener.
     */
    @JvmName("uxcrwtsniugkbhyf")
    public suspend fun includeListener(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeListener = mapped
    }

    /**
     * @param value A regex string to filter results by Tls Cipher Policy name.
     */
    @JvmName("abtydnduqgkvigmd")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kfkhpmluckogmkjy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value TLS policy instance state. Valid values: `configuring`, `normal`.
     */
    @JvmName("xtdmrbcwgsejlfwu")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
     */
    @JvmName("hdfbicrxijgsasdh")
    public suspend fun tlsCipherPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tlsCipherPolicyName = mapped
    }

    internal fun build(): GetTlsCipherPoliciesPlainArgs = GetTlsCipherPoliciesPlainArgs(
        ids = ids,
        includeListener = includeListener,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        tlsCipherPolicyName = tlsCipherPolicyName,
    )
}
