@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.GetZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getZones.
 * @property availableSlbAddressIpVersion Filter the results by a slb instance address version. Can be either `ipv4`, or `ipv6`.
 * @property availableSlbAddressType Filter the results by a slb instance network type. Valid values:
 * * vpc: an internal SLB instance that is deployed in a virtual private cloud (VPC).
 * * classic_internet: a public-facing SLB instance.
 * * classic_intranet: an internal SLB instance that is deployed in a classic network.
 * @property enableDetails Default to false and only output `id` in the `zones` block. Set it to true can output more details.
 * @property masterZoneId The primary zone.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property slaveZoneId The secondary zone.
 */
public data class GetZonesPlainArgs(
    public val availableSlbAddressIpVersion: String? = null,
    public val availableSlbAddressType: String? = null,
    @Deprecated(
        message = """
  The parameter enable_details has been deprecated from version v1.154.0+
  """,
    )
    public val enableDetails: Boolean? = null,
    public val masterZoneId: String? = null,
    public val outputFile: String? = null,
    public val slaveZoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.GetZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.GetZonesPlainArgs =
        com.pulumi.alicloud.slb.inputs.GetZonesPlainArgs.builder()
            .availableSlbAddressIpVersion(availableSlbAddressIpVersion?.let({ args0 -> args0 }))
            .availableSlbAddressType(availableSlbAddressType?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .masterZoneId(masterZoneId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .slaveZoneId(slaveZoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetZonesPlainArgs].
 */
@PulumiTagMarker
public class GetZonesPlainArgsBuilder internal constructor() {
    private var availableSlbAddressIpVersion: String? = null

    private var availableSlbAddressType: String? = null

    private var enableDetails: Boolean? = null

    private var masterZoneId: String? = null

    private var outputFile: String? = null

    private var slaveZoneId: String? = null

    /**
     * @param value Filter the results by a slb instance address version. Can be either `ipv4`, or `ipv6`.
     */
    @JvmName("ysprotkygwfdpvba")
    public suspend fun availableSlbAddressIpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availableSlbAddressIpVersion = mapped
    }

    /**
     * @param value Filter the results by a slb instance network type. Valid values:
     * * vpc: an internal SLB instance that is deployed in a virtual private cloud (VPC).
     * * classic_internet: a public-facing SLB instance.
     * * classic_intranet: an internal SLB instance that is deployed in a classic network.
     */
    @JvmName("jmfeqeontldexjck")
    public suspend fun availableSlbAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availableSlbAddressType = mapped
    }

    /**
     * @param value Default to false and only output `id` in the `zones` block. Set it to true can output more details.
     */
    @Deprecated(
        message = """
  The parameter enable_details has been deprecated from version v1.154.0+
  """,
    )
    @JvmName("froovytpkylppbqe")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value The primary zone.
     */
    @JvmName("vmgsftkjingqgqat")
    public suspend fun masterZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.masterZoneId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("viprptmrmksmpwbc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The secondary zone.
     */
    @JvmName("xkdvxhufbmkdyuks")
    public suspend fun slaveZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.slaveZoneId = mapped
    }

    internal fun build(): GetZonesPlainArgs = GetZonesPlainArgs(
        availableSlbAddressIpVersion = availableSlbAddressIpVersion,
        availableSlbAddressType = availableSlbAddressType,
        enableDetails = enableDetails,
        masterZoneId = masterZoneId,
        outputFile = outputFile,
        slaveZoneId = slaveZoneId,
    )
}
