@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.ListenerXForwardedForArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property retriveClientIp Whether to retrieve the client ip.
 * @property retriveSlbId Indicates whether the SLB-ID header is used to retrieve the ID of the CLB instance. Default value: `false`. Valid values: `true`, `false`.
 * @property retriveSlbIp Indicates whether the SLB-IP header is used to retrieve the virtual IP address (VIP) requested by the client. Default value: `false`. Valid values: `true`, `false`.
 * @property retriveSlbProto Specifies whether to use the X-Forwarded-Proto header to retrieve the listener protocol. Default value: `false`. Valid values: `true`, `false`.
 */
public data class ListenerXForwardedForArgs(
    public val retriveClientIp: Output<Boolean>? = null,
    public val retriveSlbId: Output<Boolean>? = null,
    public val retriveSlbIp: Output<Boolean>? = null,
    public val retriveSlbProto: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.ListenerXForwardedForArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.ListenerXForwardedForArgs =
        com.pulumi.alicloud.slb.inputs.ListenerXForwardedForArgs.builder()
            .retriveClientIp(retriveClientIp?.applyValue({ args0 -> args0 }))
            .retriveSlbId(retriveSlbId?.applyValue({ args0 -> args0 }))
            .retriveSlbIp(retriveSlbIp?.applyValue({ args0 -> args0 }))
            .retriveSlbProto(retriveSlbProto?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerXForwardedForArgs].
 */
@PulumiTagMarker
public class ListenerXForwardedForArgsBuilder internal constructor() {
    private var retriveClientIp: Output<Boolean>? = null

    private var retriveSlbId: Output<Boolean>? = null

    private var retriveSlbIp: Output<Boolean>? = null

    private var retriveSlbProto: Output<Boolean>? = null

    /**
     * @param value Whether to retrieve the client ip.
     */
    @JvmName("yewiegfhtxbqdlog")
    public suspend fun retriveClientIp(`value`: Output<Boolean>) {
        this.retriveClientIp = value
    }

    /**
     * @param value Indicates whether the SLB-ID header is used to retrieve the ID of the CLB instance. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("wrblulxllbqaptot")
    public suspend fun retriveSlbId(`value`: Output<Boolean>) {
        this.retriveSlbId = value
    }

    /**
     * @param value Indicates whether the SLB-IP header is used to retrieve the virtual IP address (VIP) requested by the client. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("scrmyqqhdbixfpll")
    public suspend fun retriveSlbIp(`value`: Output<Boolean>) {
        this.retriveSlbIp = value
    }

    /**
     * @param value Specifies whether to use the X-Forwarded-Proto header to retrieve the listener protocol. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("qcdbohlqsmhtrntv")
    public suspend fun retriveSlbProto(`value`: Output<Boolean>) {
        this.retriveSlbProto = value
    }

    /**
     * @param value Whether to retrieve the client ip.
     */
    @JvmName("nopykcsidmynvloa")
    public suspend fun retriveClientIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retriveClientIp = mapped
    }

    /**
     * @param value Indicates whether the SLB-ID header is used to retrieve the ID of the CLB instance. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("cpweknpbkukenwbp")
    public suspend fun retriveSlbId(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retriveSlbId = mapped
    }

    /**
     * @param value Indicates whether the SLB-IP header is used to retrieve the virtual IP address (VIP) requested by the client. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("obdsyamgeogxxemn")
    public suspend fun retriveSlbIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retriveSlbIp = mapped
    }

    /**
     * @param value Specifies whether to use the X-Forwarded-Proto header to retrieve the listener protocol. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("mqnabkfagqwmxfpe")
    public suspend fun retriveSlbProto(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retriveSlbProto = mapped
    }

    internal fun build(): ListenerXForwardedForArgs = ListenerXForwardedForArgs(
        retriveClientIp = retriveClientIp,
        retriveSlbId = retriveSlbId,
        retriveSlbIp = retriveSlbIp,
        retriveSlbProto = retriveSlbProto,
    )
}
