@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.MasterSlaveServerGroupServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property isBackup
 * @property port
 * @property serverId
 * @property serverType
 * @property type
 * @property weight
 */
public data class MasterSlaveServerGroupServerArgs(
    public val isBackup: Output<Int>? = null,
    public val port: Output<Int>,
    public val serverId: Output<String>,
    public val serverType: Output<String>? = null,
    public val type: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.MasterSlaveServerGroupServerArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.MasterSlaveServerGroupServerArgs =
        com.pulumi.alicloud.slb.inputs.MasterSlaveServerGroupServerArgs.builder()
            .isBackup(isBackup?.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .serverId(serverId.applyValue({ args0 -> args0 }))
            .serverType(serverType?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MasterSlaveServerGroupServerArgs].
 */
@PulumiTagMarker
public class MasterSlaveServerGroupServerArgsBuilder internal constructor() {
    private var isBackup: Output<Int>? = null

    private var port: Output<Int>? = null

    private var serverId: Output<String>? = null

    private var serverType: Output<String>? = null

    private var type: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("wytaibpstferexcj")
    public suspend fun isBackup(`value`: Output<Int>) {
        this.isBackup = value
    }

    /**
     * @param value
     */
    @JvmName("ggjppwualhmaeeek")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value
     */
    @JvmName("igqjufvuyakqivwm")
    public suspend fun serverId(`value`: Output<String>) {
        this.serverId = value
    }

    /**
     * @param value
     */
    @JvmName("somnlauaupotjkpt")
    public suspend fun serverType(`value`: Output<String>) {
        this.serverType = value
    }

    /**
     * @param value
     */
    @JvmName("gemucgnqbsgeknfe")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("bbgslteqioowsuyg")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value
     */
    @JvmName("jvjhcdcywxwekwao")
    public suspend fun isBackup(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isBackup = mapped
    }

    /**
     * @param value
     */
    @JvmName("bprtmpughgjejjuw")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("kvthqaydfdagwkbo")
    public suspend fun serverId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverId = mapped
    }

    /**
     * @param value
     */
    @JvmName("mmtqtjpvkqitgxbq")
    public suspend fun serverType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverType = mapped
    }

    /**
     * @param value
     */
    @JvmName("dgjfbmvdaetggosj")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("jyrljcosbgabxiok")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): MasterSlaveServerGroupServerArgs = MasterSlaveServerGroupServerArgs(
        isBackup = isBackup,
        port = port ?: throw PulumiNullFieldException("port"),
        serverId = serverId ?: throw PulumiNullFieldException("serverId"),
        serverType = serverType,
        type = type,
        weight = weight,
    )
}
