@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.inputs

import com.pulumi.alicloud.slb.inputs.ServerGroupServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property port The port used by the backend server. Valid values: `1` to `65535`.
 * @property serverIds The list of Elastic Compute Service (ECS) Ids or Elastic Network Interface (ENI) Ids.
 * @property type Specify the type of the backend server. Default value: `ecs`. Valid values: `ecs`, `eni`.
 * @property weight Weight of the backend server. Default value: `100`. Valid values: `0` to `100`.
 */
public data class ServerGroupServerArgs(
    public val port: Output<Int>,
    public val serverIds: Output<List<String>>,
    public val type: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.slb.inputs.ServerGroupServerArgs> {
    override fun toJava(): com.pulumi.alicloud.slb.inputs.ServerGroupServerArgs =
        com.pulumi.alicloud.slb.inputs.ServerGroupServerArgs.builder()
            .port(port.applyValue({ args0 -> args0 }))
            .serverIds(serverIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerGroupServerArgs].
 */
@PulumiTagMarker
public class ServerGroupServerArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var serverIds: Output<List<String>>? = null

    private var type: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The port used by the backend server. Valid values: `1` to `65535`.
     */
    @JvmName("tpqpfrediquwkxlj")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The list of Elastic Compute Service (ECS) Ids or Elastic Network Interface (ENI) Ids.
     */
    @JvmName("sqckgssrthpyxcra")
    public suspend fun serverIds(`value`: Output<List<String>>) {
        this.serverIds = value
    }

    @JvmName("lcvsmylalpknooty")
    public suspend fun serverIds(vararg values: Output<String>) {
        this.serverIds = Output.all(values.asList())
    }

    /**
     * @param values The list of Elastic Compute Service (ECS) Ids or Elastic Network Interface (ENI) Ids.
     */
    @JvmName("vgkttvjmxnfbndda")
    public suspend fun serverIds(values: List<Output<String>>) {
        this.serverIds = Output.all(values)
    }

    /**
     * @param value Specify the type of the backend server. Default value: `ecs`. Valid values: `ecs`, `eni`.
     */
    @JvmName("cckodtbbqhlhtpyy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Weight of the backend server. Default value: `100`. Valid values: `0` to `100`.
     */
    @JvmName("wlykkmqgryymggyu")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The port used by the backend server. Valid values: `1` to `65535`.
     */
    @JvmName("klonarajxlxjlhie")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The list of Elastic Compute Service (ECS) Ids or Elastic Network Interface (ENI) Ids.
     */
    @JvmName("jjoqbvrusfrgmaeo")
    public suspend fun serverIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverIds = mapped
    }

    /**
     * @param values The list of Elastic Compute Service (ECS) Ids or Elastic Network Interface (ENI) Ids.
     */
    @JvmName("xsklgvrjqwdqvxmc")
    public suspend fun serverIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverIds = mapped
    }

    /**
     * @param value Specify the type of the backend server. Default value: `ecs`. Valid values: `ecs`, `eni`.
     */
    @JvmName("dtbrifnijwhnnpbb")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Weight of the backend server. Default value: `100`. Valid values: `0` to `100`.
     */
    @JvmName("geoispiswusoconq")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ServerGroupServerArgs = ServerGroupServerArgs(
        port = port ?: throw PulumiNullFieldException("port"),
        serverIds = serverIds ?: throw PulumiNullFieldException("serverIds"),
        type = type,
        weight = weight,
    )
}
