@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property entryLists A list of entry (IP addresses or CIDR blocks).  Each entry contains two sub-fields as `Entry Block` follows.
 * @property id Acl ID.
 * @property ipVersion
 * @property name Acl name.
 * @property relatedListeners A list of listener are attached by the acl.  Each listener contains four sub-fields as `Listener Block` follows.
 * @property resourceGroupId The Id of resource group which acl belongs.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetAclsAcl(
    public val entryLists: List<GetAclsAclEntryList>,
    public val id: String,
    public val ipVersion: String,
    public val name: String,
    public val relatedListeners: List<GetAclsAclRelatedListener>,
    public val resourceGroupId: String,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetAclsAcl): GetAclsAcl =
            GetAclsAcl(
                entryLists = javaType.entryLists().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.slb.kotlin.outputs.GetAclsAclEntryList.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                ipVersion = javaType.ipVersion(),
                name = javaType.name(),
                relatedListeners = javaType.relatedListeners().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.slb.kotlin.outputs.GetAclsAclRelatedListener.Companion.toKotlin(args0)
                    })
                }),
                resourceGroupId = javaType.resourceGroupId(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
