@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property address Service address of the SLBs.
 * @property addressIpVersion The address ip version. Valid values `ipv4` and `ipv6`.
 * @property addressType The address type of the SLB. Valid values `internet` and `intranet`.
 * @property autoReleaseTime The auto release time.
 * @property backendServers The backend servers of the SLB.
 * @property bandwidth The bandwidth of the SLB.
 * @property createTimeStamp The create time stamp of the SLB.
 * @property deleteProtection Whether the SLB should delete protection.
 * @property endTime The end time of the SLB.
 * @property endTimeStamp The end time stamp of the SLB.
 * @property id ID of the SLB.
 * @property internetChargeType The internet charge type. Valid values `PayByBandwidth` and `PayByTraffic`.
 * @property listenerPortsAndProtocals The listener ports and protocal of the SLB.
 * @property listenerPortsAndProtocols The listener ports and protocol of the SLB.
 * @property loadBalancerId Thd ID of the SLB.
 * @property loadBalancerName The name of the SLB.
 * @property loadBalancerSpec The specification of the SLB.
 * @property masterZoneId The master zone id of the SLB.
 * @property modificationProtectionReason The reason of modification protection.
 * @property modificationProtectionStatus The status of modification protection.
 * @property networkType Network type of the SLBs. Valid values: `vpc` and `classic`.
 * @property paymentType The payment type of SLB. Valid values `PayAsYouGo` and `Subscription`.
 * @property regionIdAlias Region ID the SLB belongs to.
 * @property renewalCycUnit The renewal cyc unit of the SLB.
 * @property renewalDuration The renewal duration of the SLB.
 * @property renewalStatus The renewal status of the SLB.
 * @property resourceGroupId The Id of resource group which SLB belongs.
 * @property slaveZoneId The slave zone id of the SLB.
 * @property status SLB current status. Possible values: `inactive`, `active` and `locked`.
 * @property tags A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
 * @property vpcId ID of the VPC linked to the SLBs.
 * @property vswitchId ID of the vSwitch linked to the SLBs.
 */
public data class GetApplicationLoadBalancersBalancer(
    public val address: String,
    public val addressIpVersion: String,
    public val addressType: String,
    public val autoReleaseTime: Int,
    public val backendServers: List<GetApplicationLoadBalancersBalancerBackendServer>,
    public val bandwidth: Int,
    public val createTimeStamp: Int,
    public val deleteProtection: String,
    public val endTime: String,
    public val endTimeStamp: Int,
    public val id: String,
    public val internetChargeType: String,
    public val listenerPortsAndProtocals: List<GetApplicationLoadBalancersBalancerListenerPortsAndProtocal>,
    public val listenerPortsAndProtocols: List<GetApplicationLoadBalancersBalancerListenerPortsAndProtocol>,
    public val loadBalancerId: String,
    public val loadBalancerName: String,
    public val loadBalancerSpec: String,
    public val masterZoneId: String,
    public val modificationProtectionReason: String,
    public val modificationProtectionStatus: String,
    public val networkType: String,
    public val paymentType: String,
    public val regionIdAlias: String,
    public val renewalCycUnit: String,
    public val renewalDuration: Int,
    public val renewalStatus: String,
    public val resourceGroupId: String,
    public val slaveZoneId: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetApplicationLoadBalancersBalancer): GetApplicationLoadBalancersBalancer = GetApplicationLoadBalancersBalancer(
            address = javaType.address(),
            addressIpVersion = javaType.addressIpVersion(),
            addressType = javaType.addressType(),
            autoReleaseTime = javaType.autoReleaseTime(),
            backendServers = javaType.backendServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetApplicationLoadBalancersBalancerBackendServer.Companion.toKotlin(args0)
                })
            }),
            bandwidth = javaType.bandwidth(),
            createTimeStamp = javaType.createTimeStamp(),
            deleteProtection = javaType.deleteProtection(),
            endTime = javaType.endTime(),
            endTimeStamp = javaType.endTimeStamp(),
            id = javaType.id(),
            internetChargeType = javaType.internetChargeType(),
            listenerPortsAndProtocals = javaType.listenerPortsAndProtocals().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetApplicationLoadBalancersBalancerListenerPortsAndProtocal.Companion.toKotlin(args0)
                })
            }),
            listenerPortsAndProtocols = javaType.listenerPortsAndProtocols().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetApplicationLoadBalancersBalancerListenerPortsAndProtocol.Companion.toKotlin(args0)
                })
            }),
            loadBalancerId = javaType.loadBalancerId(),
            loadBalancerName = javaType.loadBalancerName(),
            loadBalancerSpec = javaType.loadBalancerSpec(),
            masterZoneId = javaType.masterZoneId(),
            modificationProtectionReason = javaType.modificationProtectionReason(),
            modificationProtectionStatus = javaType.modificationProtectionStatus(),
            networkType = javaType.networkType(),
            paymentType = javaType.paymentType(),
            regionIdAlias = javaType.regionIdAlias(),
            renewalCycUnit = javaType.renewalCycUnit(),
            renewalDuration = javaType.renewalDuration(),
            renewalStatus = javaType.renewalStatus(),
            resourceGroupId = javaType.resourceGroupId(),
            slaveZoneId = javaType.slaveZoneId(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
