@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getApplicationLoadBalancers.
 * @property address The IP address that the SLB instance uses to provide services.
 * @property addressIpVersion The address ip version.
 * @property addressType The address type.
 * @property balancers A list of SLBs. Each element contains the following attributes:
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of slb IDs.
 * @property internetChargeType The billing method of the Internet-facing SLB instance.
 * @property loadBalancerName The name of the SLB.
 * @property masterZoneId Master availability zone of the SLBs.
 * @property nameRegex
 * @property names A list of slb names.
 * @property networkType Network type of the SLB. Possible values: `vpc` and `classic`.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property paymentType
 * @property resourceGroupId The ID of the resource group.
 * @property serverId The ID of the Elastic Compute Service (ECS) instance that is specified as a backend server of the CLB instance.
 * @property serverIntranetAddress
 * @property slaveZoneId Slave availability zone of the SLBs.
 * @property slbs
 * @property status SLB current status. Possible values: `inactive`, `active` and `locked`.
 * @property tags The tags of the SLB.
 * @property totalCount
 * @property vpcId ID of the VPC the SLB belongs to.
 * @property vswitchId ID of the vSwitch the SLB belongs to.
 */
public data class GetApplicationLoadBalancersResult(
    public val address: String? = null,
    public val addressIpVersion: String? = null,
    public val addressType: String? = null,
    public val balancers: List<GetApplicationLoadBalancersBalancer>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val internetChargeType: String? = null,
    public val loadBalancerName: String? = null,
    public val masterZoneId: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val networkType: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val paymentType: String? = null,
    public val resourceGroupId: String? = null,
    public val serverId: String? = null,
    public val serverIntranetAddress: String? = null,
    public val slaveZoneId: String? = null,
    @Deprecated(
        message = """
  Field 'slbs' has deprecated from v1.123.1 and replace by 'balancers'.
  """,
    )
    public val slbs: List<GetApplicationLoadBalancersSlb>,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val totalCount: Int,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetApplicationLoadBalancersResult): GetApplicationLoadBalancersResult = GetApplicationLoadBalancersResult(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            addressIpVersion = javaType.addressIpVersion().map({ args0 -> args0 }).orElse(null),
            addressType = javaType.addressType().map({ args0 -> args0 }).orElse(null),
            balancers = javaType.balancers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetApplicationLoadBalancersBalancer.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            internetChargeType = javaType.internetChargeType().map({ args0 -> args0 }).orElse(null),
            loadBalancerName = javaType.loadBalancerName().map({ args0 -> args0 }).orElse(null),
            masterZoneId = javaType.masterZoneId().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            networkType = javaType.networkType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            paymentType = javaType.paymentType().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            serverId = javaType.serverId().map({ args0 -> args0 }).orElse(null),
            serverIntranetAddress = javaType.serverIntranetAddress().map({ args0 -> args0 }).orElse(null),
            slaveZoneId = javaType.slaveZoneId().map({ args0 -> args0 }).orElse(null),
            slbs = javaType.slbs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetApplicationLoadBalancersSlb.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalCount = javaType.totalCount(),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
