@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property address Service address of the SLBs.
 * @property creationTime
 * @property id ID of the SLB.
 * @property internet
 * @property masterAvailabilityZone
 * @property name
 * @property networkType Network type of the SLBs. Valid values: `vpc` and `classic`.
 * @property regionId
 * @property slaveAvailabilityZone
 * @property status SLB current status. Possible values: `inactive`, `active` and `locked`.
 * @property tags A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
 * @property vpcId ID of the VPC linked to the SLBs.
 * @property vswitchId ID of the vSwitch linked to the SLBs.
 */
public data class GetApplicationLoadBalancersSlb(
    public val address: String,
    public val creationTime: String,
    public val id: String,
    public val internet: Boolean,
    public val masterAvailabilityZone: String,
    public val name: String,
    public val networkType: String,
    public val regionId: String,
    public val slaveAvailabilityZone: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetApplicationLoadBalancersSlb): GetApplicationLoadBalancersSlb = GetApplicationLoadBalancersSlb(
            address = javaType.address(),
            creationTime = javaType.creationTime(),
            id = javaType.id(),
            internet = javaType.internet(),
            masterAvailabilityZone = javaType.masterAvailabilityZone(),
            name = javaType.name(),
            networkType = javaType.networkType(),
            regionId = javaType.regionId(),
            slaveAvailabilityZone = javaType.slaveAvailabilityZone(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
