@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAttachments.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceIds
 * @property loadBalancerId
 * @property outputFile
 * @property slbAttachments A list of SLB attachments. Each element contains the following attributes:
 */
public data class GetAttachmentsResult(
    public val id: String,
    public val instanceIds: List<String>? = null,
    public val loadBalancerId: String,
    public val outputFile: String? = null,
    public val slbAttachments: List<GetAttachmentsSlbAttachment>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetAttachmentsResult): GetAttachmentsResult = GetAttachmentsResult(
            id = javaType.id(),
            instanceIds = javaType.instanceIds().map({ args0 -> args0 }),
            loadBalancerId = javaType.loadBalancerId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            slbAttachments = javaType.slbAttachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetAttachmentsSlbAttachment.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
