@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBackendServers.
 * @property backendServers
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property loadBalancerId
 * @property outputFile
 */
public data class GetBackendServersResult(
    public val backendServers: List<GetBackendServersBackendServer>,
    public val id: String,
    public val ids: List<String>,
    public val loadBalancerId: String,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetBackendServersResult): GetBackendServersResult = GetBackendServersResult(
            backendServers = javaType.backendServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetBackendServersBackendServer.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            loadBalancerId = javaType.loadBalancerId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
