@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property caCertificateId (Available in v1.123.1+) CA certificate ID.
 * @property caCertificateName (Available in v1.123.1+) CA certificate name.
 * @property commonName CA certificate common name.
 * @property createdTimestamp CA certificate created timestamp.
 * @property expiredTime CA certificate expired time.
 * @property expiredTimestamp CA certificate expired timestamp.
 * @property fingerprint CA certificate fingerprint.
 * @property id CA certificate ID.
 * @property name (Deprecated from v1.123.1) Deprecated and replace by `ca_certificate_name`.
 * @property resourceGroupId The Id of resource group which ca certificates belongs.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetCaCertificatesCertificate(
    public val caCertificateId: String,
    public val caCertificateName: String,
    public val commonName: String,
    public val createdTimestamp: Int,
    public val expiredTime: String,
    public val expiredTimestamp: Int,
    public val fingerprint: String,
    public val id: String,
    public val name: String,
    public val resourceGroupId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetCaCertificatesCertificate): GetCaCertificatesCertificate = GetCaCertificatesCertificate(
            caCertificateId = javaType.caCertificateId(),
            caCertificateName = javaType.caCertificateName(),
            commonName = javaType.commonName(),
            createdTimestamp = javaType.createdTimestamp(),
            expiredTime = javaType.expiredTime(),
            expiredTimestamp = javaType.expiredTimestamp(),
            fingerprint = javaType.fingerprint(),
            id = javaType.id(),
            name = javaType.name(),
            resourceGroupId = javaType.resourceGroupId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
