@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domain The domain name.
 * @property id The ID of the domain extension.
 * @property serverCertificateId The ID of the certificate used by the domain name.
 */
public data class GetDomainExtensionsExtension(
    public val domain: String,
    public val id: String,
    public val serverCertificateId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetDomainExtensionsExtension): GetDomainExtensionsExtension = GetDomainExtensionsExtension(
            domain = javaType.domain(),
            id = javaType.id(),
            serverCertificateId = javaType.serverCertificateId(),
        )
    }
}
