@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDomainExtensions.
 * @property extensions A list of SLB domain extension. Each element contains the following attributes:
 * @property frontendPort
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property loadBalancerId
 * @property outputFile
 */
public data class GetDomainExtensionsResult(
    public val extensions: List<GetDomainExtensionsExtension>,
    public val frontendPort: Int,
    public val id: String,
    public val ids: List<String>,
    public val loadBalancerId: String,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetDomainExtensionsResult): GetDomainExtensionsResult = GetDomainExtensionsResult(
            extensions = javaType.extensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetDomainExtensionsExtension.Companion.toKotlin(args0)
                })
            }),
            frontendPort = javaType.frontendPort(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            loadBalancerId = javaType.loadBalancerId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
