@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getListeners.
 * @property descriptionRegex
 * @property frontendPort Frontend port used to receive incoming traffic and distribute it to the backend servers.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property loadBalancerId
 * @property outputFile
 * @property protocol Listener protocol. Possible values: `http`, `https`, `tcp` and `udp`.
 * @property slbListeners A list of SLB listeners. Each element contains the following attributes:
 */
public data class GetListenersResult(
    public val descriptionRegex: String? = null,
    public val frontendPort: Int? = null,
    public val id: String,
    public val loadBalancerId: String,
    public val outputFile: String? = null,
    public val protocol: String? = null,
    public val slbListeners: List<GetListenersSlbListener>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetListenersResult): GetListenersResult = GetListenersResult(
            descriptionRegex = javaType.descriptionRegex().map({ args0 -> args0 }).orElse(null),
            frontendPort = javaType.frontendPort().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            loadBalancerId = javaType.loadBalancerId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            slbListeners = javaType.slbListeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetListenersSlbListener.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
