@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property backendPort Port opened on the backend server to receive requests.
 * @property bandwidth Peak bandwidth. If the value is set to -1, the listener is not limited by bandwidth.
 * @property caCertificateId ID of the CA certificate (only required when two-way authentication is used). Only available when the protocol is `https`.
 * @property cookie Cookie configured by the backend server. Only available when the sticky_session_type is `server`.
 * @property cookieTimeout Cookie timeout in seconds. Only available when the sticky_session_type is `insert`.
 * @property description The description of slb listener.
 * @property enableHttp2 Whether to enable https listener support http2 or not. Valid values are `on` and `off`. Default to `on`.
 * @property establishedTimeout Connection timeout in seconds for the Layer 4 TCP listener. Only available when the protocol is `tcp`.
 * @property frontendPort Filter listeners by the specified frontend port.
 * @property gzip Indicate whether Gzip compression is enabled or not. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
 * @property healthCheck Indicate whether health check is enabled of not. Possible values are `on` and `off`.
 * @property healthCheckConnectPort Port used for health check.
 * @property healthCheckConnectTimeout Amount of time in seconds to wait for the response for a health check.
 * @property healthCheckDomain Domain name used for health check. The SLB sends HTTP head requests to the backend server, the domain is useful when the backend server verifies the host field in the requests. Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
 * @property healthCheckHttpCode HTTP status codes indicating that the health check is normal. It can contain several comma-separated values such as "http_2xx,http_3xx". Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
 * @property healthCheckInterval Time interval between two consecutive health checks.
 * @property healthCheckTimeout Amount of time in seconds to wait for the response from a health check. If an ECS instance sends no response within the specified timeout period, the health check fails. Only available when the protocol is `http` or `https`.
 * @property healthCheckType Health check method. Possible values are `tcp` and `http`. Only available when the protocol is `tcp`.
 * @property healthCheckUri URI used for health check. Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
 * @property healthyThreshold Number of consecutive successes of health check performed on the same ECS instance (from failure to success).
 * @property idleTimeout Timeout of http or https listener established connection idle timeout. Valid value range: [1-60] in seconds. Default to 15.
 * @property masterSlaveServerGroupId ID of the active/standby server group.
 * @property persistenceTimeout Timeout value of the TCP connection in seconds. If the value is 0, the session persistence function is disabled. Only available when the protocol is `tcp`.
 * @property protocol Filter listeners by the specified protocol. Valid values: `http`, `https`, `tcp` and `udp`.
 * @property proxyProtocolV2Enabled Whether to support carrying the client source address to the backend server through the Proxy Protocol. Valid values are `true` and `false`. Default to `false`.
 * @property requestTimeout Timeout of http or https listener request (which does not get response from backend) timeout. Valid value range: [1-180] in seconds. Default to 60.
 * @property scheduler Algorithm used to distribute traffic. Possible values: `wrr` (weighted round robin), `wlc` (weighted least connection) and `rr` (round robin).
 * @property securityStatus Security status. Only available when the protocol is `https`.
 * @property serverCertificateId
 * @property serverGroupId ID of the linked VServer group.
 * @property sslCertificateId ID of the server certificate. Only available when the protocol is `https`.
 * @property status Listener status.
 * @property stickySession Indicate whether session persistence is enabled or not. If enabled, all session requests from the same client are sent to the same backend server. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
 * @property stickySessionType Method used to handle the cookie. Possible values are `insert` (cookie added to the response) and `server` (cookie set by the backend server). Only available when the protocol is `http` or `https` and sticky_session is `on`.
 * @property tlsCipherPolicy Https listener TLS cipher policy. Valid values are `tls_cipher_policy_1_0`, `tls_cipher_policy_1_1`, `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`. Default to `tls_cipher_policy_1_0`.
 * @property unhealthyThreshold Number of consecutive failures of health check performed on the same ECS instance (from success to failure).
 * @property xForwardedFor Indicate whether the HTTP header field "X-Forwarded-For" is added or not; it allows the backend server to know about the user's IP address. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
 * @property xForwardedForSlbId Indicate whether the HTTP header field "X-Forwarded-For_SLBID" is added or not; it allows the backend server to know about the SLB ID. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
 * @property xForwardedForSlbIp Indicate whether the HTTP header field "X-Forwarded-For_SLBIP" is added or not; it allows the backend server to know about the SLB IP address. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
 * @property xForwardedForSlbProto Indicate whether the HTTP header field "X-Forwarded-For_proto" is added or not; it allows the backend server to know about the user's protocol. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
 */
public data class GetListenersSlbListener(
    public val backendPort: Int,
    public val bandwidth: Int,
    public val caCertificateId: String,
    public val cookie: String,
    public val cookieTimeout: Int,
    public val description: String,
    public val enableHttp2: String,
    public val establishedTimeout: Int,
    public val frontendPort: Int,
    public val gzip: String,
    public val healthCheck: String,
    public val healthCheckConnectPort: Int,
    public val healthCheckConnectTimeout: Int,
    public val healthCheckDomain: String,
    public val healthCheckHttpCode: String,
    public val healthCheckInterval: Int,
    public val healthCheckTimeout: Int,
    public val healthCheckType: String,
    public val healthCheckUri: String,
    public val healthyThreshold: Int,
    public val idleTimeout: Int,
    public val masterSlaveServerGroupId: String,
    public val persistenceTimeout: Int,
    public val protocol: String,
    public val proxyProtocolV2Enabled: Boolean,
    public val requestTimeout: Int,
    public val scheduler: String,
    public val securityStatus: String,
    public val serverCertificateId: String,
    public val serverGroupId: String,
    public val sslCertificateId: String,
    public val status: String,
    public val stickySession: String,
    public val stickySessionType: String,
    public val tlsCipherPolicy: String,
    public val unhealthyThreshold: Int,
    public val xForwardedFor: String,
    public val xForwardedForSlbId: String,
    public val xForwardedForSlbIp: String,
    public val xForwardedForSlbProto: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetListenersSlbListener): GetListenersSlbListener = GetListenersSlbListener(
            backendPort = javaType.backendPort(),
            bandwidth = javaType.bandwidth(),
            caCertificateId = javaType.caCertificateId(),
            cookie = javaType.cookie(),
            cookieTimeout = javaType.cookieTimeout(),
            description = javaType.description(),
            enableHttp2 = javaType.enableHttp2(),
            establishedTimeout = javaType.establishedTimeout(),
            frontendPort = javaType.frontendPort(),
            gzip = javaType.gzip(),
            healthCheck = javaType.healthCheck(),
            healthCheckConnectPort = javaType.healthCheckConnectPort(),
            healthCheckConnectTimeout = javaType.healthCheckConnectTimeout(),
            healthCheckDomain = javaType.healthCheckDomain(),
            healthCheckHttpCode = javaType.healthCheckHttpCode(),
            healthCheckInterval = javaType.healthCheckInterval(),
            healthCheckTimeout = javaType.healthCheckTimeout(),
            healthCheckType = javaType.healthCheckType(),
            healthCheckUri = javaType.healthCheckUri(),
            healthyThreshold = javaType.healthyThreshold(),
            idleTimeout = javaType.idleTimeout(),
            masterSlaveServerGroupId = javaType.masterSlaveServerGroupId(),
            persistenceTimeout = javaType.persistenceTimeout(),
            protocol = javaType.protocol(),
            proxyProtocolV2Enabled = javaType.proxyProtocolV2Enabled(),
            requestTimeout = javaType.requestTimeout(),
            scheduler = javaType.scheduler(),
            securityStatus = javaType.securityStatus(),
            serverCertificateId = javaType.serverCertificateId(),
            serverGroupId = javaType.serverGroupId(),
            sslCertificateId = javaType.sslCertificateId(),
            status = javaType.status(),
            stickySession = javaType.stickySession(),
            stickySessionType = javaType.stickySessionType(),
            tlsCipherPolicy = javaType.tlsCipherPolicy(),
            unhealthyThreshold = javaType.unhealthyThreshold(),
            xForwardedFor = javaType.xForwardedFor(),
            xForwardedForSlbId = javaType.xForwardedForSlbId(),
            xForwardedForSlbIp = javaType.xForwardedForSlbIp(),
            xForwardedForSlbProto = javaType.xForwardedForSlbProto(),
        )
    }
}
