@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property address Service address of the SLBs.
 * @property addressIpVersion
 * @property addressType
 * @property autoReleaseTime
 * @property backendServers
 * @property bandwidth
 * @property createTimeStamp
 * @property deleteProtection
 * @property endTime
 * @property endTimeStamp
 * @property id ID of the SLB.
 * @property internetChargeType
 * @property listenerPortsAndProtocals
 * @property listenerPortsAndProtocols
 * @property loadBalancerId
 * @property loadBalancerName
 * @property loadBalancerSpec
 * @property masterZoneId
 * @property modificationProtectionReason
 * @property modificationProtectionStatus
 * @property networkType Network type of the SLBs. Valid values: `vpc` and `classic`.
 * @property paymentType
 * @property regionIdAlias
 * @property renewalCycUnit
 * @property renewalDuration
 * @property renewalStatus
 * @property resourceGroupId The Id of resource group which SLB belongs.
 * @property slaveZoneId
 * @property status SLB current status. Possible values: `inactive`, `active` and `locked`.
 * @property tags A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const taggedInstances = alicloud.slb.getLoadBalancers({
 *     tags: {
 *         tagKey1: "tagValue1",
 *         tagKey2: "tagValue2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * tagged_instances = alicloud.slb.get_load_balancers(tags={
 *     "tagKey1": "tagValue1",
 *     "tagKey2": "tagValue2",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var taggedInstances = AliCloud.Slb.GetLoadBalancers.Invoke(new()
 *     {
 *         Tags =
 *         {
 *             { "tagKey1", "tagValue1" },
 *             { "tagKey2", "tagValue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := slb.GetLoadBalancers(ctx, &slb.GetLoadBalancersArgs{
 * 			Tags: map[string]interface{}{
 * 				"tagKey1": "tagValue1",
 * 				"tagKey2": "tagValue2",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.slb.SlbFunctions;
 * import com.pulumi.alicloud.slb.inputs.GetLoadBalancersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var taggedInstances = SlbFunctions.getLoadBalancers(GetLoadBalancersArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("tagKey1", "tagValue1"),
 *                 Map.entry("tagKey2", "tagValue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   taggedInstances:
 *     fn::invoke:
 *       Function: alicloud:slb:getLoadBalancers
 *       Arguments:
 *         tags:
 *           tagKey1: tagValue1
 *           tagKey2: tagValue2
 * ```
 * <!--End PulumiCodeChooser -->
 * @property vpcId ID of the VPC linked to the SLBs.
 * @property vswitchId ID of the vSwitch linked to the SLBs.
 */
public data class GetLoadBalancersBalancer(
    public val address: String,
    public val addressIpVersion: String,
    public val addressType: String,
    public val autoReleaseTime: Int,
    public val backendServers: List<GetLoadBalancersBalancerBackendServer>,
    public val bandwidth: Int,
    public val createTimeStamp: Int,
    public val deleteProtection: String,
    public val endTime: String,
    public val endTimeStamp: Int,
    public val id: String,
    public val internetChargeType: String,
    public val listenerPortsAndProtocals: List<GetLoadBalancersBalancerListenerPortsAndProtocal>,
    public val listenerPortsAndProtocols: List<GetLoadBalancersBalancerListenerPortsAndProtocol>,
    public val loadBalancerId: String,
    public val loadBalancerName: String,
    public val loadBalancerSpec: String,
    public val masterZoneId: String,
    public val modificationProtectionReason: String,
    public val modificationProtectionStatus: String,
    public val networkType: String,
    public val paymentType: String,
    public val regionIdAlias: String,
    public val renewalCycUnit: String,
    public val renewalDuration: Int,
    public val renewalStatus: String,
    public val resourceGroupId: String,
    public val slaveZoneId: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetLoadBalancersBalancer): GetLoadBalancersBalancer = GetLoadBalancersBalancer(
            address = javaType.address(),
            addressIpVersion = javaType.addressIpVersion(),
            addressType = javaType.addressType(),
            autoReleaseTime = javaType.autoReleaseTime(),
            backendServers = javaType.backendServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetLoadBalancersBalancerBackendServer.Companion.toKotlin(args0)
                })
            }),
            bandwidth = javaType.bandwidth(),
            createTimeStamp = javaType.createTimeStamp(),
            deleteProtection = javaType.deleteProtection(),
            endTime = javaType.endTime(),
            endTimeStamp = javaType.endTimeStamp(),
            id = javaType.id(),
            internetChargeType = javaType.internetChargeType(),
            listenerPortsAndProtocals = javaType.listenerPortsAndProtocals().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetLoadBalancersBalancerListenerPortsAndProtocal.Companion.toKotlin(args0)
                })
            }),
            listenerPortsAndProtocols = javaType.listenerPortsAndProtocols().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetLoadBalancersBalancerListenerPortsAndProtocol.Companion.toKotlin(args0)
                })
            }),
            loadBalancerId = javaType.loadBalancerId(),
            loadBalancerName = javaType.loadBalancerName(),
            loadBalancerSpec = javaType.loadBalancerSpec(),
            masterZoneId = javaType.masterZoneId(),
            modificationProtectionReason = javaType.modificationProtectionReason(),
            modificationProtectionStatus = javaType.modificationProtectionStatus(),
            networkType = javaType.networkType(),
            paymentType = javaType.paymentType(),
            regionIdAlias = javaType.regionIdAlias(),
            renewalCycUnit = javaType.renewalCycUnit(),
            renewalDuration = javaType.renewalDuration(),
            renewalStatus = javaType.renewalStatus(),
            resourceGroupId = javaType.resourceGroupId(),
            slaveZoneId = javaType.slaveZoneId(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
