@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLoadBalancers.
 * @property address Service address of the SLB.
 * @property addressIpVersion
 * @property addressType
 * @property balancers
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of slb IDs.
 * @property internetChargeType
 * @property loadBalancerName
 * @property masterZoneId
 * @property nameRegex
 * @property names A list of slb names.
 * @property networkType Network type of the SLB. Possible values: `vpc` and `classic`.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property paymentType
 * @property resourceGroupId
 * @property serverId
 * @property serverIntranetAddress
 * @property slaveZoneId
 * @property slbs A list of SLBs. Each element contains the following attributes:
 * @property status SLB current status. Possible values: `inactive`, `active` and `locked`.
 * @property tags A map of tags assigned to the SLB instance.
 * @property totalCount
 * @property vpcId ID of the VPC the SLB belongs to.
 * @property vswitchId ID of the vSwitch the SLB belongs to.
 */
public data class GetLoadBalancersResult(
    public val address: String? = null,
    public val addressIpVersion: String? = null,
    public val addressType: String? = null,
    public val balancers: List<GetLoadBalancersBalancer>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val internetChargeType: String? = null,
    public val loadBalancerName: String? = null,
    public val masterZoneId: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val networkType: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val paymentType: String? = null,
    public val resourceGroupId: String? = null,
    public val serverId: String? = null,
    public val serverIntranetAddress: String? = null,
    public val slaveZoneId: String? = null,
    @Deprecated(
        message = """
  Field 'slbs' has deprecated from v1.123.1 and replace by 'balancers'.
  """,
    )
    public val slbs: List<GetLoadBalancersSlb>,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val totalCount: Int,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetLoadBalancersResult): GetLoadBalancersResult = GetLoadBalancersResult(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            addressIpVersion = javaType.addressIpVersion().map({ args0 -> args0 }).orElse(null),
            addressType = javaType.addressType().map({ args0 -> args0 }).orElse(null),
            balancers = javaType.balancers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetLoadBalancersBalancer.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            internetChargeType = javaType.internetChargeType().map({ args0 -> args0 }).orElse(null),
            loadBalancerName = javaType.loadBalancerName().map({ args0 -> args0 }).orElse(null),
            masterZoneId = javaType.masterZoneId().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            networkType = javaType.networkType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            paymentType = javaType.paymentType().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            serverId = javaType.serverId().map({ args0 -> args0 }).orElse(null),
            serverIntranetAddress = javaType.serverIntranetAddress().map({ args0 -> args0 }).orElse(null),
            slaveZoneId = javaType.slaveZoneId().map({ args0 -> args0 }).orElse(null),
            slbs = javaType.slbs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetLoadBalancersSlb.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalCount = javaType.totalCount(),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
