@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property address Service address of the SLBs.
 * @property creationTime SLB creation time.
 * @property id ID of the SLB.
 * @property internet SLB addressType: internet if `true`, intranet if `false`. Must be `false` when `network_type` is `vpc`.
 * @property masterAvailabilityZone Master availability zone of the SLBs.
 * @property name SLB name.
 * @property networkType Network type of the SLBs. Valid values: `vpc` and `classic`.
 * @property regionId Region ID the SLB belongs to.
 * @property slaveAvailabilityZone Slave availability zone of the SLBs.
 * @property status SLB current status. Possible values: `inactive`, `active` and `locked`.
 * @property tags A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const taggedInstances = alicloud.slb.getLoadBalancers({
 *     tags: {
 *         tagKey1: "tagValue1",
 *         tagKey2: "tagValue2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * tagged_instances = alicloud.slb.get_load_balancers(tags={
 *     "tagKey1": "tagValue1",
 *     "tagKey2": "tagValue2",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var taggedInstances = AliCloud.Slb.GetLoadBalancers.Invoke(new()
 *     {
 *         Tags =
 *         {
 *             { "tagKey1", "tagValue1" },
 *             { "tagKey2", "tagValue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/slb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := slb.GetLoadBalancers(ctx, &slb.GetLoadBalancersArgs{
 * 			Tags: map[string]interface{}{
 * 				"tagKey1": "tagValue1",
 * 				"tagKey2": "tagValue2",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.slb.SlbFunctions;
 * import com.pulumi.alicloud.slb.inputs.GetLoadBalancersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var taggedInstances = SlbFunctions.getLoadBalancers(GetLoadBalancersArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("tagKey1", "tagValue1"),
 *                 Map.entry("tagKey2", "tagValue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   taggedInstances:
 *     fn::invoke:
 *       Function: alicloud:slb:getLoadBalancers
 *       Arguments:
 *         tags:
 *           tagKey1: tagValue1
 *           tagKey2: tagValue2
 * ```
 * <!--End PulumiCodeChooser -->
 * @property vpcId ID of the VPC linked to the SLBs.
 * @property vswitchId ID of the vSwitch linked to the SLBs.
 */
public data class GetLoadBalancersSlb(
    public val address: String,
    public val creationTime: String,
    public val id: String,
    public val internet: Boolean,
    public val masterAvailabilityZone: String,
    public val name: String,
    public val networkType: String,
    public val regionId: String,
    public val slaveAvailabilityZone: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetLoadBalancersSlb): GetLoadBalancersSlb = GetLoadBalancersSlb(
            address = javaType.address(),
            creationTime = javaType.creationTime(),
            id = javaType.id(),
            internet = javaType.internet(),
            masterAvailabilityZone = javaType.masterAvailabilityZone(),
            name = javaType.name(),
            networkType = javaType.networkType(),
            regionId = javaType.regionId(),
            slaveAvailabilityZone = javaType.slaveAvailabilityZone(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
