@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id master slave server group ID.
 * @property name master slave server group name.
 * @property servers ECS instances associated to the group. Each element contains the following attributes:
 */
public data class GetMasterSlaveServerGroupsGroup(
    public val id: String,
    public val name: String,
    public val servers: List<GetMasterSlaveServerGroupsGroupServer>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetMasterSlaveServerGroupsGroup): GetMasterSlaveServerGroupsGroup = GetMasterSlaveServerGroupsGroup(
            id = javaType.id(),
            name = javaType.name(),
            servers = javaType.servers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetMasterSlaveServerGroupsGroupServer.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
