@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceId ID of the attached ECS instance.
 * @property isBackup (Removed from v1.63.0) Determine if the server is executing.
 * @property port The port used by the master slave server group.
 * @property serverType The server type of the attached ECS instance.
 * @property weight Weight associated to the ECS instance.
 */
public data class GetMasterSlaveServerGroupsGroupServer(
    public val instanceId: String,
    public val isBackup: Int,
    public val port: Int,
    public val serverType: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetMasterSlaveServerGroupsGroupServer): GetMasterSlaveServerGroupsGroupServer = GetMasterSlaveServerGroupsGroupServer(
            instanceId = javaType.instanceId(),
            isBackup = javaType.isBackup(),
            port = javaType.port(),
            serverType = javaType.serverType(),
            weight = javaType.weight(),
        )
    }
}
