@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMasterSlaveServerGroups.
 * @property groups A list of SLB master slave server groups. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of SLB master slave server groups IDs.
 * @property loadBalancerId
 * @property nameRegex
 * @property names A list of SLB master slave server groups names.
 * @property outputFile
 */
public data class GetMasterSlaveServerGroupsResult(
    public val groups: List<GetMasterSlaveServerGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val loadBalancerId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetMasterSlaveServerGroupsResult): GetMasterSlaveServerGroupsResult = GetMasterSlaveServerGroupsResult(
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetMasterSlaveServerGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            loadBalancerId = javaType.loadBalancerId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
