@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRules.
 * @property frontendPort
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of SLB listener rules IDs.
 * @property loadBalancerId
 * @property nameRegex
 * @property names A list of SLB listener rules names.
 * @property outputFile
 * @property slbRules A list of SLB listener rules. Each element contains the following attributes:
 */
public data class GetRulesResult(
    public val frontendPort: Int,
    public val id: String,
    public val ids: List<String>,
    public val loadBalancerId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val slbRules: List<GetRulesSlbRule>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetRulesResult): GetRulesResult =
            GetRulesResult(
                frontendPort = javaType.frontendPort(),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                loadBalancerId = javaType.loadBalancerId(),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                slbRules = javaType.slbRules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.slb.kotlin.outputs.GetRulesSlbRule.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
