@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domain Domain name in the HTTP request where the rule applies (e.g. "*.aliyun.com").
 * @property id Rule ID.
 * @property name Rule name.
 * @property serverGroupId ID of the linked VServer group.
 * @property url Path in the HTTP request where the rule applies (e.g. "/image").
 */
public data class GetRulesSlbRule(
    public val domain: String,
    public val id: String,
    public val name: String,
    public val serverGroupId: String,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetRulesSlbRule): GetRulesSlbRule = GetRulesSlbRule(
            domain = javaType.domain(),
            id = javaType.id(),
            name = javaType.name(),
            serverGroupId = javaType.serverGroupId(),
            url = javaType.url(),
        )
    }
}
