@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property alicloudCertificateId Id of server certificate issued by alibaba cloud.
 * @property alicloudCertificateName Name of server certificate issued by alibaba cloud.
 * @property commonName Server certificate common name.
 * @property createdTime Server certificate created time.
 * @property createdTimestamp Server certificate created timestamp.
 * @property expiredTime Server certificate expired time.
 * @property expiredTimestamp Server certificate expired timestamp.
 * @property fingerprint Server certificate fingerprint.
 * @property id Server certificate ID.
 * @property isAlicloudCertificate Is server certificate issued by alibaba cloud or not.
 * @property name Server certificate name.
 * @property resourceGroupId The Id of resource group which the slb server certificates belongs.
 * @property subjectAlternativeNames Server certificate subject alternative name list.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetServerCertificatesCertificate(
    public val alicloudCertificateId: String,
    public val alicloudCertificateName: String,
    public val commonName: String,
    public val createdTime: String,
    public val createdTimestamp: Int,
    public val expiredTime: String,
    public val expiredTimestamp: Int,
    public val fingerprint: String,
    public val id: String,
    public val isAlicloudCertificate: Boolean,
    public val name: String,
    public val resourceGroupId: String? = null,
    public val subjectAlternativeNames: List<String>,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetServerCertificatesCertificate): GetServerCertificatesCertificate = GetServerCertificatesCertificate(
            alicloudCertificateId = javaType.alicloudCertificateId(),
            alicloudCertificateName = javaType.alicloudCertificateName(),
            commonName = javaType.commonName(),
            createdTime = javaType.createdTime(),
            createdTimestamp = javaType.createdTimestamp(),
            expiredTime = javaType.expiredTime(),
            expiredTimestamp = javaType.expiredTimestamp(),
            fingerprint = javaType.fingerprint(),
            id = javaType.id(),
            isAlicloudCertificate = javaType.isAlicloudCertificate(),
            name = javaType.name(),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            subjectAlternativeNames = javaType.subjectAlternativeNames().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
