@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServerGroups.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of SLB VServer groups IDs.
 * @property loadBalancerId
 * @property nameRegex
 * @property names A list of SLB VServer groups names.
 * @property outputFile
 * @property slbServerGroups A list of SLB VServer groups. Each element contains the following attributes:
 */
public data class GetServerGroupsResult(
    public val id: String,
    public val ids: List<String>,
    public val loadBalancerId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val slbServerGroups: List<GetServerGroupsSlbServerGroup>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetServerGroupsResult): GetServerGroupsResult = GetServerGroupsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            loadBalancerId = javaType.loadBalancerId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            slbServerGroups = javaType.slbServerGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetServerGroupsSlbServerGroup.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
