@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ciphers The encryption algorithms supported. It depends on the value of `tls_versions`.
 * @property createTime The creation time timestamp.
 * @property id The ID of the Tls Cipher Policy.
 * @property relateListeners Array of Relate Listeners.
 * @property status TLS policy instance state.
 * @property tlsCipherPolicyId The ID of TLS cipher policy.
 * @property tlsCipherPolicyName TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
 * @property tlsVersions The version of TLS protocol.
 */
public data class GetTlsCipherPoliciesPolicy(
    public val ciphers: List<String>,
    public val createTime: String,
    public val id: String,
    public val relateListeners: List<GetTlsCipherPoliciesPolicyRelateListener>,
    public val status: String,
    public val tlsCipherPolicyId: String,
    public val tlsCipherPolicyName: String,
    public val tlsVersions: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetTlsCipherPoliciesPolicy): GetTlsCipherPoliciesPolicy = GetTlsCipherPoliciesPolicy(
            ciphers = javaType.ciphers().map({ args0 -> args0 }),
            createTime = javaType.createTime(),
            id = javaType.id(),
            relateListeners = javaType.relateListeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetTlsCipherPoliciesPolicyRelateListener.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            tlsCipherPolicyId = javaType.tlsCipherPolicyId(),
            tlsCipherPolicyName = javaType.tlsCipherPolicyName(),
            tlsVersions = javaType.tlsVersions().map({ args0 -> args0 }),
        )
    }
}
