@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property loadBalancerId The ID of SLB instance.
 * @property port Listening port. Valid value: 1 to 65535.
 * @property protocol Snooping protocols. Valid values: `TCP`, `UDP`, `HTTP`, or `HTTPS`.
 */
public data class GetTlsCipherPoliciesPolicyRelateListener(
    public val loadBalancerId: String,
    public val port: Int,
    public val protocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetTlsCipherPoliciesPolicyRelateListener): GetTlsCipherPoliciesPolicyRelateListener = GetTlsCipherPoliciesPolicyRelateListener(
            loadBalancerId = javaType.loadBalancerId(),
            port = javaType.port(),
            protocol = javaType.protocol(),
        )
    }
}
